/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.builder;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.builder.SearchSourceBuilder;

@PublicApi(since="2.3.0")
public final class PointInTimeBuilder
implements Writeable,
ToXContentObject {
    private static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    private static final ParseField KEEP_ALIVE_FIELD = new ParseField("keep_alive", new String[0]);
    private static final ObjectParser<XContentParams, Void> PARSER = new ObjectParser(SearchSourceBuilder.POINT_IN_TIME.getPreferredName(), XContentParams::new);
    private final String id;
    private TimeValue keepAlive;

    public PointInTimeBuilder(String id) {
        this.id = Objects.requireNonNull(id);
    }

    public PointInTimeBuilder(StreamInput in) throws IOException {
        this.id = in.readString();
        this.keepAlive = in.readOptionalTimeValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeOptionalTimeValue(this.keepAlive);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(SearchSourceBuilder.POINT_IN_TIME.getPreferredName());
        builder.field(ID_FIELD.getPreferredName(), this.id);
        if (this.keepAlive != null) {
            builder.field(KEEP_ALIVE_FIELD.getPreferredName(), this.keepAlive);
        }
        builder.endObject();
        return builder;
    }

    public static PointInTimeBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParams params = PARSER.parse(parser, null);
        if (params.id == null) {
            throw new IllegalArgumentException("point int time id is not provided");
        }
        return new PointInTimeBuilder(params.id).setKeepAlive(params.keepAlive);
    }

    public String getId() {
        return this.id;
    }

    public PointInTimeBuilder setKeepAlive(TimeValue keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    @Nullable
    public TimeValue getKeepAlive() {
        return this.keepAlive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PointInTimeBuilder that = (PointInTimeBuilder)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.keepAlive, that.keepAlive);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.keepAlive);
    }

    static {
        PARSER.declareString((params, id) -> {
            params.id = id;
        }, ID_FIELD);
        PARSER.declareField((params, keepAlive) -> {
            params.keepAlive = keepAlive;
        }, (p, c) -> TimeValue.parseTimeValue(p.text(), KEEP_ALIVE_FIELD.getPreferredName()), KEEP_ALIVE_FIELD, ObjectParser.ValueType.STRING);
    }

    private static final class XContentParams {
        private String id;
        private TimeValue keepAlive;

        private XContentParams() {
        }
    }
}

