/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline;

import java.util.List;
import org.opensearch.action.search.SearchPhaseContext;
import org.opensearch.action.search.SearchPhaseResults;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.search.SearchPhaseResult;
import org.opensearch.search.pipeline.Pipeline;
import org.opensearch.search.pipeline.PipelineProcessingContext;
import org.opensearch.search.pipeline.ProcessorExecutionDetail;

public final class PipelinedRequest
extends SearchRequest {
    private final Pipeline pipeline;
    private final PipelineProcessingContext requestContext;

    PipelinedRequest(Pipeline pipeline, SearchRequest transformedRequest, PipelineProcessingContext requestContext) {
        super(transformedRequest);
        this.pipeline = pipeline;
        this.requestContext = requestContext;
    }

    public void transformRequest(ActionListener<SearchRequest> requestListener) {
        this.pipeline.transformRequest(this, requestListener, this.requestContext);
    }

    public ActionListener<SearchResponse> transformResponseListener(ActionListener<SearchResponse> responseListener) {
        return this.pipeline.transformResponseListener(this, ActionListener.wrap(response -> {
            List<ProcessorExecutionDetail> details = this.requestContext.getProcessorExecutionDetails();
            if (!details.isEmpty() && response.getInternalResponse() != null) {
                response.getInternalResponse().getProcessorResult().addAll(details);
            }
            responseListener.onResponse((SearchResponse)response);
        }, responseListener::onFailure), this.requestContext);
    }

    public <Result extends SearchPhaseResult> void transformSearchPhaseResults(SearchPhaseResults<Result> searchPhaseResult, SearchPhaseContext searchPhaseContext, String currentPhase, String nextPhase) {
        this.pipeline.runSearchPhaseResultsTransformer(searchPhaseResult, searchPhaseContext, currentPhase, nextPhase, this.requestContext);
    }

    Pipeline getPipeline() {
        return this.pipeline;
    }

    public PipelineProcessingContext getPipelineProcessingContext() {
        return this.requestContext;
    }
}

