/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.query;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.opensearch.action.search.SearchShardTask;
import org.opensearch.common.Booleans;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.lucene.search.TopDocsAndMaxScore;
import org.opensearch.common.util.concurrent.EWMATrackingThreadPoolExecutor;
import org.opensearch.core.tasks.TaskCancelledException;
import org.opensearch.lucene.queries.SearchAfterSortedDocQuery;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.SearchContextSourcePrinter;
import org.opensearch.search.SearchService;
import org.opensearch.search.aggregations.AggregationProcessor;
import org.opensearch.search.aggregations.DefaultAggregationProcessor;
import org.opensearch.search.aggregations.GlobalAggCollectorManager;
import org.opensearch.search.internal.ContextIndexSearcher;
import org.opensearch.search.internal.ScrollContext;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.profile.ProfileShardResult;
import org.opensearch.search.profile.SearchProfileShardResults;
import org.opensearch.search.profile.query.InternalProfileCollector;
import org.opensearch.search.query.EarlyTerminatingCollector;
import org.opensearch.search.query.QueryCollectorArguments;
import org.opensearch.search.query.QueryCollectorContext;
import org.opensearch.search.query.QueryCollectorContextSpec;
import org.opensearch.search.query.QueryCollectorContextSpecRegistry;
import org.opensearch.search.query.QueryPhaseExecutionException;
import org.opensearch.search.query.QueryPhaseSearcher;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.search.query.ReduceableSearchResult;
import org.opensearch.search.query.RescoringQueryCollectorContext;
import org.opensearch.search.query.TopDocsCollectorContext;
import org.opensearch.search.rescore.RescoreProcessor;
import org.opensearch.search.sort.SortAndFormats;
import org.opensearch.search.suggest.SuggestProcessor;

@PublicApi(since="1.0.0")
public class QueryPhase {
    private static final Logger LOGGER = LogManager.getLogger(QueryPhase.class);
    public static final boolean SYS_PROP_REWRITE_SORT = Booleans.parseBoolean(System.getProperty("opensearch.search.rewrite_sort", "true"));
    public static final QueryPhaseSearcher DEFAULT_QUERY_PHASE_SEARCHER = new DefaultQueryPhaseSearcher();
    private final QueryPhaseSearcher queryPhaseSearcher;
    private final SuggestProcessor suggestProcessor;
    private final RescoreProcessor rescoreProcessor;

    public QueryPhase() {
        this(DEFAULT_QUERY_PHASE_SEARCHER);
    }

    public QueryPhase(QueryPhaseSearcher queryPhaseSearcher) {
        this.queryPhaseSearcher = Objects.requireNonNull(queryPhaseSearcher, "QueryPhaseSearcher is required");
        this.suggestProcessor = new SuggestProcessor();
        this.rescoreProcessor = new RescoreProcessor();
    }

    public void preProcess(SearchContext context) {
        Runnable cancellation = context.lowLevelCancellation() ? context.searcher().addQueryCancellation(() -> {
            SearchShardTask task = context.getTask();
            if (task != null && task.isCancelled()) {
                throw new TaskCancelledException("cancelled task with reason: " + task.getReasonCancelled());
            }
        }) : null;
        try {
            context.preProcess(true);
        }
        finally {
            if (cancellation != null) {
                context.searcher().removeQueryCancellation(cancellation);
            }
        }
    }

    public void execute(SearchContext searchContext) throws QueryPhaseExecutionException {
        if (searchContext.hasOnlySuggest()) {
            this.suggestProcessor.process(searchContext);
            searchContext.queryResult().topDocs(new TopDocsAndMaxScore(new TopDocs(new TotalHits(0L, TotalHits.Relation.EQUAL_TO), Lucene.EMPTY_SCORE_DOCS), Float.NaN), new DocValueFormat[0]);
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)new SearchContextSourcePrinter(searchContext));
        }
        AggregationProcessor aggregationProcessor = this.queryPhaseSearcher.aggregationProcessor(searchContext);
        aggregationProcessor.preProcess(searchContext);
        boolean rescore = QueryPhase.executeInternal(searchContext, this.queryPhaseSearcher);
        if (rescore) {
            this.rescoreProcessor.process(searchContext);
        }
        this.suggestProcessor.process(searchContext);
        aggregationProcessor.postProcess(searchContext);
        if (searchContext.getProfilers() != null) {
            ProfileShardResult shardResults = SearchProfileShardResults.buildShardResults(searchContext.getProfilers(), searchContext.request());
            searchContext.queryResult().profileResults(shardResults);
        }
    }

    public QueryPhaseSearcher getQueryPhaseSearcher() {
        return this.queryPhaseSearcher;
    }

    static boolean executeInternal(SearchContext searchContext) throws QueryPhaseExecutionException {
        return QueryPhase.executeInternal(searchContext, DEFAULT_QUERY_PHASE_SEARCHER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean executeInternal(SearchContext searchContext, QueryPhaseSearcher queryPhaseSearcher) throws QueryPhaseExecutionException {
        List<CollectorManager<? extends Collector, ReduceableSearchResult>> managersExceptGlobalAgg;
        ContextIndexSearcher searcher = searchContext.searcher();
        IndexReader reader = searcher.getIndexReader();
        QuerySearchResult queryResult = searchContext.queryResult();
        queryResult.searchTimedOut(false);
        queryResult.from(searchContext.from());
        queryResult.size(searchContext.size());
        Query query = searchContext.query();
        assert (query == searcher.rewrite(query));
        ScrollContext scrollContext = searchContext.scrollContext();
        if (scrollContext != null) {
            if (scrollContext.totalHits == null) {
                assert (scrollContext.lastEmittedDoc == null);
            } else {
                ScoreDoc after = scrollContext.lastEmittedDoc;
                if (QueryPhase.canEarlyTerminate(reader, searchContext.sort()) && after != null) {
                    query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(new SearchAfterSortedDocQuery(searchContext.sort().sort, (FieldDoc)after), BooleanClause.Occur.FILTER).build();
                }
            }
        }
        LinkedList<QueryCollectorContext> collectors = new LinkedList<QueryCollectorContext>();
        boolean hasFilterCollector = false;
        if (searchContext.terminateAfter() != 0) {
            collectors.add(QueryCollectorContext.createEarlyTerminationCollectorContext(searchContext.terminateAfter()));
            hasFilterCollector = true;
        }
        if (searchContext.parsedPostFilter() != null) {
            collectors.add(QueryCollectorContext.createFilteredCollectorContext(searcher, searchContext.parsedPostFilter().query()));
            hasFilterCollector = true;
        }
        if (!(managersExceptGlobalAgg = searchContext.queryCollectorManagers().entrySet().stream().filter(entry -> !((Class)entry.getKey()).equals(GlobalAggCollectorManager.class)).map(Map.Entry::getValue).collect(Collectors.toList())).isEmpty()) {
            collectors.add(QueryCollectorContext.createMultiCollectorContext(managersExceptGlobalAgg));
        }
        if (searchContext.minimumScore() != null) {
            collectors.add(QueryCollectorContext.createMinScoreCollectorContext(searchContext.minimumScore().floatValue()));
            hasFilterCollector = true;
        }
        boolean timeoutSet = scrollContext == null && searchContext.timeout() != null && !searchContext.timeout().equals(SearchService.NO_TIMEOUT);
        Runnable timeoutRunnable = timeoutSet ? searcher.addQueryCancellation(QueryPhase.createQueryTimeoutChecker(searchContext)) : null;
        if (searchContext.lowLevelCancellation()) {
            searcher.addQueryCancellation(() -> {
                SearchShardTask task = searchContext.getTask();
                if (task != null && task.isCancelled()) {
                    throw new TaskCancelledException("cancelled task with reason: " + task.getReasonCancelled());
                }
            });
        }
        try {
            boolean shouldRescore = queryPhaseSearcher.searchWith(searchContext, searcher, query, collectors, hasFilterCollector, timeoutSet);
            ExecutorService executor = searchContext.indexShard().getThreadPool().executor("search");
            if (executor instanceof EWMATrackingThreadPoolExecutor) {
                EWMATrackingThreadPoolExecutor rExecutor = (EWMATrackingThreadPoolExecutor)((Object)executor);
                queryResult.nodeQueueSize(rExecutor.getCurrentQueueSize());
                queryResult.serviceTimeEWMA((long)rExecutor.getTaskExecutionEWMA());
            }
            boolean bl = shouldRescore;
            if (timeoutRunnable != null) {
                searcher.removeQueryCancellation(timeoutRunnable);
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (timeoutRunnable != null) {
                    searcher.removeQueryCancellation(timeoutRunnable);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new QueryPhaseExecutionException(searchContext.shardTarget(), "Failed to execute main query", e);
            }
        }
    }

    static Runnable createQueryTimeoutChecker(SearchContext searchContext) {
        long startTime = searchContext.getRelativeTimeInMillis(false);
        long maxTime = startTime + searchContext.timeout().millis();
        return () -> {
            long time = searchContext.getRelativeTimeInMillis();
            if (time > maxTime) {
                throw new TimeExceededException();
            }
        };
    }

    private static boolean searchWithCollector(SearchContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectors, QueryCollectorContext queryCollectorContext, boolean hasFilterCollector, boolean timeoutSet) throws IOException {
        Collector queryCollector;
        collectors.addFirst(Objects.requireNonNull(queryCollectorContext));
        if (searchContext.getProfilers() != null) {
            InternalProfileCollector profileCollector = QueryCollectorContext.createQueryCollectorWithProfiler(collectors);
            searchContext.getProfilers().getCurrentQueryProfiler().setCollector(profileCollector);
            queryCollector = profileCollector;
        } else {
            queryCollector = QueryCollectorContext.createQueryCollector(collectors);
        }
        QuerySearchResult queryResult = searchContext.queryResult();
        try {
            searcher.search(query, queryCollector);
        }
        catch (EarlyTerminatingCollector.EarlyTerminationException e) {
            searchContext.bucketCollectorProcessor().processPostCollection(queryCollector);
            queryResult.terminatedEarly(true);
        }
        if (searchContext.isSearchTimedOut()) {
            assert (timeoutSet) : "TimeExceededException thrown even though timeout wasn't set";
            if (!searchContext.request().allowPartialSearchResults()) {
                throw new QueryPhaseExecutionException(searchContext.shardTarget(), "Time exceeded");
            }
            queryResult.searchTimedOut(true);
        }
        if (searchContext.terminateAfter() != 0 && queryResult.terminatedEarly() == null) {
            queryResult.terminatedEarly(false);
        }
        for (QueryCollectorContext ctx : collectors) {
            ctx.postProcess(queryResult);
        }
        if (queryCollectorContext instanceof RescoringQueryCollectorContext) {
            return ((RescoringQueryCollectorContext)((Object)queryCollectorContext)).shouldRescore();
        }
        return false;
    }

    private static boolean canEarlyTerminate(IndexReader reader, SortAndFormats sortAndFormats) {
        if (sortAndFormats == null || sortAndFormats.sort == null) {
            return false;
        }
        Sort sort = sortAndFormats.sort;
        for (LeafReaderContext ctx : reader.leaves()) {
            Sort indexSort = ctx.reader().getMetaData().sort();
            if (indexSort != null && Lucene.canEarlyTerminate(sort, indexSort)) continue;
            return false;
        }
        return true;
    }

    public static class TimeExceededException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    public static class DefaultQueryPhaseSearcher
    implements QueryPhaseSearcher {
        private final AggregationProcessor aggregationProcessor = new DefaultAggregationProcessor();

        protected DefaultQueryPhaseSearcher() {
        }

        @Override
        public boolean searchWith(SearchContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectors, boolean hasFilterCollector, boolean hasTimeout) throws IOException {
            return this.searchWithCollector(searchContext, searcher, query, collectors, hasFilterCollector, hasTimeout);
        }

        @Override
        public AggregationProcessor aggregationProcessor(SearchContext searchContext) {
            return this.aggregationProcessor;
        }

        protected boolean searchWithCollector(SearchContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectors, boolean hasFilterCollector, boolean hasTimeout) throws IOException {
            QueryCollectorContext queryCollectorContext = this.getQueryCollectorContext(searchContext, hasFilterCollector);
            return this.searchWithCollector(searchContext, searcher, query, collectors, queryCollectorContext, hasFilterCollector, hasTimeout);
        }

        private QueryCollectorContext getQueryCollectorContext(SearchContext searchContext, boolean hasFilterCollector) throws IOException {
            Optional<QueryCollectorContext> queryCollectorContextOpt = QueryCollectorContextSpecRegistry.getQueryCollectorContextSpec(searchContext, new QueryCollectorArguments.Builder().hasFilterCollector(hasFilterCollector).build()).map(queryCollectorContextSpec -> new QueryCollectorContext(this, queryCollectorContextSpec.getContextName(), (QueryCollectorContextSpec)queryCollectorContextSpec){
                final /* synthetic */ QueryCollectorContextSpec val$queryCollectorContextSpec;
                {
                    this.val$queryCollectorContextSpec = queryCollectorContextSpec;
                    super(profilerName);
                }

                @Override
                Collector create(Collector in) throws IOException {
                    return this.val$queryCollectorContextSpec.create(in);
                }

                @Override
                CollectorManager<?, ReduceableSearchResult> createManager(CollectorManager<?, ReduceableSearchResult> in) throws IOException {
                    return this.val$queryCollectorContextSpec.createManager(in);
                }

                @Override
                void postProcess(QuerySearchResult result) throws IOException {
                    this.val$queryCollectorContextSpec.postProcess(result);
                }
            });
            if (queryCollectorContextOpt.isPresent()) {
                return queryCollectorContextOpt.get();
            }
            return TopDocsCollectorContext.createTopDocsCollectorContext(searchContext, hasFilterCollector);
        }

        protected boolean searchWithCollector(SearchContext searchContext, ContextIndexSearcher searcher, Query query, LinkedList<QueryCollectorContext> collectors, QueryCollectorContext queryCollectorContext, boolean hasFilterCollector, boolean hasTimeout) throws IOException {
            return QueryPhase.searchWithCollector(searchContext, searcher, query, collectors, queryCollectorContext, hasFilterCollector, hasTimeout);
        }
    }
}

