/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry;

import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;

@ExperimentalApi
public class TelemetrySettings {
    public static final Setting<Boolean> TRACER_ENABLED_SETTING = Setting.boolSetting("telemetry.tracer.enabled", false, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Boolean> TRACER_FEATURE_ENABLED_SETTING = Setting.boolSetting("telemetry.feature.tracer.enabled", false, Setting.Property.NodeScope, Setting.Property.Final);
    public static final Setting<Boolean> METRICS_FEATURE_ENABLED_SETTING = Setting.boolSetting("telemetry.feature.metrics.enabled", false, Setting.Property.NodeScope, Setting.Property.Final);
    public static final Setting<Double> TRACER_SAMPLER_PROBABILITY = Setting.doubleSetting("telemetry.tracer.sampler.probability", 0.01, 0.0, 1.0, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> METRICS_PUBLISH_INTERVAL_SETTING = Setting.timeSetting("telemetry.otel.metrics.publish.interval", TimeValue.timeValueSeconds(60L), Setting.Property.NodeScope, Setting.Property.Final);
    private volatile boolean tracingEnabled;
    private volatile double samplingProbability;
    private final boolean tracingFeatureEnabled;
    private final boolean metricsFeatureEnabled;

    public TelemetrySettings(Settings settings, ClusterSettings clusterSettings) {
        this.tracingEnabled = TRACER_ENABLED_SETTING.get(settings);
        this.samplingProbability = TRACER_SAMPLER_PROBABILITY.get(settings);
        this.tracingFeatureEnabled = TRACER_FEATURE_ENABLED_SETTING.get(settings);
        this.metricsFeatureEnabled = METRICS_FEATURE_ENABLED_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(TRACER_ENABLED_SETTING, this::setTracingEnabled);
        clusterSettings.addSettingsUpdateConsumer(TRACER_SAMPLER_PROBABILITY, this::setSamplingProbability);
    }

    public void setTracingEnabled(boolean tracingEnabled) {
        this.tracingEnabled = tracingEnabled;
    }

    public boolean isTracingEnabled() {
        return this.tracingEnabled;
    }

    public void setSamplingProbability(double samplingProbability) {
        this.samplingProbability = samplingProbability;
    }

    public double getSamplingProbability() {
        return this.samplingProbability;
    }

    public boolean isTracingFeatureEnabled() {
        return this.tracingFeatureEnabled;
    }

    public boolean isMetricsFeatureEnabled() {
        return this.metricsFeatureEnabled;
    }
}

