/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.paxjdbcfeature;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.FrameworkUtil;

public class PaxJdbcFeaturesMapping {
    private static final Logger LOGGER = LogManager.getLogger(PaxJdbcFeaturesMapping.class);
    private final Properties jdbcDriverClassToFeatureMappings;

    public PaxJdbcFeaturesMapping(String fileName) {
        this.jdbcDriverClassToFeatureMappings = this.loadJdbcDriverClassToFeatureMappings(fileName);
    }

    private Properties loadJdbcDriverClassToFeatureMappings(String fileName) {
        Properties props = new Properties();
        try (InputStream resourceStream = FrameworkUtil.getBundle(this.getClass()).getResource(fileName).openStream();){
            props.load(resourceStream);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to load the mapping file: {}", (Object)fileName);
        }
        return props;
    }

    public String getFeatureName(Object jdbcDriverClass) {
        if (jdbcDriverClass instanceof String) {
            return this.jdbcDriverClassToFeatureMappings.getProperty((String)jdbcDriverClass);
        }
        return null;
    }
}

