/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.filestorage.client.google;

import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.HttpMethod;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import de.virtimo.bpc.api.filestorage.FileStoreItem;
import de.virtimo.bpc.api.filestorage.ObjectStoreReference;
import de.virtimo.bpc.api.filestorage.clients.ObjectStorageClient;
import de.virtimo.bpc.api.filestorage.exception.FileStoreConnectionCloseException;
import de.virtimo.bpc.api.filestorage.exception.FileStoreConnectionException;
import de.virtimo.bpc.api.filestorage.exception.enums.FileStorageOperation;
import de.virtimo.bpc.api.filestorage.exception.enums.FileStorageTypes;
import de.virtimo.bpc.api.multipart.UploadedFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GoogleCloudStorageClient
implements ObjectStorageClient {
    private static final Logger LOGGER = LogManager.getLogger(GoogleCloudStorageClient.class);
    Storage cloudStorage;

    public GoogleCloudStorageClient(String projectId, String serviceAccountJson) throws FileStoreConnectionException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(serviceAccountJson.getBytes(StandardCharsets.UTF_8));
        try {
            ServiceAccountCredentials credentials = ServiceAccountCredentials.fromStream((InputStream)inputStream);
            this.cloudStorage = (Storage)((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(projectId)).setCredentials((Credentials)credentials)).build().getService();
        }
        catch (IOException e) {
            throw new FileStoreConnectionException((Exception)e, FileStorageTypes.GOOGLE_GLOUD_STORAGE, FileStorageOperation.ESTABLISH_CONNECTION);
        }
    }

    public List<String> listBuckets() throws FileStoreConnectionException {
        LOGGER.info("Listing buckets");
        try {
            Page buckets = this.cloudStorage.list(new Storage.BucketListOption[0]);
            return buckets.streamAll().map(BucketInfo::getName).toList();
        }
        catch (StorageException e) {
            throw new FileStoreConnectionException((Exception)((Object)e), FileStorageTypes.GOOGLE_GLOUD_STORAGE, FileStorageOperation.LIST_BUCKETS);
        }
    }

    public URL getPresignedDownloadURL(FileStoreItem storeItem, int urlValidityMinutes) throws FileStoreConnectionException {
        LOGGER.info("getPresignedDownloadURL storeItem={}, urlValidityMinutes={}", (Object)storeItem, (Object)urlValidityMinutes);
        ObjectStoreReference fileStoreRef = storeItem.getObjectStoreReference();
        BlobInfo blobInfo = BlobInfo.newBuilder((String)fileStoreRef.bucket(), (String)fileStoreRef.fileKey()).build();
        String filename = storeItem.getFilename();
        filename = filename.replace("\"", "'");
        HashMap<String, CallSite> extensionQueryParams = new HashMap<String, CallSite>();
        extensionQueryParams.put("response-content-disposition", (CallSite)((Object)("attachment; filename=\"" + filename + "\"")));
        try {
            return this.cloudStorage.signUrl(blobInfo, (long)urlValidityMinutes, TimeUnit.MINUTES, new Storage.SignUrlOption[]{Storage.SignUrlOption.httpMethod((HttpMethod)HttpMethod.GET), Storage.SignUrlOption.withV4Signature(), Storage.SignUrlOption.withQueryParams(extensionQueryParams)});
        }
        catch (Exception e) {
            throw new FileStoreConnectionException(e, FileStorageTypes.GOOGLE_GLOUD_STORAGE, FileStorageOperation.GET_PRESIGNED_URL);
        }
    }

    public void uploadFile(UploadedFile file, String bucket, String fileKey, String contentType) throws FileStoreConnectionException {
        LOGGER.info("uploadFile file=..., bucket={}, fileKey={}, contentType={}", (Object)bucket, (Object)fileKey, (Object)contentType);
        BlobInfo blobInfo = BlobInfo.newBuilder((String)bucket, (String)fileKey).setContentType(contentType).build();
        try {
            this.cloudStorage.createFrom(blobInfo, file.getTemporaryContentFile().toPath(), new Storage.BlobWriteOption[0]);
        }
        catch (StorageException | IOException e) {
            throw new FileStoreConnectionException((Exception)e, FileStorageTypes.GOOGLE_GLOUD_STORAGE, FileStorageOperation.UPLOAD_FILE);
        }
    }

    public void deleteFile(String bucket, String fileKey) throws FileStoreConnectionException {
        LOGGER.info("deleteFile bucket={}, fileKey={}", (Object)bucket, (Object)fileKey);
        try {
            this.cloudStorage.delete(bucket, fileKey, new Storage.BlobSourceOption[0]);
        }
        catch (StorageException e) {
            throw new FileStoreConnectionException((Exception)((Object)e), FileStorageTypes.GOOGLE_GLOUD_STORAGE, FileStorageOperation.DELETE_FILE);
        }
    }

    public void close() throws Exception {
        try {
            this.cloudStorage.close();
        }
        catch (Exception e) {
            throw new FileStoreConnectionCloseException(e, FileStorageTypes.GOOGLE_GLOUD_STORAGE);
        }
    }
}

