/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor;

import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.StorageServiceSupport;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcDataFilterBuilder;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcDataSort;
import de.virtimo.bpc.api.storage.DeploymentInstruction;
import de.virtimo.bpc.module.AbstractModuleInstance;
import de.virtimo.bpc.module.monitor.MonitorModule;
import de.virtimo.bpc.module.monitor.OpenSearch;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.MappingMetadata;

public class MonitorModuleInstance
extends AbstractModuleInstance
implements StorageServiceSupport {
    private static final Logger LOGGER = LogManager.getLogger(MonitorModuleInstance.class);
    public static final String SETTING_COLUMN_CONFIG = "column_config";
    public static final String SETTING_DATA_INDEX = "data_index";
    public static final String SETTING_DATA_EXCLUDED_FIELDS = "data_excludedFields";
    public static final String SETTING_DATA_HISTORY_INDEX = "data_historyIndex";
    public static final String SETTING_DATA_FILTER = "data_filter";
    public static final String SETTING_DATA_FILTER_OPERATOR = "data_filter_operator";
    public static final String SETTING_DATA_REFRESH_BUFFER = "data_refreshBuffer";
    public static final String SETTING_MAX_RESULT_WINDOW = "instance_data_view_limit";
    public static final String SETTING_MAX_DATA_COUNT = "instance_data_count_limit";
    public static final String SETTING_ID_COLUMN = "column_id";
    public static final String SETTING_HISTORY_ID = "column_historyId";
    public static final String SETTING_HISTORY_SUB_ID = "column_historySubId";
    public static final String SETTING_COLUMN_LIST = "column_list";
    public static final String SETTING_COLUMN_TIMESERIES = "column_timeseries";
    public static final String SETTING_COLUMN_FILE = "column_file";
    public static final String SETTING_COLUMN_MIMETYPE = "column_mimetype";
    public static final String SETTING_HISTORY_COLUMN_LIST = "column_historyList";
    public static final String SETTING_HISTORY_COLUMN_CONFIG = "column_historyConfig";
    public static final String SETTING_DATAEXPORT_ENABLE = "function_exportEnable";
    public static final String SETTING_DATAEXPORT_FORMAT_JSON = "function_exportConfigJson";
    public static final String SETTING_DATAEXPORT_FORMAT_JSON_INCL_HIDDEN = "function_exportConfigJsonInclHidden";
    public static final String SETTING_DATAEXPORT_FORMAT_JSON_USE_CUSTOM_COLUMN_HEADERS = "function_exportConfigJsonUseCustomColumnHeaders";
    public static final String SETTING_DATAEXPORT_FORMAT_JSON_USE_UTC_DATE_FORMAT = "function_exportConfigJsonUseUTCDateFormat";
    public static final String SETTING_DATAEXPORT_FORMAT_XLSX = "function_exportConfigXlsx";
    public static final String SETTING_DATAEXPORT_FORMAT_XLSX_INCL_HIDDEN = "function_exportConfigXlsxInclHidden";
    public static final String SETTING_DATAEXPORT_FORMAT_XLSX_AUTO_RESIZE_COLUMNS = "function_exportConfigXlsxAutoResizeColumns";
    public static final String SETTING_DATAEXPORT_FORMAT_XLSX_USE_CUSTOM_COLUMN_HEADERS = "function_exportConfigXlsxUseCustomColumnHeaders";
    public static final String SETTING_DATAEXPORT_FORMAT_CSV = "function_exportConfigCsv";
    public static final String SETTING_DATAEXPORT_FORMAT_CSV_SEPARATOR = "function_exportConfigCsvSeparator";
    public static final String SETTING_DATAEXPORT_FORMAT_CSV_INCL_HIDDEN = "function_exportConfigCsvInclHidden";
    public static final String SETTING_DATAEXPORT_FORMAT_CSV_USE_CUSTOM_COLUMN_HEADERS = "function_exportConfigCsvUseCustomColumnHeaders";
    public static final String SETTING_RESOURCE_SAVING_MODE = "resource_saving_mode";
    public static final String SETTING_FUNCTION_GRID_MULTIVIEWS_ENABLE = "function_gridMultipleViews";
    public static final String SETTING_FUNCTION_GRID_MULTIVIEWS_CONFIG = "function_gridMultipleViewsConfig";
    public static final String SETTING_INUBIT_PROXY = "inubit_proxyId";
    public static final String SETTING_INUBIT_BASE_URL = "inubit_baseUrl";
    public static final String SETTING_INUBIT_TABLE_PREFIX = "inubit_dbTablePrefix";
    public static final String SETTING_INUBIT_REFERENCE_ENDPOINT = "inubit_referenceEndpoint";
    public static final String SETTING_COLUMN_CUSTOM_RENDERER = "column_customRenderer";
    private static final Object COLUMN_SETTINGS_LOCK = new Object();
    private boolean initialParentIndexMappingProcessed = false;
    private boolean initialChildIndexMappingProcessed = false;

    public MonitorModuleInstance(InstantiableModule pm, ModuleConfiguration mc, String instanceId) {
        super(pm, mc, instanceId);
    }

    public void destroy() {
        LOGGER.info("destroy");
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleConfiguration getConfiguration() {
        ModuleConfiguration m = super.getConfiguration();
        Object object = COLUMN_SETTINGS_LOCK;
        synchronized (object) {
            try {
                if (!this.initialParentIndexMappingProcessed) {
                    this.initialParentIndexMappingProcessed = true;
                    this.initColumnListSetting(m, SETTING_DATA_INDEX, SETTING_COLUMN_LIST);
                }
                if (!this.initialChildIndexMappingProcessed) {
                    this.initialChildIndexMappingProcessed = true;
                    this.initColumnListSetting(m, SETTING_DATA_HISTORY_INDEX, SETTING_HISTORY_COLUMN_LIST);
                }
            }
            catch (Exception e) {
                LOGGER.error("{}: Error getting OpenSearch mapping.", (Object)this.getModuleId(), (Object)e);
            }
        }
        return m;
    }

    private void initColumnListSetting(ModuleConfiguration m, String dataIndexSettingName, String columnListSettingName) throws SettingException {
        Setting currentColumnListSetting;
        Object currentColumnListValue;
        String index = m.getSettingValue(dataIndexSettingName).asString("").toLowerCase();
        if (!StringUtil.isNullOrEmpty((String)index) && ((currentColumnListValue = (currentColumnListSetting = m.getSetting(columnListSettingName)).getValue()) == null || currentColumnListValue instanceof Map && ((Map)currentColumnListValue).isEmpty())) {
            LOGGER.info("{}: add setting: {}", (Object)this.getModuleId(), (Object)columnListSettingName);
            OpenSearch openSearch = ((MonitorModule)this.getParentModule()).getOpenSearch();
            Map indexMapping = openSearch.getIndexMapping(index);
            if (indexMapping != null) {
                ((SimpleSettingImpl)currentColumnListSetting).setValue((Object)indexMapping);
                m.addSetting(currentColumnListSetting, true);
            }
        }
    }

    protected void applyUpdatedConfiguration() {
        LOGGER.info("{}: applyUpdatedConfiguration", (Object)this.getModuleId());
        ModuleConfiguration m = this.getConfiguration();
        this.indexToDefaultColumnConfiguration(m, SETTING_DATA_INDEX, SETTING_COLUMN_CONFIG);
        this.indexToDefaultColumnConfiguration(m, SETTING_DATA_HISTORY_INDEX, SETTING_HISTORY_COLUMN_CONFIG);
    }

    private void indexToDefaultColumnConfiguration(ModuleConfiguration m, String dataIndexSettingName, String columnConfigSettingName) {
        try {
            Object monitorColumnConfigs;
            boolean configureColumnConfig = true;
            Setting existingColumnConfigSetting = m.getSetting(columnConfigSettingName);
            if (existingColumnConfigSetting != null && (monitorColumnConfigs = existingColumnConfigSetting.getValue()) instanceof ArrayList && ((ArrayList)monitorColumnConfigs).size() > 0) {
                configureColumnConfig = false;
            }
            if (configureColumnConfig) {
                LOGGER.info("{}: generate setting {}", (Object)this.getModuleId(), (Object)columnConfigSettingName);
                String index = m.getSettingValue(dataIndexSettingName).asString("").toLowerCase();
                MappingMetadata mmd = null;
                if (!StringUtil.isNullOrEmpty((String)index)) {
                    mmd = ((MonitorModule)this.getParentModule()).getOpenSearch().getOpenSearchService().getMappingMetaData(index);
                }
                if (mmd != null) {
                    Map fieldMap = (Map)mmd.getSourceAsMap().get("properties");
                    ArrayList columnConfig = new ArrayList();
                    for (String fieldName : fieldMap.keySet()) {
                        Map fieldConfig;
                        if (fieldName.equals("_percolator_query") || !((fieldConfig = (Map)fieldMap.get(fieldName)).get("type") instanceof String)) continue;
                        HashMap<String, Object> column = new HashMap<String, Object>();
                        column.put("dataIndex", fieldName);
                        column.put("text", fieldName);
                        column.put("hidden", false);
                        column.put("hideable", true);
                        column.put("width", 200);
                        column.put("minWidth", 64);
                        column.put("customRenderer", false);
                        String filterType = "text";
                        String fieldType = fieldConfig.get("type").toString();
                        if (fieldType.equals("date")) {
                            column.put("xtype", "datecolumn");
                            filterType = "daterange";
                        } else if (fieldType.equals("long") || fieldType.equals("double")) {
                            filterType = "number";
                        } else if (fieldType.equals("boolean")) {
                            filterType = "check";
                        } else if (fieldType.equals("attachment")) {
                            column.put("xtype", "attachmentcolumn");
                        } else if (fieldType.equals("object") || fieldType.equals("flat_object")) {
                            column.put("formatter", "jsonStringify");
                        }
                        HashMap<String, String> filterDefaultMap = new HashMap<String, String>();
                        filterDefaultMap.put("type", filterType);
                        if (fieldName.equalsIgnoreCase("status")) {
                            filterDefaultMap.put("source", "lowercase");
                        } else {
                            filterDefaultMap.put("source", "raw");
                        }
                        column.put("filter", filterDefaultMap);
                        columnConfig.add(column);
                    }
                    Setting columnConfigSetting = m.getSetting(columnConfigSettingName);
                    SimpleSettingImpl newColumnConfigSetting = new SimpleSettingImpl(columnConfigSetting);
                    newColumnConfigSetting.setValue(columnConfig);
                    m.updateSetting((Setting)newColumnConfigSetting, true);
                } else {
                    LOGGER.warn("{}: Can't read metadata from data source. Check setting '{}'.", (Object)this.getModuleId(), (Object)dataIndexSettingName);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("{}: Error: {}", (Object)this.getModuleId(), (Object)e.getMessage(), (Object)e);
        }
    }

    public List<DeploymentInstruction> getDeploymentInstructionsOfStorageServiceData() {
        return List.of(new DeploymentInstruction("monitor-views", List.of(BpcDataFilterBuilder.newInstance().withProperty("moduleId").withOperator("=").withValue("monitor").build(), BpcDataFilterBuilder.newInstance().withProperty("moduleInstanceId").withOperator("=").withValue(this.getModuleId()).build()), BpcDataSort.fromCompactFormat((String)"id|ASC")));
    }
}

