/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.util.StringUtil;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenSearch {
    private static final Logger LOGGER = LogManager.getLogger(OpenSearch.class);
    private final OpenSearchService openSearchService;

    public OpenSearch(OpenSearchService openSearchService) {
        LOGGER.info("OpenSearch openSearchService=...");
        this.openSearchService = openSearchService;
    }

    public OpenSearchService getOpenSearchService() {
        LOGGER.info("getOpenSearchService");
        return this.openSearchService;
    }

    public Map getIndexMapping(String index) {
        LOGGER.info("getIndexMapping index={}", (Object)index);
        if (!StringUtil.isNullOrEmpty((String)index)) {
            try {
                Map columnMap;
                Object mappingPropertiesObject;
                if (this.openSearchService.existsIndex(index) && (mappingPropertiesObject = (columnMap = this.openSearchService.getMapping(index)).get("properties")) instanceof Map) {
                    Map m = (Map)mappingPropertiesObject;
                    m.remove("_percolator_query");
                    return m;
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to get the mapping of the index: {}", (Object)index);
            }
        }
        return null;
    }
}

