/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.impl;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverDataSource
implements DataSource {
    private static final Logger LOG = LoggerFactory.getLogger(DriverDataSource.class);
    private final Driver driver;
    private final String url;
    private final String user;
    private final String password;

    public DriverDataSource(Driver driver, String url, String user, String password) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        LOG.warn("setLogWriter() has no effect");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        LOG.warn("setLoginTimeout() has no effect");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(DriverDataSource.class)) {
            return iface.cast(this);
        }
        throw new SQLException(DriverDataSource.class.getName() + " cannot be unwrapped to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(DriverDataSource.class);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties props = new Properties();
        if (username != null) {
            props.setProperty("user", username);
        }
        if (password != null) {
            props.setProperty("password", password);
        }
        return this.driver.connect(this.url, props);
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("this datasource does not use java.util.logging");
    }
}

