/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;

public class SecurityConfigVersionDocument {
    private long seqNo = -1L;
    private long primaryTerm = -1L;
    private final List<Version<?>> versions;

    @JsonCreator
    public SecurityConfigVersionDocument(@JsonProperty(value="versions") List<Version<?>> versions) {
        this.versions = versions != null ? versions : new ArrayList();
    }

    public SecurityConfigVersionDocument() {
        this.versions = new ArrayList();
    }

    @JsonProperty(value="versions")
    public List<Version<?>> getVersions() {
        return this.versions;
    }

    public void addVersion(Version<?> version) {
        this.versions.add(version);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> docMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> versionsList = new ArrayList<Map<String, Object>>();
        for (Version<?> v : this.versions) {
            versionsList.add(v.toMap());
        }
        docMap.put("versions", versionsList);
        return docMap;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public void setSeqNo(long seqNo) {
        this.seqNo = seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public void setPrimaryTerm(long primaryTerm) {
        this.primaryTerm = primaryTerm;
    }

    public static class Version<T> {
        private final String version_id;
        private final String timestamp;
        private final Map<String, HistoricSecurityConfig<?>> security_configs;
        private final String modified_by;

        @JsonCreator
        public Version(@JsonProperty(value="version_id") String version_id, @JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="security_configs") Map<String, HistoricSecurityConfig<?>> security_configs, @JsonProperty(value="modified_by") String modified_by) {
            this.version_id = version_id;
            this.timestamp = timestamp;
            this.security_configs = security_configs != null ? security_configs : new HashMap();
            this.modified_by = modified_by;
        }

        @JsonProperty(value="version_id")
        public String getVersion_id() {
            return this.version_id;
        }

        @JsonProperty(value="timestamp")
        public String getTimestamp() {
            return this.timestamp;
        }

        @JsonProperty(value="security_configs")
        public Map<String, HistoricSecurityConfig<?>> getSecurity_configs() {
            return this.security_configs;
        }

        @JsonProperty(value="modified_by")
        public String getModified_by() {
            return this.modified_by;
        }

        public void addSecurityConfig(String type, HistoricSecurityConfig<?> config) {
            this.security_configs.put(type, config);
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> versionMap = new HashMap<String, Object>();
            versionMap.put("version_id", this.version_id);
            versionMap.put("timestamp", this.timestamp);
            versionMap.put("modified_by", this.modified_by);
            HashMap<String, Map<String, Object>> scsMap = new HashMap<String, Map<String, Object>>();
            for (Map.Entry<String, HistoricSecurityConfig<?>> entry : this.security_configs.entrySet()) {
                scsMap.put(entry.getKey(), entry.getValue().toMap());
            }
            versionMap.put("security_configs", scsMap);
            return versionMap;
        }
    }

    public static class HistoricSecurityConfig<T> {
        private final String lastUpdated;
        private final Map<String, SecurityDynamicConfiguration<T>> configData;

        @JsonCreator
        public HistoricSecurityConfig(@JsonProperty(value="lastUpdated") String lastUpdated, @JsonProperty(value="configData") Map<String, SecurityDynamicConfiguration<T>> configData) {
            this.lastUpdated = lastUpdated;
            this.configData = configData != null ? configData : new HashMap();
        }

        @JsonProperty(value="lastUpdated")
        public String getLastUpdated() {
            return this.lastUpdated;
        }

        @JsonProperty(value="configData")
        public Map<String, SecurityDynamicConfiguration<T>> getConfigData() {
            return this.configData;
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> scMap = new HashMap<String, Object>();
            scMap.put("lastUpdated", this.lastUpdated);
            scMap.put("configData", this.configData);
            return scMap;
        }
    }
}

