/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline.common;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.hash.MurmurHash3;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilderVisitor;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.search.pipeline.AbstractProcessor;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchRequestProcessor;

public class AclRoutingSearchProcessor
extends AbstractProcessor
implements SearchRequestProcessor {
    public static final String TYPE = "acl_routing_search";
    private static final Base64.Encoder BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();
    private final String aclField;
    private final boolean extractFromQuery;

    public AclRoutingSearchProcessor(String tag, String description, boolean ignoreFailure, String aclField, boolean extractFromQuery) {
        super(tag, description, ignoreFailure);
        this.aclField = aclField;
        this.extractFromQuery = extractFromQuery;
    }

    public String getType() {
        return TYPE;
    }

    public SearchRequest processRequest(SearchRequest request) throws Exception {
        if (!this.extractFromQuery || request.source() == null) {
            return request;
        }
        QueryBuilder query = request.source().query();
        if (query == null) {
            return request;
        }
        List<String> aclValues = this.extractAclValues(query);
        if (aclValues.isEmpty()) {
            return request;
        }
        String[] routingValues = (String[])aclValues.stream().map(this::generateRoutingValue).toArray(String[]::new);
        request.routing(routingValues);
        return request;
    }

    private List<String> extractAclValues(QueryBuilder query) {
        final ArrayList<String> aclValues = new ArrayList<String>();
        query.visit(new QueryBuilderVisitor(){
            final /* synthetic */ AclRoutingSearchProcessor this$0;
            {
                this.this$0 = this$0;
            }

            public void accept(QueryBuilder qb) {
                TermsQueryBuilder termsQuery;
                if (qb instanceof TermQueryBuilder) {
                    TermQueryBuilder termQuery = (TermQueryBuilder)qb;
                    if (this.this$0.aclField.equals(termQuery.fieldName())) {
                        aclValues.add(termQuery.value().toString());
                    }
                } else if (qb instanceof TermsQueryBuilder && this.this$0.aclField.equals((termsQuery = (TermsQueryBuilder)qb).fieldName())) {
                    termsQuery.values().forEach(value -> aclValues.add(value.toString()));
                }
            }

            public QueryBuilderVisitor getChildVisitor(BooleanClause.Occur occur) {
                return this;
            }
        });
        return aclValues;
    }

    private String generateRoutingValue(String aclValue) {
        byte[] bytes = aclValue.getBytes(StandardCharsets.UTF_8);
        MurmurHash3.Hash128 hash = MurmurHash3.hash128((byte[])bytes, (int)0, (int)bytes.length, (long)0L, (MurmurHash3.Hash128)new MurmurHash3.Hash128());
        byte[] hashBytes = new byte[16];
        System.arraycopy(this.longToBytes(hash.h1), 0, hashBytes, 0, 8);
        System.arraycopy(this.longToBytes(hash.h2), 0, hashBytes, 8, 8);
        return BASE64_ENCODER.encodeToString(hashBytes);
    }

    private byte[] longToBytes(long value) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    public static class Factory
    implements Processor.Factory<SearchRequestProcessor> {
        public AclRoutingSearchProcessor create(Map<String, Processor.Factory<SearchRequestProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) throws Exception {
            String aclField = ConfigurationUtils.readStringProperty((String)AclRoutingSearchProcessor.TYPE, (String)tag, config, (String)"acl_field");
            boolean extractFromQuery = ConfigurationUtils.readBooleanProperty((String)AclRoutingSearchProcessor.TYPE, (String)tag, config, (String)"extract_from_query", (boolean)true);
            return new AclRoutingSearchProcessor(tag, description, ignoreFailure, aclField, extractFromQuery);
        }
    }
}

