/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_zh extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_type_nu_gong = "\u9a6c\u8428\u62c9\u59c6\u5188\u5fb7\u6570\u5b57";
        final String metaValue_key_nu = "\u6570\u5b57";
        final Object[][] data = new Object[][] {
            { "001", "\u4e16\u754c" },
            { "002", "\u975e\u6d32" },
            { "003", "\u5317\u7f8e\u6d32" },
            { "005", "\u5357\u7f8e\u6d32" },
            { "009", "\u5927\u6d0b\u6d32" },
            { "011", "\u897f\u975e" },
            { "013", "\u4e2d\u7f8e\u6d32" },
            { "014", "\u4e1c\u975e" },
            { "015", "\u5317\u975e" },
            { "017", "\u4e2d\u975e" },
            { "018", "\u5357\u90e8\u975e\u6d32" },
            { "019", "\u7f8e\u6d32" },
            { "021", "\u7f8e\u6d32\u5317\u90e8" },
            { "029", "\u52a0\u52d2\u6bd4\u5730\u533a" },
            { "030", "\u4e1c\u4e9a" },
            { "034", "\u5357\u4e9a" },
            { "035", "\u4e1c\u5357\u4e9a" },
            { "039", "\u5357\u6b27" },
            { "053", "\u6fb3\u5927\u62c9\u897f\u4e9a" },
            { "054", "\u7f8e\u62c9\u5c3c\u897f\u4e9a" },
            { "057", "\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a\u5730\u533a" },
            { "061", "\u73bb\u5229\u5c3c\u897f\u4e9a" },
            { "142", "\u4e9a\u6d32" },
            { "143", "\u4e2d\u4e9a" },
            { "145", "\u897f\u4e9a" },
            { "150", "\u6b27\u6d32" },
            { "151", "\u4e1c\u6b27" },
            { "154", "\u5317\u6b27" },
            { "155", "\u897f\u6b27" },
            { "202", "\u6492\u54c8\u62c9\u4ee5\u5357\u975e\u6d32" },
            { "419", "\u62c9\u4e01\u7f8e\u6d32" },
            { "AC", "\u963f\u68ee\u677e\u5c9b" },
            { "AD", "\u5b89\u9053\u5c14" },
            { "AE", "\u963f\u62c9\u4f2f\u8054\u5408\u914b\u957f\u56fd" },
            { "AF", "\u963f\u5bcc\u6c57" },
            { "AG", "\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe" },
            { "AI", "\u5b89\u572d\u62c9" },
            { "AL", "\u963f\u5c14\u5df4\u5c3c\u4e9a" },
            { "AM", "\u4e9a\u7f8e\u5c3c\u4e9a" },
            { "AO", "\u5b89\u54e5\u62c9" },
            { "AQ", "\u5357\u6781\u6d32" },
            { "AR", "\u963f\u6839\u5ef7" },
            { "AS", "\u7f8e\u5c5e\u8428\u6469\u4e9a" },
            { "AT", "\u5965\u5730\u5229" },
            { "AU", "\u6fb3\u5927\u5229\u4e9a" },
            { "AW", "\u963f\u9c81\u5df4" },
            { "AX", "\u5965\u5170\u7fa4\u5c9b" },
            { "AZ", "\u963f\u585e\u62dc\u7586" },
            { "BA", "\u6ce2\u65af\u5c3c\u4e9a\u548c\u9ed1\u585e\u54e5\u7ef4\u90a3" },
            { "BB", "\u5df4\u5df4\u591a\u65af" },
            { "BD", "\u5b5f\u52a0\u62c9\u56fd" },
            { "BE", "\u6bd4\u5229\u65f6" },
            { "BF", "\u5e03\u57fa\u7eb3\u6cd5\u7d22" },
            { "BG", "\u4fdd\u52a0\u5229\u4e9a" },
            { "BH", "\u5df4\u6797" },
            { "BI", "\u5e03\u9686\u8fea" },
            { "BJ", "\u8d1d\u5b81" },
            { "BL", "\u5723\u5df4\u6cf0\u52d2\u7c73" },
            { "BM", "\u767e\u6155\u5927" },
            { "BN", "\u6587\u83b1" },
            { "BO", "\u73bb\u5229\u7ef4\u4e9a" },
            { "BQ", "\u8377\u5c5e\u52a0\u52d2\u6bd4\u533a" },
            { "BR", "\u5df4\u897f" },
            { "BS", "\u5df4\u54c8\u9a6c" },
            { "BT", "\u4e0d\u4e39" },
            { "BV", "\u5e03\u97e6\u5c9b" },
            { "BW", "\u535a\u8328\u74e6\u7eb3" },
            { "BY", "\u767d\u4fc4\u7f57\u65af" },
            { "BZ", "\u4f2f\u5229\u5179" },
            { "CA", "\u52a0\u62ff\u5927" },
            { "CC", "\u79d1\u79d1\u65af\uff08\u57fa\u6797\uff09\u7fa4\u5c9b" },
            { "CD", "\u521a\u679c\uff08\u91d1\uff09" },
            { "CF", "\u4e2d\u975e\u5171\u548c\u56fd" },
            { "CG", "\u521a\u679c\uff08\u5e03\uff09" },
            { "CH", "\u745e\u58eb" },
            { "CI", "\u79d1\u7279\u8fea\u74e6" },
            { "CK", "\u5e93\u514b\u7fa4\u5c9b" },
            { "CL", "\u667a\u5229" },
            { "CM", "\u5580\u9ea6\u9686" },
            { "CN", "\u4e2d\u56fd" },
            { "CO", "\u54e5\u4f26\u6bd4\u4e9a" },
            { "CP", "\u514b\u5229\u73c0\u987f\u5c9b" },
            { "CR", "\u54e5\u65af\u8fbe\u9ece\u52a0" },
            { "CU", "\u53e4\u5df4" },
            { "CV", "\u4f5b\u5f97\u89d2" },
            { "CW", "\u5e93\u62c9\u7d22" },
            { "CX", "\u5723\u8bde\u5c9b" },
            { "CY", "\u585e\u6d66\u8def\u65af" },
            { "CZ", "\u6377\u514b" },
            { "DE", "\u5fb7\u56fd" },
            { "DG", "\u8fea\u6208\u52a0\u897f\u4e9a\u5c9b" },
            { "DJ", "\u5409\u5e03\u63d0" },
            { "DK", "\u4e39\u9ea6" },
            { "DM", "\u591a\u7c73\u5c3c\u514b" },
            { "DO", "\u591a\u7c73\u5c3c\u52a0\u5171\u548c\u56fd" },
            { "DZ", "\u963f\u5c14\u53ca\u5229\u4e9a" },
            { "EA", "\u4f11\u8fbe\u53ca\u6885\u5229\u5229\u4e9a" },
            { "EC", "\u5384\u74dc\u591a\u5c14" },
            { "EE", "\u7231\u6c99\u5c3c\u4e9a" },
            { "EG", "\u57c3\u53ca" },
            { "EH", "\u897f\u6492\u54c8\u62c9" },
            { "ER", "\u5384\u7acb\u7279\u91cc\u4e9a" },
            { "ES", "\u897f\u73ed\u7259" },
            { "ET", "\u57c3\u585e\u4fc4\u6bd4\u4e9a" },
            { "EU", "\u6b27\u76df" },
            { "EZ", "\u6b27\u5143\u533a" },
            { "FI", "\u82ac\u5170" },
            { "FJ", "\u6590\u6d4e" },
            { "FK", "\u798f\u514b\u5170\u7fa4\u5c9b" },
            { "FM", "\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a" },
            { "FO", "\u6cd5\u7f57\u7fa4\u5c9b" },
            { "FR", "\u6cd5\u56fd" },
            { "GA", "\u52a0\u84ec" },
            { "GB", "\u82f1\u56fd" },
            { "GD", "\u683c\u6797\u7eb3\u8fbe" },
            { "GE", "\u683c\u9c81\u5409\u4e9a" },
            { "GF", "\u6cd5\u5c5e\u572d\u4e9a\u90a3" },
            { "GG", "\u6839\u897f\u5c9b" },
            { "GH", "\u52a0\u7eb3" },
            { "GI", "\u76f4\u5e03\u7f57\u9640" },
            { "GL", "\u683c\u9675\u5170" },
            { "GM", "\u5188\u6bd4\u4e9a" },
            { "GN", "\u51e0\u5185\u4e9a" },
            { "GP", "\u74dc\u5fb7\u7f57\u666e" },
            { "GQ", "\u8d64\u9053\u51e0\u5185\u4e9a" },
            { "GR", "\u5e0c\u814a" },
            { "GS", "\u5357\u4e54\u6cbb\u4e9a\u548c\u5357\u6851\u5a01\u5947\u7fa4\u5c9b" },
            { "GT", "\u5371\u5730\u9a6c\u62c9" },
            { "GU", "\u5173\u5c9b" },
            { "GW", "\u51e0\u5185\u4e9a\u6bd4\u7ecd" },
            { "GY", "\u572d\u4e9a\u90a3" },
            { "HK", "\u4e2d\u56fd\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a" },
            { "HM", "\u8d6b\u5fb7\u5c9b\u548c\u9ea6\u514b\u5510\u7eb3\u7fa4\u5c9b" },
            { "HN", "\u6d2a\u90fd\u62c9\u65af" },
            { "HR", "\u514b\u7f57\u5730\u4e9a" },
            { "HT", "\u6d77\u5730" },
            { "HU", "\u5308\u7259\u5229" },
            { "IC", "\u52a0\u7eb3\u5229\u7fa4\u5c9b" },
            { "ID", "\u5370\u5ea6\u5c3c\u897f\u4e9a" },
            { "IE", "\u7231\u5c14\u5170" },
            { "IL", "\u4ee5\u8272\u5217" },
            { "IM", "\u9a6c\u6069\u5c9b" },
            { "IN", "\u5370\u5ea6" },
            { "IO", "\u82f1\u5c5e\u5370\u5ea6\u6d0b\u9886\u5730" },
            { "IQ", "\u4f0a\u62c9\u514b" },
            { "IR", "\u4f0a\u6717" },
            { "IS", "\u51b0\u5c9b" },
            { "IT", "\u610f\u5927\u5229" },
            { "JE", "\u6cfd\u897f\u5c9b" },
            { "JM", "\u7259\u4e70\u52a0" },
            { "JO", "\u7ea6\u65e6" },
            { "JP", "\u65e5\u672c" },
            { "KE", "\u80af\u5c3c\u4e9a" },
            { "KG", "\u5409\u5c14\u5409\u65af\u65af\u5766" },
            { "KH", "\u67ec\u57d4\u5be8" },
            { "KI", "\u57fa\u91cc\u5df4\u65af" },
            { "KM", "\u79d1\u6469\u7f57" },
            { "KN", "\u5723\u57fa\u8328\u548c\u5c3c\u7ef4\u65af" },
            { "KP", "\u671d\u9c9c" },
            { "KR", "\u97e9\u56fd" },
            { "KW", "\u79d1\u5a01\u7279" },
            { "KY", "\u5f00\u66fc\u7fa4\u5c9b" },
            { "KZ", "\u54c8\u8428\u514b\u65af\u5766" },
            { "LA", "\u8001\u631d" },
            { "LB", "\u9ece\u5df4\u5ae9" },
            { "LC", "\u5723\u5362\u897f\u4e9a" },
            { "LI", "\u5217\u652f\u6566\u58eb\u767b" },
            { "LK", "\u65af\u91cc\u5170\u5361" },
            { "LR", "\u5229\u6bd4\u91cc\u4e9a" },
            { "LS", "\u83b1\u7d22\u6258" },
            { "LT", "\u7acb\u9676\u5b9b" },
            { "LU", "\u5362\u68ee\u5821" },
            { "LV", "\u62c9\u8131\u7ef4\u4e9a" },
            { "LY", "\u5229\u6bd4\u4e9a" },
            { "MA", "\u6469\u6d1b\u54e5" },
            { "MC", "\u6469\u7eb3\u54e5" },
            { "MD", "\u6469\u5c14\u591a\u74e6" },
            { "ME", "\u9ed1\u5c71" },
            { "MF", "\u6cd5\u5c5e\u5723\u9a6c\u4e01" },
            { "MG", "\u9a6c\u8fbe\u52a0\u65af\u52a0" },
            { "MH", "\u9a6c\u7ecd\u5c14\u7fa4\u5c9b" },
            { "MK", "\u5317\u9a6c\u5176\u987f" },
            { "ML", "\u9a6c\u91cc" },
            { "MM", "\u7f05\u7538" },
            { "MN", "\u8499\u53e4" },
            { "MO", "\u4e2d\u56fd\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a" },
            { "MP", "\u5317\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b" },
            { "MQ", "\u9a6c\u63d0\u5c3c\u514b" },
            { "MR", "\u6bdb\u91cc\u5854\u5c3c\u4e9a" },
            { "MS", "\u8499\u7279\u585e\u62c9\u7279" },
            { "MT", "\u9a6c\u8033\u4ed6" },
            { "MU", "\u6bdb\u91cc\u6c42\u65af" },
            { "MV", "\u9a6c\u5c14\u4ee3\u592b" },
            { "MW", "\u9a6c\u62c9\u7ef4" },
            { "MX", "\u58a8\u897f\u54e5" },
            { "MY", "\u9a6c\u6765\u897f\u4e9a" },
            { "MZ", "\u83ab\u6851\u6bd4\u514b" },
            { "NA", "\u7eb3\u7c73\u6bd4\u4e9a" },
            { "NC", "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a" },
            { "NE", "\u5c3c\u65e5\u5c14" },
            { "NF", "\u8bfa\u798f\u514b\u5c9b" },
            { "NG", "\u5c3c\u65e5\u5229\u4e9a" },
            { "NI", "\u5c3c\u52a0\u62c9\u74dc" },
            { "NL", "\u8377\u5170" },
            { "NO", "\u632a\u5a01" },
            { "NP", "\u5c3c\u6cca\u5c14" },
            { "NR", "\u7459\u9c81" },
            { "NU", "\u7ebd\u57c3" },
            { "NZ", "\u65b0\u897f\u5170" },
            { "OM", "\u963f\u66fc" },
            { "PA", "\u5df4\u62ff\u9a6c" },
            { "PE", "\u79d8\u9c81" },
            { "PF", "\u6cd5\u5c5e\u6ce2\u5229\u5c3c\u897f\u4e9a" },
            { "PG", "\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a" },
            { "PH", "\u83f2\u5f8b\u5bbe" },
            { "PK", "\u5df4\u57fa\u65af\u5766" },
            { "PL", "\u6ce2\u5170" },
            { "PM", "\u5723\u76ae\u57c3\u5c14\u548c\u5bc6\u514b\u9686\u7fa4\u5c9b" },
            { "PN", "\u76ae\u7279\u51ef\u6069\u7fa4\u5c9b" },
            { "PR", "\u6ce2\u591a\u9ece\u5404" },
            { "PS", "\u5df4\u52d2\u65af\u5766\u9886\u571f" },
            { "PT", "\u8461\u8404\u7259" },
            { "PW", "\u5e15\u52b3" },
            { "PY", "\u5df4\u62c9\u572d" },
            { "QA", "\u5361\u5854\u5c14" },
            { "QO", "\u5927\u6d0b\u6d32\u8fb9\u8fdc\u7fa4\u5c9b" },
            { "RE", "\u7559\u5c3c\u6c6a" },
            { "RO", "\u7f57\u9a6c\u5c3c\u4e9a" },
            { "RS", "\u585e\u5c14\u7ef4\u4e9a" },
            { "RU", "\u4fc4\u7f57\u65af" },
            { "RW", "\u5362\u65fa\u8fbe" },
            { "SA", "\u6c99\u7279\u963f\u62c9\u4f2f" },
            { "SB", "\u6240\u7f57\u95e8\u7fa4\u5c9b" },
            { "SC", "\u585e\u820c\u5c14" },
            { "SD", "\u82cf\u4e39" },
            { "SE", "\u745e\u5178" },
            { "SG", "\u65b0\u52a0\u5761" },
            { "SH", "\u5723\u8d6b\u52d2\u62ff" },
            { "SI", "\u65af\u6d1b\u6587\u5c3c\u4e9a" },
            { "SJ", "\u65af\u74e6\u5c14\u5df4\u548c\u626c\u9a6c\u5ef6" },
            { "SK", "\u65af\u6d1b\u4f10\u514b" },
            { "SL", "\u585e\u62c9\u5229\u6602" },
            { "SM", "\u5723\u9a6c\u529b\u8bfa" },
            { "SN", "\u585e\u5185\u52a0\u5c14" },
            { "SO", "\u7d22\u9a6c\u91cc" },
            { "SR", "\u82cf\u91cc\u5357" },
            { "SS", "\u5357\u82cf\u4e39" },
            { "ST", "\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4" },
            { "SV", "\u8428\u5c14\u74e6\u591a" },
            { "SX", "\u8377\u5c5e\u5723\u9a6c\u4e01" },
            { "SY", "\u53d9\u5229\u4e9a" },
            { "SZ", "\u65af\u5a01\u58eb\u5170" },
            { "TA", "\u7279\u91cc\u65af\u5766-\u8fbe\u5e93\u5c3c\u4e9a\u7fa4\u5c9b" },
            { "TC", "\u7279\u514b\u65af\u548c\u51ef\u79d1\u65af\u7fa4\u5c9b" },
            { "TD", "\u4e4d\u5f97" },
            { "TF", "\u6cd5\u5c5e\u5357\u90e8\u9886\u5730" },
            { "TG", "\u591a\u54e5" },
            { "TH", "\u6cf0\u56fd" },
            { "TJ", "\u5854\u5409\u514b\u65af\u5766" },
            { "TK", "\u6258\u514b\u52b3" },
            { "TL", "\u4e1c\u5e1d\u6c76" },
            { "TM", "\u571f\u5e93\u66fc\u65af\u5766" },
            { "TN", "\u7a81\u5c3c\u65af" },
            { "TO", "\u6c64\u52a0" },
            { "TR", "\u571f\u8033\u5176" },
            { "TT", "\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5" },
            { "TV", "\u56fe\u74e6\u5362" },
            { "TW", "\u53f0\u6e7e" },
            { "TZ", "\u5766\u6851\u5c3c\u4e9a" },
            { "UA", "\u4e4c\u514b\u5170" },
            { "UG", "\u4e4c\u5e72\u8fbe" },
            { "UM", "\u7f8e\u56fd\u672c\u571f\u5916\u5c0f\u5c9b\u5c7f" },
            { "UN", "\u8054\u5408\u56fd" },
            { "US", "\u7f8e\u56fd" },
            { "UY", "\u4e4c\u62c9\u572d" },
            { "UZ", "\u4e4c\u5179\u522b\u514b\u65af\u5766" },
            { "VA", "\u68b5\u8482\u5188" },
            { "VC", "\u5723\u6587\u68ee\u7279\u548c\u683c\u6797\u7eb3\u4e01\u65af" },
            { "VE", "\u59d4\u5185\u745e\u62c9" },
            { "VG", "\u82f1\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b" },
            { "VI", "\u7f8e\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b" },
            { "VN", "\u8d8a\u5357" },
            { "VU", "\u74e6\u52aa\u963f\u56fe" },
            { "WF", "\u74e6\u5229\u65af\u548c\u5bcc\u56fe\u7eb3" },
            { "WS", "\u8428\u6469\u4e9a" },
            { "XA", "\u4f2a\u5730\u533a" },
            { "XB", "\u4f2a\u53cc\u5411\u8bed\u8a00\u5730\u533a" },
            { "XK", "\u79d1\u7d22\u6c83" },
            { "YE", "\u4e5f\u95e8" },
            { "YT", "\u9a6c\u7ea6\u7279" },
            { "ZA", "\u5357\u975e" },
            { "ZM", "\u8d5e\u6bd4\u4e9a" },
            { "ZW", "\u6d25\u5df4\u5e03\u97e6" },
            { "ZZ", "\u672a\u77e5\u5730\u533a" },
            { "aa", "\u963f\u6cd5\u5c14\u8bed" },
            { "ab", "\u963f\u5e03\u54c8\u897f\u4e9a\u8bed" },
            { "ae", "\u963f\u7ef4\u65af\u5854\u8bed" },
            { "af", "\u5357\u975e\u8377\u5170\u8bed" },
            { "ak", "\u963f\u80af\u8bed" },
            { "am", "\u963f\u59c6\u54c8\u62c9\u8bed" },
            { "an", "\u963f\u62c9\u8d21\u8bed" },
            { "ar", "\u963f\u62c9\u4f2f\u8bed" },
            { "as", "\u963f\u8428\u59c6\u8bed" },
            { "av", "\u963f\u74e6\u5c14\u8bed" },
            { "ay", "\u827e\u9a6c\u62c9\u8bed" },
            { "az", "\u963f\u585e\u62dc\u7586\u8bed" },
            { "ba", "\u5df4\u4ec0\u57fa\u5c14\u8bed" },
            { "be", "\u767d\u4fc4\u7f57\u65af\u8bed" },
            { "bg", "\u4fdd\u52a0\u5229\u4e9a\u8bed" },
            { "bi", "\u6bd4\u65af\u62c9\u9a6c\u8bed" },
            { "bm", "\u73ed\u5df4\u62c9\u8bed" },
            { "bn", "\u5b5f\u52a0\u62c9\u8bed" },
            { "bo", "\u85cf\u8bed" },
            { "br", "\u5e03\u5217\u5854\u5c3c\u8bed" },
            { "bs", "\u6ce2\u65af\u5c3c\u4e9a\u8bed" },
            { "ca", "\u52a0\u6cf0\u7f57\u5c3c\u4e9a\u8bed" },
            { "ce", "\u8f66\u81e3\u8bed" },
            { "ch", "\u67e5\u83ab\u7f57\u8bed" },
            { "co", "\u79d1\u897f\u5609\u8bed" },
            { "cr", "\u514b\u91cc\u8bed" },
            { "cs", "\u6377\u514b\u8bed" },
            { "cu", "\u6559\u4f1a\u65af\u62c9\u592b\u8bed" },
            { "cv", "\u695a\u74e6\u4ec0\u8bed" },
            { "cy", "\u5a01\u5c14\u58eb\u8bed" },
            { "da", "\u4e39\u9ea6\u8bed" },
            { "de", "\u5fb7\u8bed" },
            { "dv", "\u8fea\u7ef4\u5e0c\u8bed" },
            { "dz", "\u5b97\u5361\u8bed" },
            { "ee", "\u57c3\u7ef4\u8bed" },
            { "el", "\u5e0c\u814a\u8bed" },
            { "en", "\u82f1\u8bed" },
            { "eo", "\u4e16\u754c\u8bed" },
            { "es", "\u897f\u73ed\u7259\u8bed" },
            { "et", "\u7231\u6c99\u5c3c\u4e9a\u8bed" },
            { "eu", "\u5df4\u65af\u514b\u8bed" },
            { "fa", "\u6ce2\u65af\u8bed" },
            { "ff", "\u5bcc\u62c9\u8bed" },
            { "fi", "\u82ac\u5170\u8bed" },
            { "fj", "\u6590\u6d4e\u8bed" },
            { "fo", "\u6cd5\u7f57\u8bed" },
            { "fr", "\u6cd5\u8bed" },
            { "fy", "\u897f\u5f17\u91cc\u897f\u4e9a\u8bed" },
            { "ga", "\u7231\u5c14\u5170\u8bed" },
            { "gd", "\u82cf\u683c\u5170\u76d6\u5c14\u8bed" },
            { "gl", "\u52a0\u5229\u897f\u4e9a\u8bed" },
            { "gn", "\u74dc\u62c9\u5c3c\u8bed" },
            { "gu", "\u53e4\u5409\u62c9\u7279\u8bed" },
            { "gv", "\u9a6c\u6069\u8bed" },
            { "ha", "\u8c6a\u8428\u8bed" },
            { "he", "\u5e0c\u4f2f\u6765\u8bed" },
            { "hi", "\u5370\u5730\u8bed" },
            { "ho", "\u5e0c\u91cc\u83ab\u56fe\u8bed" },
            { "hr", "\u514b\u7f57\u5730\u4e9a\u8bed" },
            { "ht", "\u6d77\u5730\u514b\u91cc\u5965\u5c14\u8bed" },
            { "hu", "\u5308\u7259\u5229\u8bed" },
            { "hy", "\u4e9a\u7f8e\u5c3c\u4e9a\u8bed" },
            { "hz", "\u8d6b\u96f7\u7f57\u8bed" },
            { "ia", "\u56fd\u9645\u8bed" },
            { "id", "\u5370\u5ea6\u5c3c\u897f\u4e9a\u8bed" },
            { "ie", "\u56fd\u9645\u6587\u5b57\uff08E\uff09" },
            { "ig", "\u4f0a\u535a\u8bed" },
            { "ii", "\u56db\u5ddd\u5f5d\u8bed" },
            { "ik", "\u4f0a\u52aa\u76ae\u514b\u8bed" },
            { "io", "\u4f0a\u591a\u8bed" },
            { "is", "\u51b0\u5c9b\u8bed" },
            { "it", "\u610f\u5927\u5229\u8bed" },
            { "iu", "\u56e0\u7ebd\u7279\u8bed" },
            { "ja", "\u65e5\u8bed" },
            { "jv", "\u722a\u54c7\u8bed" },
            { "ka", "\u683c\u9c81\u5409\u4e9a\u8bed" },
            { "kg", "\u521a\u679c\u8bed" },
            { "ki", "\u5409\u5e93\u5c24\u8bed" },
            { "kj", "\u5bbd\u4e9a\u739b\u8bed" },
            { "kk", "\u54c8\u8428\u514b\u8bed" },
            { "kl", "\u683c\u9675\u5170\u8bed" },
            { "km", "\u9ad8\u68c9\u8bed" },
            { "kn", "\u5361\u7eb3\u8fbe\u8bed" },
            { "ko", "\u97e9\u8bed" },
            { "kr", "\u5361\u52aa\u91cc\u8bed" },
            { "ks", "\u514b\u4ec0\u7c73\u5c14\u8bed" },
            { "ku", "\u5e93\u5c14\u5fb7\u8bed" },
            { "kv", "\u79d1\u7c73\u8bed" },
            { "kw", "\u5eb7\u6c83\u5c14\u8bed" },
            { "ky", "\u67ef\u5c14\u514b\u5b5c\u8bed" },
            { "la", "\u62c9\u4e01\u8bed" },
            { "lb", "\u5362\u68ee\u5821\u8bed" },
            { "lg", "\u5362\u5e72\u8fbe\u8bed" },
            { "li", "\u6797\u5821\u8bed" },
            { "ln", "\u6797\u52a0\u62c9\u8bed" },
            { "lo", "\u8001\u631d\u8bed" },
            { "lt", "\u7acb\u9676\u5b9b\u8bed" },
            { "lu", "\u9c81\u5df4\u52a0\u4e39\u52a0\u8bed" },
            { "lv", "\u62c9\u8131\u7ef4\u4e9a\u8bed" },
            { "mg", "\u9a6c\u62c9\u52a0\u65af\u8bed" },
            { "mh", "\u9a6c\u7ecd\u5c14\u8bed" },
            { "mi", "\u6bdb\u5229\u8bed" },
            { "mk", "\u9a6c\u5176\u987f\u8bed" },
            { "ml", "\u9a6c\u62c9\u96c5\u62c9\u59c6\u8bed" },
            { "mn", "\u8499\u53e4\u8bed" },
            { "mr", "\u9a6c\u62c9\u5730\u8bed" },
            { "ms", "\u9a6c\u6765\u8bed" },
            { "mt", "\u9a6c\u8033\u4ed6\u8bed" },
            { "my", "\u7f05\u7538\u8bed" },
            { "na", "\u7459\u9c81\u8bed" },
            { "nb", "\u4e66\u9762\u632a\u5a01\u8bed" },
            { "nd", "\u5317\u6069\u5fb7\u8d1d\u52d2\u8bed" },
            { "ne", "\u5c3c\u6cca\u5c14\u8bed" },
            { "ng", "\u6069\u4e1c\u52a0\u8bed" },
            { "nl", "\u8377\u5170\u8bed" },
            { "nn", "\u632a\u5a01\u5c3c\u8bfa\u65af\u514b\u8bed" },
            { "no", "\u632a\u5a01\u8bed" },
            { "nr", "\u5357\u6069\u5fb7\u8d1d\u52d2\u8bed" },
            { "nv", "\u7eb3\u74e6\u970d\u8bed" },
            { "ny", "\u9f50\u5207\u74e6\u8bed" },
            { "oc", "\u5965\u514b\u8bed" },
            { "oj", "\u5965\u5409\u5e03\u74e6\u8bed" },
            { "om", "\u5965\u7f57\u83ab\u8bed" },
            { "or", "\u5965\u91cc\u4e9a\u8bed" },
            { "os", "\u5965\u585e\u68af\u8bed" },
            { "pa", "\u65c1\u906e\u666e\u8bed" },
            { "pi", "\u5df4\u5229\u8bed" },
            { "pl", "\u6ce2\u5170\u8bed" },
            { "ps", "\u666e\u4ec0\u56fe\u8bed" },
            { "pt", "\u8461\u8404\u7259\u8bed" },
            { "qu", "\u514b\u4e18\u4e9a\u8bed" },
            { "rm", "\u7f57\u66fc\u4ec0\u8bed" },
            { "rn", "\u9686\u8fea\u8bed" },
            { "ro", "\u7f57\u9a6c\u5c3c\u4e9a\u8bed" },
            { "ru", "\u4fc4\u8bed" },
            { "rw", "\u5362\u65fa\u8fbe\u8bed" },
            { "sa", "\u68b5\u8bed" },
            { "sc", "\u8428\u4e01\u8bed" },
            { "sd", "\u4fe1\u5fb7\u8bed" },
            { "se", "\u5317\u65b9\u8428\u7c73\u8bed" },
            { "sg", "\u6851\u6208\u8bed" },
            { "sh", "\u585e\u5c14\u7ef4\u4e9a-\u514b\u7f57\u5730\u4e9a\u8bed" },
            { "si", "\u50e7\u4f3d\u7f57\u8bed" },
            { "sk", "\u65af\u6d1b\u4f10\u514b\u8bed" },
            { "sl", "\u65af\u6d1b\u6587\u5c3c\u4e9a\u8bed" },
            { "sm", "\u8428\u6469\u4e9a\u8bed" },
            { "sn", "\u7ecd\u7eb3\u8bed" },
            { "so", "\u7d22\u9a6c\u91cc\u8bed" },
            { "sq", "\u963f\u5c14\u5df4\u5c3c\u4e9a\u8bed" },
            { "sr", "\u585e\u5c14\u7ef4\u4e9a\u8bed" },
            { "ss", "\u65af\u74e6\u8482\u8bed" },
            { "st", "\u5357\u7d22\u6258\u8bed" },
            { "su", "\u5dfd\u4ed6\u8bed" },
            { "sv", "\u745e\u5178\u8bed" },
            { "sw", "\u65af\u74e6\u5e0c\u91cc\u8bed" },
            { "ta", "\u6cf0\u7c73\u5c14\u8bed" },
            { "te", "\u6cf0\u5362\u56fa\u8bed" },
            { "tg", "\u5854\u5409\u514b\u8bed" },
            { "th", "\u6cf0\u8bed" },
            { "ti", "\u63d0\u683c\u5229\u5c3c\u4e9a\u8bed" },
            { "tk", "\u571f\u5e93\u66fc\u8bed" },
            { "tl", "\u4ed6\u52a0\u7984\u8bed" },
            { "tn", "\u8328\u74e6\u7eb3\u8bed" },
            { "to", "\u6c64\u52a0\u8bed" },
            { "tr", "\u571f\u8033\u5176\u8bed" },
            { "ts", "\u806a\u52a0\u8bed" },
            { "tt", "\u9791\u977c\u8bed" },
            { "tw", "\u5951\u7ef4\u8bed" },
            { "ty", "\u5854\u5e0c\u63d0\u8bed" },
            { "ug", "\u7ef4\u543e\u5c14\u8bed" },
            { "uk", "\u4e4c\u514b\u5170\u8bed" },
            { "ur", "\u4e4c\u5c14\u90fd\u8bed" },
            { "uz", "\u4e4c\u5179\u522b\u514b\u8bed" },
            { "ve", "\u6587\u8fbe\u8bed" },
            { "vi", "\u8d8a\u5357\u8bed" },
            { "vo", "\u6c83\u62c9\u666e\u514b\u8bed" },
            { "wa", "\u74e6\u9686\u8bed" },
            { "wo", "\u6c83\u6d1b\u592b\u8bed" },
            { "xh", "\u79d1\u8428\u8bed" },
            { "yi", "\u610f\u7b2c\u7eea\u8bed" },
            { "yo", "\u7ea6\u9c81\u5df4\u8bed" },
            { "za", "\u58ee\u8bed" },
            { "zh", "\u4e2d\u6587" },
            { "zu", "\u7956\u9c81\u8bed" },
            { "ace", "\u4e9a\u9f50\u8bed" },
            { "ach", "\u963f\u4e54\u5229\u8bed" },
            { "ada", "\u963f\u5f53\u6885\u8bed" },
            { "ady", "\u963f\u8fea\u683c\u8bed" },
            { "afh", "\u963f\u5f17\u91cc\u5e0c\u5229\u8bed" },
            { "agq", "\u4e9a\u7f55\u8bed" },
            { "ain", "\u963f\u4f0a\u52aa\u8bed" },
            { "akk", "\u963f\u5361\u5fb7\u8bed" },
            { "ale", "\u963f\u7559\u7533\u8bed" },
            { "alt", "\u5357\u963f\u5c14\u6cf0\u8bed" },
            { "ang", "\u53e4\u82f1\u8bed" },
            { "ann", "\u5965\u535a\u6d1b\u8bed" },
            { "anp", "\u6602\u52a0\u8bed" },
            { "arc", "\u963f\u62c9\u7c73\u8bed" },
            { "arn", "\u9a6c\u666e\u5207\u8bed" },
            { "arp", "\u963f\u62c9\u5e15\u970d\u8bed" },
            { "ars", "\u7eb3\u5409\u8fea\u963f\u62c9\u4f2f\u8bed" },
            { "arw", "\u963f\u62c9\u74e6\u514b\u8bed" },
            { "asa", "\u5e15\u96f7\u8bed" },
            { "ast", "\u963f\u65af\u56fe\u91cc\u4e9a\u65af\u8bed" },
            { "atj", "\u963f\u63d0\u5361\u7c73\u514b\u8bed" },
            { "awa", "\u963f\u74e6\u5fb7\u8bed" },
            { "bal", "\u4ffe\u8def\u652f\u8bed" },
            { "ban", "\u5df4\u5398\u8bed" },
            { "bas", "\u5df4\u8428\u8bed" },
            { "bax", "\u5df4\u59c6\u7a46\u8bed" },
            { "bbj", "\u6208\u9a6c\u62c9\u8bed" },
            { "bej", "\u8d1d\u6c99\u8bed" },
            { "bem", "\u672c\u5df4\u8bed" },
            { "bez", "\u8d1d\u7eb3\u8bed" },
            { "bfd", "\u5df4\u975e\u7279\u8bed" },
            { "bgn", "\u897f\u4ffe\u8def\u652f\u8bed" },
            { "bho", "\u535a\u6770\u666e\u5c14\u8bed" },
            { "bik", "\u6bd4\u79d1\u5c14\u8bed" },
            { "bin", "\u6bd4\u5c3c\u8bed" },
            { "bkm", "\u79d1\u59c6\u8bed" },
            { "bla", "\u897f\u514b\u897f\u5361\u8bed" },
            { "bra", "\u5e03\u62c9\u6770\u8bed" },
            { "brx", "\u535a\u591a\u8bed" },
            { "bss", "\u963f\u5e93\u8272\u8bed" },
            { "bua", "\u5e03\u91cc\u4e9a\u7279\u8bed" },
            { "bug", "\u5e03\u5409\u8bed" },
            { "bum", "\u5e03\u9c81\u8bed" },
            { "byn", "\u6bd4\u6797\u8bed" },
            { "byv", "\u6885\u6566\u5df4\u8bed" },
            { "cad", "\u5361\u591a\u8bed" },
            { "car", "\u52a0\u52d2\u6bd4\u8bed" },
            { "cay", "\u5361\u5c24\u52a0\u8bed" },
            { "cch", "\u963f\u707f\u8bed" },
            { "ccp", "\u67e5\u514b\u739b\u8bed" },
            { "ceb", "\u5bbf\u52a1\u8bed" },
            { "cgg", "\u5947\u52a0\u8bed" },
            { "chb", "\u5947\u5e03\u67e5\u8bed" },
            { "chg", "\u5bdf\u5408\u53f0\u8bed" },
            { "chk", "\u695a\u514b\u8bed" },
            { "chm", "\u9a6c\u91cc\u8bed" },
            { "chn", "\u5947\u52aa\u514b\u6df7\u5408\u8bed" },
            { "cho", "\u4e54\u514b\u6258\u8bed" },
            { "chp", "\u5947\u4f69\u7ef4\u5b89\u8bed" },
            { "chr", "\u5207\u7f57\u57fa\u8bed" },
            { "chy", "\u590f\u5ef6\u8bed" },
            { "ckb", "\u4e2d\u5e93\u5c14\u5fb7\u8bed" },
            { "clc", "\u5947\u5c14\u79d1\u5ef7\u8bed" },
            { "cop", "\u79d1\u666e\u7279\u8bed" },
            { "crg", "\u7c73\u5176\u8299\u8bed" },
            { "crh", "\u514b\u91cc\u7c73\u4e9a\u9791\u977c\u8bed" },
            { "crj", "\u4e1c\u5357\u90e8\u514b\u91cc\u8bed" },
            { "crk", "\u5e73\u539f\u514b\u91cc\u8bed" },
            { "crl", "\u4e1c\u5317\u90e8\u514b\u91cc\u8bed" },
            { "crm", "\u7a46\u65af\u514b\u91cc\u8bed" },
            { "crr", "\u5361\u7f57\u83b1\u7eb3\u5dde\u963f\u5c14\u5188\u6606\u8bed" },
            { "crs", "\u585e\u820c\u5c14\u514b\u91cc\u5965\u5c14\u8bed" },
            { "csb", "\u5361\u8212\u6bd4\u8bed" },
            { "csw", "\u6cbc\u6cfd\u514b\u91cc\u8bed" },
            { "dak", "\u8fbe\u79d1\u4ed6\u8bed" },
            { "dar", "\u8fbe\u5c14\u683c\u74e6\u8bed" },
            { "dav", "\u53f0\u5854\u8bed" },
            { "del", "\u7279\u62c9\u534e\u8bed" },
            { "den", "\u53f2\u62c9\u7ef4\u8bed" },
            { "dgr", "\u591a\u683c\u91cc\u5e03\u8bed" },
            { "din", "\u4e01\u5361\u8bed" },
            { "dje", "\u54f2\u5c14\u9a6c\u8bed" },
            { "doi", "\u591a\u683c\u62c9\u8bed" },
            { "dsb", "\u4e0b\u7d22\u5e03\u8bed" },
            { "dua", "\u675c\u963f\u62c9\u8bed" },
            { "dum", "\u4e2d\u53e4\u8377\u5170\u8bed" },
            { "dyo", "\u6731\u62c9\u8bed" },
            { "dyu", "\u8fea\u5c24\u62c9\u8bed" },
            { "dzg", "\u8fbe\u624e\u845b\u8bed" },
            { "ebu", "\u6069\u5e03\u8bed" },
            { "efi", "\u57c3\u83f2\u514b\u8bed" },
            { "egy", "\u53e4\u57c3\u53ca\u8bed" },
            { "eka", "\u827e\u5361\u6731\u514b\u8bed" },
            { "elx", "\u57c3\u5170\u8bed" },
            { "enm", "\u4e2d\u53e4\u82f1\u8bed" },
            { "ewo", "\u57c3\u7fc1\u591a\u8bed" },
            { "fan", "\u82b3\u683c\u8bed" },
            { "fat", "\u82b3\u8482\u8bed" },
            { "fil", "\u83f2\u5f8b\u5bbe\u8bed" },
            { "fon", "\u4e30\u8bed" },
            { "frc", "\u5361\u771f\u6cd5\u8bed" },
            { "frm", "\u4e2d\u53e4\u6cd5\u8bed" },
            { "fro", "\u53e4\u6cd5\u8bed" },
            { "frr", "\u5317\u5f17\u91cc\u897f\u4e9a\u8bed" },
            { "frs", "\u4e1c\u5f17\u91cc\u897f\u4e9a\u8bed" },
            { "fur", "\u5f17\u7559\u5229\u8bed" },
            { "gaa", "\u52a0\u65cf\u8bed" },
            { "gag", "\u52a0\u544a\u5179\u8bed" },
            { "gan", "\u8d63\u8bed" },
            { "gay", "\u8fe6\u7ea6\u8bed" },
            { "gba", "\u683c\u5df4\u4e9a\u8bed" },
            { "gez", "\u5409\u5179\u8bed" },
            { "gil", "\u5409\u5c14\u4f2f\u7279\u8bed" },
            { "gmh", "\u4e2d\u53e4\u9ad8\u5730\u5fb7\u8bed" },
            { "goh", "\u53e4\u9ad8\u5730\u5fb7\u8bed" },
            { "gon", "\u5188\u5fb7\u8bed" },
            { "gor", "\u54e5\u4f26\u6253\u6d1b\u8bed" },
            { "got", "\u54e5\u7279\u8bed" },
            { "grb", "\u683c\u5217\u535a\u8bed" },
            { "grc", "\u53e4\u5e0c\u814a\u8bed" },
            { "gsw", "\u745e\u58eb\u5fb7\u8bed" },
            { "guz", "\u53e4\u897f\u8bed" },
            { "gwi", "\u54e5\u5a01\u8fc5\u8bed" },
            { "hai", "\u6d77\u8fbe\u8bed" },
            { "hak", "\u5ba2\u5bb6\u8bed" },
            { "haw", "\u590f\u5a01\u5937\u8bed" },
            { "hax", "\u5357\u6d77\u8fbe\u8bed" },
            { "hil", "\u5e0c\u5229\u76d6\u519c\u8bed" },
            { "hit", "\u8d6b\u68af\u8bed" },
            { "hmn", "\u82d7\u8bed" },
            { "hsb", "\u4e0a\u7d22\u5e03\u8bed" },
            { "hsn", "\u6e58\u8bed" },
            { "hup", "\u80e1\u5e15\u8bed" },
            { "hur", "\u54c8\u5c14\u9b41\u6885\u6797\u8bed" },
            { "iba", "\u4f0a\u73ed\u8bed" },
            { "ibb", "\u4f0a\u6bd4\u6bd4\u5965\u8bed" },
            { "ikt", "\u897f\u52a0\u62ff\u5927\u56e0\u7ebd\u7279\u8bed" },
            { "ilo", "\u4f0a\u6d1b\u5361\u8bfa\u8bed" },
            { "inh", "\u5370\u53e4\u4ec0\u8bed" },
            { "jbo", "\u903b\u8f91\u8bed" },
            { "jgo", "\u6069\u826e\u5df4\u8bed" },
            { "jmc", "\u9a6c\u5207\u59c6\u8bed" },
            { "jpr", "\u72b9\u592a\u6ce2\u65af\u8bed" },
            { "jrb", "\u72b9\u592a\u963f\u62c9\u4f2f\u8bed" },
            { "kaa", "\u5361\u62c9\u5361\u5c14\u5e15\u514b\u8bed" },
            { "kab", "\u5361\u62dc\u5c14\u8bed" },
            { "kac", "\u514b\u94a6\u8bed" },
            { "kaj", "\u5361\u6377\u8bed" },
            { "kam", "\u5361\u59c6\u5df4\u8bed" },
            { "kaw", "\u5361\u5a01\u8bed" },
            { "kbd", "\u5361\u5df4\u5c14\u5fb7\u8bed" },
            { "kbl", "\u52a0\u6d85\u59c6\u5e03\u8bed" },
            { "kcg", "\u5361\u5854\u5e03\u8bed" },
            { "kde", "\u9a6c\u5b54\u5fb7\u8bed" },
            { "kea", "\u5361\u5e03\u4f5b\u5f97\u9c81\u8bed" },
            { "kfo", "\u514b\u7f57\u8bed" },
            { "kgp", "\u574e\u521a\u8bed" },
            { "kha", "\u5361\u897f\u8bed" },
            { "kho", "\u548c\u7530\u8bed" },
            { "khq", "\u897f\u6851\u6d77\u8bed" },
            { "kkj", "\u5361\u5e93\u8bed" },
            { "kln", "\u5361\u4f26\u91d1\u8bed" },
            { "kmb", "\u91d1\u90a6\u675c\u8bed" },
            { "koi", "\u79d1\u7c73-\u5f7c\u5c14\u7c73\u4e9a\u514b\u8bed" },
            { "kok", "\u5b54\u5361\u5c3c\u8bed" },
            { "kos", "\u79d1\u65af\u62c9\u4f0a\u8bed" },
            { "kpe", "\u514b\u4f69\u5217\u8bed" },
            { "krc", "\u5361\u62c9\u6070\u4f0a\u5df4\u5c14\u5361\u5c14\u8bed" },
            { "krl", "\u5361\u7d2f\u5229\u963f\u8bed" },
            { "kru", "\u5e93\u9c81\u514b\u8bed" },
            { "ksb", "\u9999\u5df4\u62c9\u8bed" },
            { "ksf", "\u5df4\u83f2\u4e9a\u8bed" },
            { "ksh", "\u79d1\u9686\u8bed" },
            { "kum", "\u5e93\u6885\u514b\u8bed" },
            { "kut", "\u5e93\u7279\u5948\u8bed" },
            { "kwk", "\u5938\u5938\u74e6\u62c9\u8bed" },
            { "lad", "\u62c9\u8fea\u8bfa\u8bed" },
            { "lag", "\u6717\u5409\u8bed" },
            { "lah", "\u897f\u65c1\u906e\u666e\u8bed" },
            { "lam", "\u5170\u5df4\u8bed" },
            { "lez", "\u5217\u5179\u91d1\u8bed" },
            { "lij", "\u5229\u53e4\u91cc\u4e9a\u8bed" },
            { "lil", "\u5229\u6d1b\u57c3\u7279\u8bed" },
            { "lkt", "\u62c9\u79d1\u5854\u8bed" },
            { "lol", "\u8499\u6208\u8bed" },
            { "lou", "\u8def\u6613\u65af\u5b89\u90a3\u514b\u91cc\u5965\u5c14\u8bed" },
            { "loz", "\u6d1b\u9f50\u8bed" },
            { "lrc", "\u5317\u5362\u5c14\u8bed" },
            { "lsm", "\u8428\u7c73\u4e9a\u8bed" },
            { "lua", "\u5362\u5df4-\u5362\u62c9\u8bed" },
            { "lui", "\u5362\u4f0a\u585e\u8bfa\u8bed" },
            { "lun", "\u9686\u8fbe\u8bed" },
            { "luo", "\u5362\u5965\u8bed" },
            { "lus", "\u7c73\u4f50\u8bed" },
            { "luy", "\u5362\u96c5\u8bed" },
            { "mad", "\u9a6c\u90fd\u62c9\u8bed" },
            { "maf", "\u9a6c\u6cd5\u8bed" },
            { "mag", "\u6469\u63ed\u9640\u8bed" },
            { "mai", "\u8fc8\u8482\u5229\u8bed" },
            { "mak", "\u671b\u52a0\u9521\u8bed" },
            { "man", "\u66fc\u4e01\u54e5\u8bed" },
            { "mas", "\u9a6c\u8d5b\u8bed" },
            { "mde", "\u9a6c\u575d\u8bed" },
            { "mdf", "\u83ab\u514b\u6c99\u8bed" },
            { "mdr", "\u66fc\u8fbe\u5c14\u8bed" },
            { "men", "\u95e8\u5fb7\u8bed" },
            { "mer", "\u6885\u9c81\u8bed" },
            { "mfe", "\u6bdb\u91cc\u6c42\u65af\u514b\u91cc\u5965\u5c14\u8bed" },
            { "mga", "\u4e2d\u53e4\u7231\u5c14\u5170\u8bed" },
            { "mgh", "\u9a6c\u5e93\u963f\u8bed" },
            { "mgo", "\u6885\u5854\u8bed" },
            { "mic", "\u5bc6\u514b\u9a6c\u514b\u8bed" },
            { "min", "\u7c73\u5357\u4f73\u4fdd\u8bed" },
            { "mnc", "\u6ee1\u8bed" },
            { "mni", "\u66fc\u5c3c\u666e\u5c14\u8bed" },
            { "moe", "\u56e0\u52aa\u57c3\u8499\u8bed" },
            { "moh", "\u6469\u970d\u514b\u8bed" },
            { "mos", "\u83ab\u897f\u8bed" },
            { "mua", "\u8499\u5f53\u8bed" },
            { "mul", "\u591a\u8bed\u79cd" },
            { "mus", "\u514b\u91cc\u514b\u8bed" },
            { "mwl", "\u7c73\u5170\u5fb7\u65af\u8bed" },
            { "mwr", "\u9a6c\u5c14\u74e6\u91cc\u8bed" },
            { "mye", "\u59c6\u8036\u5185\u8bed" },
            { "myv", "\u5384\u5c14\u5179\u4e9a\u8bed" },
            { "mzn", "\u9a6c\u8d5e\u5fb7\u5170\u8bed" },
            { "nan", "\u95fd\u5357\u8bed" },
            { "nap", "\u90a3\u4e0d\u52d2\u65af\u8bed" },
            { "naq", "\u7eb3\u9a6c\u8bed" },
            { "nds", "\u4f4e\u5730\u5fb7\u8bed" },
            { "new", "\u5c3c\u74e6\u5c14\u8bed" },
            { "nia", "\u5c3c\u4e9a\u65af\u8bed" },
            { "niu", "\u7ebd\u57c3\u8bed" },
            { "nmg", "\u5938\u897f\u5965\u8bed" },
            { "nnh", "\u6069\u7518\u6f8e\u8bed" },
            { "nog", "\u8bfa\u76d6\u8bed" },
            { "non", "\u53e4\u8bfa\u5c14\u65af\u8bed" },
            { "nqo", "\u897f\u975e\u4e66\u9762\u6587\u5b57" },
            { "nso", "\u5317\u7d22\u6258\u8bed" },
            { "nus", "\u52aa\u57c3\u5c14\u8bed" },
            { "nwc", "\u53e4\u5178\u5c3c\u74e6\u5c14\u8bed" },
            { "nym", "\u5c3c\u626c\u97e6\u9f50\u8bed" },
            { "nyn", "\u5c3c\u6602\u79d1\u52d2\u8bed" },
            { "nyo", "\u5c3c\u5965\u7f57\u8bed" },
            { "nzi", "\u6069\u6d4e\u9a6c\u8bed" },
            { "ojb", "\u897f\u5317\u90e8\u5965\u5409\u5e03\u74e6\u8bed" },
            { "ojc", "\u4e2d\u5965\u5409\u5e03\u74e6\u8bed" },
            { "ojs", "\u6b27\u5409\u514b\u91cc\u8bed" },
            { "ojw", "\u897f\u5965\u5409\u5e03\u74e6\u8bed" },
            { "oka", "\u6b27\u80af\u90a3\u6839\u8bed" },
            { "osa", "\u5965\u585e\u6cbb\u8bed" },
            { "ota", "\u5965\u65af\u66fc\u571f\u8033\u5176\u8bed" },
            { "pag", "\u90a6\u963f\u897f\u5357\u8bed" },
            { "pal", "\u5df4\u62c9\u7ef4\u8bed" },
            { "pam", "\u90a6\u677f\u7259\u8bed" },
            { "pap", "\u5e15\u76ae\u963f\u95e8\u6258\u8bed" },
            { "pau", "\u5e15\u52b3\u8bed" },
            { "pcm", "\u5c3c\u65e5\u5229\u4e9a\u76ae\u94a6\u8bed" },
            { "peo", "\u53e4\u6ce2\u65af\u8bed" },
            { "phn", "\u8153\u5c3c\u57fa\u8bed" },
            { "pis", "\u76ae\u4eac\u8bed" },
            { "pon", "\u6ce2\u7eb3\u4f69\u8bed" },
            { "pqm", "\u9a6c\u5229\u585e-\u5e15\u8428\u9a6c\u79d1\u8fea\u8bed" },
            { "prg", "\u666e\u9c81\u58eb\u8bed" },
            { "pro", "\u53e4\u666e\u7f57\u6587\u65af\u8bed" },
            { "quc", "\u57fa\u5207\u8bed" },
            { "raj", "\u62c9\u8d3e\u65af\u5766\u8bed" },
            { "rap", "\u62c9\u5e15\u52aa\u4f0a\u8bed" },
            { "rar", "\u62c9\u7f57\u6c64\u52a0\u8bed" },
            { "rhg", "\u7f57\u5174\u4e9a\u8bed" },
            { "rof", "\u5170\u535a\u8bed" },
            { "rom", "\u5409\u666e\u8d5b\u8bed" },
            { "rup", "\u963f\u7f57\u9a6c\u5c3c\u4e9a\u8bed" },
            { "rwk", "\u7f57\u74e6\u8bed" },
            { "sad", "\u6851\u8fbe\u97e6\u8bed" },
            { "sah", "\u8428\u54c8\u8bed" },
            { "sam", "\u8428\u9a6c\u5229\u4e9a\u963f\u62c9\u59c6\u8bed" },
            { "saq", "\u6851\u5e03\u9c81\u8bed" },
            { "sas", "\u8428\u8428\u514b\u6587" },
            { "sat", "\u6851\u5854\u5229\u8bed" },
            { "sba", "\u7518\u62dc\u8bed" },
            { "sbp", "\u6851\u53e4\u8bed" },
            { "scn", "\u897f\u897f\u91cc\u8bed" },
            { "sco", "\u82cf\u683c\u5170\u8bed" },
            { "sdh", "\u5357\u5e93\u5c14\u5fb7\u8bed" },
            { "see", "\u585e\u5185\u5361\u8bed" },
            { "seh", "\u585e\u7eb3\u8bed" },
            { "sel", "\u585e\u5c14\u5e93\u666e\u8bed" },
            { "ses", "\u4e1c\u6851\u6d77\u8bed" },
            { "sga", "\u53e4\u7231\u5c14\u5170\u8bed" },
            { "shi", "\u5e0c\u5c14\u54c8\u8bed" },
            { "shn", "\u63b8\u8bed" },
            { "shu", "\u4e4d\u5f97\u963f\u62c9\u4f2f\u8bed" },
            { "sid", "\u6089\u8fbe\u6469\u8bed" },
            { "slh", "\u5357\u5362\u8212\u7279\u79cd\u5b50\u8bed" },
            { "sma", "\u5357\u8428\u7c73\u8bed" },
            { "smj", "\u5415\u52d2\u8428\u7c73\u8bed" },
            { "smn", "\u4f0a\u7eb3\u91cc\u8428\u7c73\u8bed" },
            { "sms", "\u65af\u79d1\u7279\u8428\u7c73\u8bed" },
            { "snk", "\u7d22\u5b81\u514b\u8bed" },
            { "sog", "\u7c9f\u7279\u8bed" },
            { "srn", "\u82cf\u91cc\u5357\u6c64\u52a0\u8bed" },
            { "srr", "\u585e\u96f7\u5c14\u8bed" },
            { "ssy", "\u8428\u970d\u8bed" },
            { "str", "\u6d77\u5ce1\u8428\u5229\u5e0c\u8bed" },
            { "suk", "\u82cf\u5e93\u9a6c\u8bed" },
            { "sus", "\u82cf\u82cf\u8bed" },
            { "sux", "\u82cf\u7f8e\u5c14\u8bed" },
            { "swb", "\u79d1\u6469\u7f57\u8bed" },
            { "syc", "\u53e4\u5178\u53d9\u5229\u4e9a\u8bed" },
            { "syr", "\u53d9\u5229\u4e9a\u8bed" },
            { "tce", "\u5357\u5854\u7a79\u8bed" },
            { "tem", "\u6cf0\u59c6\u5948\u8bed" },
            { "teo", "\u7279\u7d22\u8bed" },
            { "ter", "\u7279\u4f26\u8bfa\u8bed" },
            { "tet", "\u5fb7\u987f\u8bed" },
            { "tgx", "\u5854\u5409\u4ec0\u8bed" },
            { "tht", "\u5854\u5c14\u5766\u8bed" },
            { "tig", "\u63d0\u683c\u96f7\u8bed" },
            { "tiv", "\u8482\u592b\u8bed" },
            { "tkl", "\u6258\u514b\u52b3\u8bed" },
            { "tlh", "\u514b\u6797\u8d21\u8bed" },
            { "tli", "\u7279\u6797\u5409\u7279\u8bed" },
            { "tmh", "\u5854\u9a6c\u5947\u514b\u8bed" },
            { "tog", "\u5c3c\u4e9a\u8428\u6c64\u52a0\u8bed" },
            { "tok", "\u9053\u672c\u8bed" },
            { "tpi", "\u6258\u514b\u76ae\u8f9b\u8bed" },
            { "trv", "\u8d5b\u5fb7\u514b\u8bed" },
            { "tsi", "\u94a6\u897f\u5b89\u8bed" },
            { "ttm", "\u5317\u5854\u7a79\u8bed" },
            { "tum", "\u901a\u5e03\u5361\u8bed" },
            { "tvl", "\u56fe\u74e6\u5362\u8bed" },
            { "twq", "\u5317\u6851\u6d77\u8bed" },
            { "tyv", "\u56fe\u74e6\u8bed" },
            { "tzm", "\u5854\u9a6c\u9f50\u683c\u7279\u8bed" },
            { "udm", "\u4e4c\u5fb7\u7a46\u5c14\u7279\u8bed" },
            { "uga", "\u4e4c\u52a0\u91cc\u7279\u8bed" },
            { "umb", "\u7fc1\u672c\u675c\u8bed" },
            { "und", "\u672a\u77e5\u8bed\u8a00" },
            { "vai", "\u74e6\u4f0a\u8bed" },
            { "vec", "\u5a01\u5c3c\u65af\u8bed" },
            { "vep", "\u7ef4\u666e\u68ee\u8bed" },
            { "vot", "\u6c83\u63d0\u514b\u8bed" },
            { "vun", "\u6e29\u65e7\u8bed" },
            { "wae", "\u74e6\u5c14\u745f\u8bed" },
            { "wal", "\u74e6\u62c9\u83ab\u8bed" },
            { "war", "\u74e6\u745e\u8bed" },
            { "was", "\u74e6\u7ecd\u8bed" },
            { "wbp", "\u74e6\u5c14\u76ae\u745e\u8bed" },
            { "wuu", "\u5434\u8bed" },
            { "xal", "\u5361\u5c14\u6885\u514b\u8bed" },
            { "xog", "\u7d22\u52a0\u8bed" },
            { "yao", "\u7476\u65cf\u8bed" },
            { "yap", "\u96c5\u6d66\u8bed" },
            { "yav", "\u6d0b\u535e\u8bed" },
            { "ybb", "\u8036\u59c6\u5df4\u8bed" },
            { "yrl", "\u6069\u52a0\u56fe\u8bed" },
            { "yue", "\u7ca4\u8bed" },
            { "zap", "\u8428\u6ce2\u8482\u514b\u8bed" },
            { "zbl", "\u5e03\u91cc\u65af\u7b26\u53f7" },
            { "zen", "\u6cfd\u7eb3\u52a0\u8bed" },
            { "zgh", "\u6807\u51c6\u6469\u6d1b\u54e5\u5854\u9a6c\u585e\u7279\u8bed" },
            { "zun", "\u7956\u5c3c\u8bed" },
            { "zxx", "\u65e0\u8bed\u8a00\u5185\u5bb9" },
            { "zza", "\u624e\u624e\u8bed" },
            { "Adlm", "\u963f\u5fb7\u62c9\u59c6\u6587" },
            { "Afak", "\u963f\u6cd5\u5361\u6587" },
            { "Aghb", "\u9ad8\u52a0\u7d22\u963f\u5c14\u5df4\u5c3c\u4e9a\u6587" },
            { "Ahom", "Ahom" },
            { "Arab", "\u963f\u62c9\u4f2f\u6587" },
            { "Aran", "\u6ce2\u65af\u4f53" },
            { "Armi", "\u7687\u5ba4\u4e9a\u62c9\u59c6\u6587" },
            { "Armn", "\u4e9a\u7f8e\u5c3c\u4e9a\u6587" },
            { "Avst", "\u963f\u7ef4\u65af\u9640\u6587" },
            { "Bali", "\u5df4\u5398\u6587" },
            { "Bamu", "\u5df4\u59c6\u7a46\u6587" },
            { "Bass", "\u5df4\u8428\u6587" },
            { "Batk", "\u5df4\u5854\u514b\u6587" },
            { "Beng", "\u5b5f\u52a0\u62c9\u6587" },
            { "Bhks", "\u62dc\u514b\u8212\u514b\u6587" },
            { "Blis", "\u5e03\u5217\u65af\u7b26\u53f7" },
            { "Bopo", "\u6c49\u8bed\u62fc\u97f3" },
            { "Brah", "\u5a46\u7f57\u7c73\u6587\u5b57" },
            { "Brai", "\u5e03\u83b1\u53f6\u76f2\u6587" },
            { "Bugi", "\u5e03\u5409\u6587" },
            { "Buhd", "\u5e03\u5e0c\u5fb7\u6587" },
            { "Cakm", "\u67e5\u514b\u9a6c\u6587" },
            { "Cans", "\u52a0\u62ff\u5927\u571f\u8457\u7edf\u4e00\u97f3\u8282" },
            { "Cari", "\u5361\u91cc\u4e9a\u6587" },
            { "Cham", "\u5360\u6587" },
            { "Cher", "\u5207\u7f57\u57fa\u6587" },
            { "Chrs", "\u82b1\u62c9\u5b50\u6a21\u6587" },
            { "Cirt", "\u8272\u65af\u6587" },
            { "Copt", "\u514b\u666e\u7279\u6587" },
            { "Cpmn", "\u585e\u6d66\u8def\u65af\u7c73\u8bfa\u65af\u6587" },
            { "Cprt", "\u585e\u6d66\u8def\u65af\u6587" },
            { "Cyrl", "\u897f\u91cc\u5c14\u6587" },
            { "Cyrs", "\u897f\u91cc\u5c14\u6587\u5b57\uff08\u53e4\u6559\u4f1a\u65af\u62c9\u592b\u6587\u7684\u53d8\u4f53\uff09" },
            { "Deva", "\u5929\u57ce\u6587" },
            { "Diak", "\u8fea\u7ef4\u897f\u963f\u5e93\u9c81\u6587" },
            { "Dogr", "\u591a\u683c\u62c9\u6587" },
            { "Dsrt", "\u5fb7\u585e\u83b1\u7279\u6587" },
            { "Dupl", "\u675c\u666e\u6d1b\u4f0a\u901f\u8bb0" },
            { "Egyd", "\u540e\u671f\u57c3\u53ca\u6587" },
            { "Egyh", "\u53e4\u57c3\u53ca\u50e7\u4fa3\u4e66\u5199\u4f53" },
            { "Egyp", "\u53e4\u57c3\u53ca\u8c61\u5f62\u6587" },
            { "Elba", "\u7231\u5c14\u5df4\u6851\u6587" },
            { "Elym", "\u57c3\u5229\u8fc8\u6587" },
            { "Ethi", "\u57c3\u585e\u4fc4\u6bd4\u4e9a\u6587" },
            { "Geok", "\u683c\u9c81\u5409\u4e9a\u6587\uff08\u6559\u5802\u4f53\uff09" },
            { "Geor", "\u683c\u9c81\u5409\u4e9a\u6587" },
            { "Glag", "\u683c\u62c9\u54e5\u91cc\u6587" },
            { "Gong", "\u8d21\u8d3e\u62c9\u8d21\u5fb7\u6587" },
            { "Gonm", "\u9a6c\u8428\u62c9\u59c6\u5188\u5fb7\u6587" },
            { "Goth", "\u54e5\u7279\u6587" },
            { "Gran", "\u683c\u5170\u5854\u6587" },
            { "Grek", "\u5e0c\u814a\u6587" },
            { "Gujr", "\u53e4\u5409\u62c9\u7279\u6587" },
            { "Guru", "\u679c\u9c81\u7a46\u5947\u6587" },
            { "Hanb", "\u6c49\u8bed\u6ce8\u97f3" },
            { "Hang", "\u8c1a\u6587" },
            { "Hani", "\u6c49\u5b57" },
            { "Hano", "\u6c49\u5974\u7f57\u6587" },
            { "Hans", "\u7b80\u4f53" },
            { "Hant", "\u7e41\u4f53" },
            { "Hatr", "\u54c8\u7279\u5170\u6587" },
            { "Hebr", "\u5e0c\u4f2f\u6765\u6587" },
            { "Hira", "\u5e73\u5047\u540d" },
            { "Hluw", "\u5b89\u90a3\u6258\u5229\u4e9a\u8c61\u5f62\u6587\u5b57" },
            { "Hmng", "\u6768\u677e\u5f55\u82d7\u6587" },
            { "Hmnp", "\u5c3c\u4e9a\u80af\u84b2\u4e18\u82d7\u6587" },
            { "Hrkt", "\u5047\u540d\u8868" },
            { "Hung", "\u53e4\u5308\u7259\u5229\u6587" },
            { "Inds", "\u5370\u5ea6\u6cb3\u6587\u5b57" },
            { "Ital", "\u53e4\u610f\u5927\u5229\u6587" },
            { "Jamo", "\u97e9\u6587\u5b57\u6bcd" },
            { "Java", "\u722a\u54c7\u6587" },
            { "Jpan", "\u65e5\u6587" },
            { "Jurc", "\u5973\u771f\u6587" },
            { "Kali", "\u514b\u8036\u674e\u6587\u5b57" },
            { "Kana", "\u7247\u5047\u540d" },
            { "Kawi", "\u5361\u7ef4\u6587" },
            { "Khar", "\u5361\u7f57\u987b\u63d0\u6587" },
            { "Khmr", "\u9ad8\u68c9\u6587" },
            { "Khoj", "\u514b\u5409\u5947\u6587\u5b57" },
            { "Kits", "\u5951\u4e39\u5c0f\u5b57" },
            { "Knda", "\u5361\u7eb3\u8fbe\u6587" },
            { "Kore", "\u97e9\u6587" },
            { "Kpel", "\u514b\u4f69\u5217\u6587" },
            { "Kthi", "\u51ef\u63d0\u6587" },
            { "Lana", "\u5170\u62ff\u6587" },
            { "Laoo", "\u8001\u631d\u6587" },
            { "Latf", "\u62c9\u4e01\u6587\uff08\u54e5\u7279\u5f0f\u5b57\u4f53\u53d8\u4f53\uff09" },
            { "Latg", "\u62c9\u4e01\u6587\uff08\u76d6\u5c14\u6587\u53d8\u4f53\uff09" },
            { "Latn", "\u62c9\u4e01\u6587" },
            { "Lepc", "\u96f7\u5e03\u67e5\u6587" },
            { "Limb", "\u6797\u5e03\u6587" },
            { "Lina", "\u7ebf\u5f62\u6587\u5b57\uff08A\uff09" },
            { "Linb", "\u7ebf\u5f62\u6587\u5b57\uff08B\uff09" },
            { "Lisu", "\u5088\u50f3\u6587" },
            { "Loma", "\u6d1b\u9a6c\u6587" },
            { "Lyci", "\u5229\u897f\u4e9a\u6587" },
            { "Lydi", "\u5415\u5e95\u4e9a\u6587" },
            { "Mahj", "\u9ed8\u54c8\u91d1\u6587" },
            { "Maka", "\u671b\u52a0\u9521\u6587" },
            { "Mand", "\u963f\u62c9\u7c73\u6587" },
            { "Mani", "\u6469\u5c3c\u6559\u6587" },
            { "Marc", "\u5927\u739b\u5c14\u6587" },
            { "Maya", "\u739b\u96c5\u5723\u7b26\u6587" },
            { "Medf", "\u6885\u5fb7\u6cd5\u4f0a\u5fb7\u6797\u6587" },
            { "Mend", "\u95e8\u8fea\u6587" },
            { "Merc", "\u9ea6\u7f57\u57c3\u8349\u4e66" },
            { "Mero", "\u9ea6\u82e5\u63d0\u514b\u6587" },
            { "Mlym", "\u9a6c\u62c9\u96c5\u62c9\u59c6\u6587" },
            { "Modi", "\u83ab\u8fea\u6587" },
            { "Mong", "\u8499\u53e4\u6587" },
            { "Moon", "\u7a46\u6069\u5b57\u6bcd" },
            { "Mroo", "\u8c2c\u6587" },
            { "Mtei", "\u66fc\u5c3c\u666e\u5c14\u6587" },
            { "Mult", "\u7a46\u5c14\u5766\u6587" },
            { "Mymr", "\u7f05\u7538\u6587" },
            { "Nand", "\u6960\u8fea\u68b5\u6587" },
            { "Narb", "\u53e4\u5317\u65b9\u963f\u62c9\u4f2f\u6587" },
            { "Nbat", "\u7eb3\u5df4\u6cf0\u6587" },
            { "Newa", "\u5c3c\u74e6\u6587" },
            { "Nkgb", "\u7eb3\u897f\u683c\u5df4\u6587" },
            { "Nkoo", "\u897f\u975e\u4e66\u9762\u6587\u5b57\uff08N\u2019Ko\uff09" },
            { "Nshu", "\u5973\u4e66" },
            { "Ogam", "\u6b27\u7518\u6587" },
            { "Olck", "\u6851\u5854\u5229\u6587" },
            { "Orkh", "\u9102\u5c14\u6d51\u6587" },
            { "Orya", "\u5965\u91cc\u4e9a\u6587" },
            { "Osge", "\u6b27\u585e\u5947\u6587" },
            { "Osma", "\u5965\u65af\u66fc\u4e9a\u6587" },
            { "Ougr", "\u56de\u9e58\u6587" },
            { "Palm", "\u5e15\u5c14\u8fc8\u62c9\u6587" },
            { "Pauc", "\u5305\u91d1\u8c6a\u6587" },
            { "Perm", "\u53e4\u5f7c\u5c14\u59c6\u6587" },
            { "Phag", "\u516b\u601d\u5df4\u6587" },
            { "Phli", "\u5df4\u5217\u7ef4\u6587\u7891\u94ed\u4f53" },
            { "Phlp", "\u5df4\u5217\u7ef4\u6587\uff08\u5723\u8bd7\u4f53\uff09" },
            { "Phlv", "\u5df4\u5217\u7ef4\u6587\uff08\u4e66\u4f53\uff09" },
            { "Phnx", "\u8153\u5c3c\u57fa\u6587" },
            { "Plrd", "\u6ce2\u62c9\u5fb7\u97f3\u6807\u6587\u5b57" },
            { "Prti", "\u5e15\u63d0\u4e9a\u6587\u7891\u94ed\u4f53" },
            { "Qaag", "\u7167\u6d4e\u6587" },
            { "Rjng", "\u62c9\u8ba9\u6587" },
            { "Rohg", "\u54c8\u4e43\u6590\u6587" },
            { "Roro", "\u6717\u683c\u6717\u683c\u6587" },
            { "Runr", "\u53e4\u4ee3\u5317\u6b27\u6587" },
            { "Samr", "\u6492\u9a6c\u5229\u4e9a\u6587" },
            { "Sara", "\u6c99\u62c9\u5824\u6587" },
            { "Sarb", "\u53e4\u5357\u963f\u62c9\u4f2f\u6587" },
            { "Saur", "\u7d22\u62c9\u4ec0\u7279\u62c9\u6587" },
            { "Sgnw", "\u4e66\u5199\u7b26\u53f7" },
            { "Shaw", "\u8427\u4f2f\u7eb3\u5f0f\u6587" },
            { "Shrd", "\u590f\u62c9\u8fbe\u6587" },
            { "Sidd", "\u6089\u6619\u6587" },
            { "Sind", "\u4fe1\u5fb7\u6587" },
            { "Sinh", "\u50e7\u4f3d\u7f57\u6587" },
            { "Sogd", "\u7c9f\u7279\u6587" },
            { "Sogo", "\u53e4\u7c9f\u7279\u6587" },
            { "Sora", "\u7d22\u6717\u6851\u670b\u6587" },
            { "Soyo", "\u7d22\u6c38\u5e03\u6587" },
            { "Sund", "\u5dfd\u4ed6\u6587" },
            { "Sylo", "\u9521\u5c14\u8d6b\u7279\u6587" },
            { "Syrc", "\u53d9\u5229\u4e9a\u6587" },
            { "Syre", "\u798f\u97f3\u4f53\u53d9\u5229\u4e9a\u6587" },
            { "Syrj", "\u897f\u53d9\u5229\u4e9a\u6587" },
            { "Syrn", "\u4e1c\u53d9\u5229\u4e9a\u6587" },
            { "Tagb", "\u5854\u683c\u73ed\u74e6\u6587" },
            { "Takr", "\u6cf0\u514b\u91cc\u6587" },
            { "Tale", "\u6cf0\u4e50\u6587" },
            { "Talu", "\u65b0\u50a3\u6587" },
            { "Taml", "\u6cf0\u7c73\u5c14\u6587" },
            { "Tang", "\u5510\u53e4\u7279\u6587" },
            { "Tavt", "\u8d8a\u5357\u50a3\u6587" },
            { "Telu", "\u6cf0\u5362\u56fa\u6587" },
            { "Teng", "\u817e\u683c\u74e6\u6587\u5b57" },
            { "Tfng", "\u63d0\u975e\u7eb3\u6587" },
            { "Tglg", "\u5854\u52a0\u8def\u6587" },
            { "Thaa", "\u5854\u5b89\u90a3\u6587" },
            { "Thai", "\u6cf0\u6587" },
            { "Tibt", "\u85cf\u6587" },
            { "Tirh", "\u8fc8\u8482\u5229\u6587" },
            { "Tnsa", "\u5766\u8428\u6587" },
            { "Toto", "\u6295\u6295\u6587" },
            { "Ugar", "\u4e4c\u52a0\u91cc\u7279\u6587" },
            { "Vaii", "\u74e6\u4f9d\u6587" },
            { "Visp", "\u53ef\u89c1\u8bed\u8a00" },
            { "Wara", "\u74e6\u90ce\u5947\u8482\u6587\u5b57" },
            { "Wcho", "\u4e07\u79cb\u6587" },
            { "Wole", "\u6c83\u83b1\u827e\u6587" },
            { "Xpeo", "\u53e4\u6ce2\u65af\u6587" },
            { "Xsux", "\u82cf\u7f8e\u5c14-\u963f\u5361\u5fb7\u6954\u5f62\u6587\u5b57" },
            { "Yezi", "\u96c5\u5179\u8fea\u6587" },
            { "Yiii", "\u5f5d\u6587" },
            { "Zanb", "\u672d\u90a3\u5df4\u672d\u5c14\u65b9\u5757\u6587\u5b57" },
            { "Zinh", "\u9057\u4f20\u5b66\u672f\u8bed" },
            { "Zmth", "\u6570\u5b66\u7b26\u53f7" },
            { "Zsye", "\u8868\u60c5\u7b26\u53f7" },
            { "Zsym", "\u7b26\u53f7" },
            { "Zxxx", "\u975e\u4e66\u9762\u6587\u5b57" },
            { "Zyyy", "\u901a\u7528" },
            { "Zzzz", "\u672a\u77e5\u6587\u5b57" },
            { "de_AT", "\u5965\u5730\u5229\u5fb7\u8bed" },
            { "de_CH", "\u745e\u58eb\u9ad8\u5730\u5fb7\u8bed" },
            { "en_AU", "\u6fb3\u5927\u5229\u4e9a\u82f1\u8bed" },
            { "en_CA", "\u52a0\u62ff\u5927\u82f1\u8bed" },
            { "en_GB", "\u82f1\u56fd\u82f1\u8bed" },
            { "en_US", "\u7f8e\u56fd\u82f1\u8bed" },
            { "es_ES", "\u6b27\u6d32\u897f\u73ed\u7259\u8bed" },
            { "es_MX", "\u58a8\u897f\u54e5\u897f\u73ed\u7259\u8bed" },
            { "fa_AF", "\u8fbe\u91cc\u8bed" },
            { "fr_CA", "\u52a0\u62ff\u5927\u6cd5\u8bed" },
            { "fr_CH", "\u745e\u58eb\u6cd5\u8bed" },
            { "nl_BE", "\u5f17\u62c9\u8292\u8bed" },
            { "pt_BR", "\u5df4\u897f\u8461\u8404\u7259\u8bed" },
            { "pt_PT", "\u6b27\u6d32\u8461\u8404\u7259\u8bed" },
            { "ro_MD", "\u6469\u5c14\u591a\u74e6\u8bed" },
            { "sw_CD", "\u521a\u679c\u65af\u74e6\u5e0c\u91cc\u8bed" },
            { "%%1901", "\u4f20\u7edf\u5fb7\u6587\u62fc\u5b57" },
            { "%%1994", "\u6807\u51c6\u96f7\u897f\u4e9a\u62fc\u5b57" },
            { "%%1996", "1996 \u5e74\u5fb7\u6587\u62fc\u5b57" },
            { "ar_001", "\u73b0\u4ee3\u6807\u51c6\u963f\u62c9\u4f2f\u8bed" },
            { "es_419", "\u62c9\u4e01\u7f8e\u6d32\u897f\u73ed\u7259\u8bed" },
            { "key.ca", "\u65e5\u5386" },
            { "key.cf", "\u8d27\u5e01\u683c\u5f0f" },
            { "key.co", "\u6392\u5e8f" },
            { "key.cu", "\u8d27\u5e01" },
            { "key.hc", "\u5c0f\u65f6\u5236\uff0812\u621624\uff09" },
            { "key.lb", "\u6362\u884c\u7b26\u6837\u5f0f" },
            { "key.ms", "\u5ea6\u91cf\u8861\u5236" },
            { "key.nu", metaValue_key_nu },
            { "key.tz", "\u65f6\u533a" },
            { "key.va", "\u8bed\u8a00\u533a\u57df\u522b\u540d" },
            { "nds_NL", "\u4f4e\u8428\u514b\u68ee\u8bed" },
            { "%%ALUKU", "\u963f\u9c81\u5e93\u65b9\u8a00" },
            { "%%BARLA", "\u4f5b\u5f97\u89d2\u8bed\u5411\u98ce\u65b9\u8a00\u7ec4" },
            { "%%BISKE", "\u5723\u4e54\u6cbb/\u6bd4\u62c9\u65b9\u8a00" },
            { "%%BOONT", "\u5e03\u6069\u7279\u6797\u65b9\u8a00" },
            { "%%CORNU", "\u79d1\u5c14\u5c3c\u65b9\u8a00" },
            { "%%GALLO", "\u52a0\u6d1b\u65b9\u8a00" },
            { "%%JAUER", "\u7c73\u65bd\u6cf0\u5c14\u65b9\u8a00" },
            { "%%KKCOR", "\u5e38\u7528\u62fc\u5b57" },
            { "%%KSCOR", "\u6807\u51c6\u6b63\u5199\u6cd5" },
            { "%%LIPAW", "\u96f7\u897f\u4e9a Lipovaz \u65b9\u8a00" },
            { "%%NEDIS", "\u7eb3\u8482\u7d22\u5185\u65b9\u8a00" },
            { "%%NJIVA", "Gniva/Njiva \u65b9\u8a00" },
            { "%%NULIK", "\u73b0\u4ee3\u6c83\u62c9\u666e\u514b\u8bed" },
            { "%%OSOJS", "Oseacco/Osojane \u65b9\u8a00" },
            { "%%PEANO", "\u76ae\u4e9a\u8bfa\u65b9\u8a00" },
            { "%%POSIX", "\u7535\u8111" },
            { "%%PUTER", "\u745e\u58eb\u666e\u7279\u5c14\u65b9\u8a00" },
            { "%%RIGIK", "\u53e4\u5178\u6c83\u62c9\u666e\u514b\u8bed" },
            { "%%ROZAJ", "\u96f7\u897f\u4e9a\u6587" },
            { "%%RUMGR", "\u7f57\u66fc\u4ec0\u6587" },
            { "%%SAAHO", "\u8428\u970d\u6587" },
            { "%%SOLBA", "Stolvizza/Solbica \u65b9\u8a00" },
            { "%%SOTAV", "\u4f5b\u5f97\u89d2\u8bed\u80cc\u98ce\u65b9\u8a00\u7ec4" },
            { "%%UCCOR", "\u7edf\u4e00\u7684\u62fc\u5b57" },
            { "az_Arab", "\u5357\u963f\u585e\u62dc\u7586\u8bed" },
            { "zh_Hans", "\u7b80\u4f53\u4e2d\u6587" },
            { "zh_Hant", "\u7e41\u4f53\u4e2d\u6587" },
            { "%%AO1990", "1990\u5e74\u8461\u8404\u7259\u8bed\u6b63\u5199\u6cd5\u534f\u8bae" },
            { "%%ARANES", "\u963f\u5170\u65b9\u8a00" },
            { "%%ASANTE", "\u963f\u6563\u8482\u65b9\u8a00" },
            { "%%AUVERN", "\u81ea\u52a8\u94bb\u673a" },
            { "%%CISAUP", "\u897f\u8428\u666e\u65b9\u8a00" },
            { "%%CREISS", "\u514b\u96f7\u6851\u65b9\u8a00" },
            { "%%DAJNKO", "\u8fbe\u91d1\u79d1\u5b57\u6bcd" },
            { "%%EKAVSK", "\u585e\u5c14\u7ef4\u4e9a\u8bed\u4f0a\u5361\u7ef4\u4e9a\u53d1\u97f3" },
            { "%%FONIPA", "\u56fd\u9645\u97f3\u6807" },
            { "%%FONUPA", "UPA \u97f3\u6807" },
            { "%%GASCON", "\u52a0\u65af\u79d1\u65b9\u8a00" },
            { "%%GRITAL", "\u683c\u91cc\u9676\u65b9\u8a00" },
            { "%%NDYUKA", "Ndyuka \u65b9\u8a00" },
            { "%%NICARD", "\u5c3c\u65af\u65b9\u8a00" },
            { "%%PAMAKA", "Pamaka \u65b9\u8a00" },
            { "%%PINYIN", "\u62fc\u97f3\u7f57\u9a6c\u5b57" },
            { "%%SCOUSE", "\u65af\u9ad8\u65af\u65b9\u8a00" },
            { "%%SIMPLE", "\u7b80\u5355\u82f1\u8bed" },
            { "%%TARASK", "\u4f20\u7edf\u6b63\u5199\u6cd5" },
            { "%%UCRCOR", "\u7edf\u4e00\u548c\u4fee\u8ba2\u7684\u62fc\u5b57" },
            { "%%ULSTER", "\u963f\u5c14\u65af\u7279\u65b9\u8a00" },
            { "%%UNIFON", "Unifon\u97f3\u4f4d\u5b57\u6bcd" },
            { "%%ABL1943", "1943\u5e74\u6b63\u5199\u6cd5\u6784\u60f3" },
            { "%%AKUAPEM", "\u963f\u5938\u4f69\u59c6\u65b9\u8a00" },
            { "%%ALALC97", "1997 \u7248 ALA-LC \u7f57\u9a6c\u5b57" },
            { "%%AREVELA", "\u4e1c\u4e9a\u7f8e\u5c3c\u4e9a\u6587" },
            { "%%AREVMDA", "\u897f\u4e9a\u7f8e\u5c3c\u4e9a\u6587" },
            { "%%ARKAIKA", "\u963f\u5c14\u51ef\u4e9a\u65b9\u8a00" },
            { "%%BALANKA", "\u963f\u5c3c\u8bedBalanka\u65b9\u8a00" },
            { "%%BAUDDHA", "\u4f5b\u9640\u68b5\u6587" },
            { "%%BOHORIC", "\u535a\u970d\u91cc\u5947\u5b57\u6bcd" },
            { "%%EMODENG", "\u8fd1\u4ee3\u82f1\u8bed" },
            { "%%FONNAPA", "\u798f\u7eb3\u5e15\u65b9\u8a00" },
            { "%%GRCLASS", "\u7c97\u7c92\u7ea7" },
            { "%%GRMISTR", "\u683c\u7c73\u65af\u7279\u65b9\u8a00" },
            { "%%HEPBURN", "\u8d6b\u4f2f\u6069\u7f57\u9a6c\u5b57" },
            { "%%ITIHASA", "\u53f2\u8bd7\u68b5\u6587" },
            { "%%LAUKIKA", "\u4f20\u7edf\u68b5\u6587" },
            { "%%LEMOSIN", "\u5229\u59c6\u8d5e\u65b9\u8a00" },
            { "%%METELKO", "\u6885\u7279\u5c14\u79d1\u5b57\u6bcd" },
            { "%%MONOTON", "\u5355\u97f3\u5b57\u6bcd" },
            { "%%PAHAWH2", "\u5e15\u54c8\u82d7\u65872\u4ee3" },
            { "%%PAHAWH3", "\u5e15\u54c8\u82d7\u65873\u4ee3" },
            { "%%PAHAWH4", "\u5e15\u54c8\u82d7\u65874\u4ee3" },
            { "%%POLYTON", "\u591a\u97f3\u5b57\u6bcd" },
            { "%%PROVENC", "\u666e\u7f57\u65fa\u65af\u65b9\u8a00" },
            { "%%REVISED", "\u4fee\u8ba2\u7684\u62fc\u5b57" },
            { "%%SURSILV", "\u745e\u58eb\u82cf\u745f\u74e6\u65b9\u8a00" },
            { "%%SUTSILV", "\u745e\u58eb\u82cf\u5e0c\u74e6\u65b9\u8a00" },
            { "%%VAIDIKA", "\u5420\u9640\u68b5\u6587" },
            { "%%1606NICT", "1606 \u5e74\u524d\u4e2d\u540e\u671f\u6cd5\u6587" },
            { "%%1694ACAD", "\u65e9\u671f\u73b0\u4ee3\u6cd5\u6587" },
            { "%%1959ACAD", "\u5b66\u672f" },
            { "%%BAKU1926", "\u7edf\u4e00\u571f\u8033\u5176\u62c9\u4e01\u5b57\u6bcd" },
            { "%%BASICENG", "\u57fa\u672c\u82f1\u8bed" },
            { "%%BISCAYAN", "\u6bd4\u65af\u5f00\u65b9\u8a00" },
            { "%%BORNHOLM", "\u535a\u6069\u970d\u5c14\u59c6\u65b9\u8a00" },
            { "%%COLB1945", "1945\u5e74\u8461\u8404\u7259-\u5df4\u897f\u6b63\u5199\u6cd5\u534f\u5b9a" },
            { "%%FONKIRSH", "\u4e30\u5409\u4ec0\u65b9\u8a00" },
            { "%%FONXSAMP", "X-SAMPA \u97f3\u6807" },
            { "%%HOGNORSK", "\u9ad8\u5730\u632a\u5a01\u6587" },
            { "%%HSISTEMO", "\u8d6b\u897f\u65af\u7279\u83ab\u65b9\u8a00" },
            { "%%IJEKAVSK", "\u585e\u5c14\u7ef4\u4e9a\u8bed\u4f0a\u5409\u5361\u7ef4\u4e9a\u53d1\u97f3" },
            { "%%IVANCHOV", "\u4f0a\u4e07\u4e54\u592b\u65b9\u8a00" },
            { "%%JYUTPING", "\u7ca4\u8bed\u62fc\u97f3" },
            { "%%KOCIEWIE", "\u79d1\u5947\u97e6\u65b9\u8a00" },
            { "%%LENGADOC", "\u9686\u683c\u591a\u514b\u65b9\u8a00" },
            { "%%LUNA1918", "\u4fc4\u6587\u62fc\u5b57\uff081918\u5e74\u8d77\uff09" },
            { "%%NEWFOUND", "\u7ebd\u82ac\u5170\u65b9\u8a00" },
            { "%%OXENDICT", "\u300a\u725b\u6d25\u82f1\u8bed\u8bcd\u5178\u300b\u62fc\u6cd5" },
            { "%%PETR1708", "\u4fc4\u6587\u62fc\u5b57\uff081708\u5e74\uff09" },
            { "%%SCOTLAND", "\u82cf\u683c\u5170\u6807\u51c6\u82f1\u6587" },
            { "%%SPANGLIS", "\u897f\u73ed\u7259\u5f0f\u82f1\u8bed" },
            { "%%SURMIRAN", "\u745e\u58eb\u82cf\u8fc8\u62c9\u65b9\u8a00" },
            { "%%TONGYONG", "\u901a\u7528\u62fc\u97f3" },
            { "%%VALENCIA", "\u5df4\u4f26\u897f\u4e9a\u6587" },
            { "%%VALLADER", "\u745e\u58eb\u74e6\u52d2\u5fb7\u65b9\u8a00" },
            { "%%VECDRUKA", "\u7ef4\u675c\u5361\u65b9\u8a00" },
            { "%%VIVARAUP", "\u7ef4\u74e6\u9c81\u666e\u65b9\u8a00" },
            { "%%WADEGILE", "WG \u5a01\u6c0f\u62fc\u97f3\u6cd5" },
            { "%%XSISTEMO", "\u897f\u897f\u65af\u7279\u83ab\u65b9\u8a00" },
            { "type.ca.roc", "\u6c11\u56fd\u7eaa\u5e74" },
            { "type.co.eor", "\u6b27\u6d32\u6392\u5e8f\u89c4\u5219" },
            { "type.hc.h11", "12\u5c0f\u65f6\u5236\uff080\u201311\uff09" },
            { "type.hc.h12", "12\u5c0f\u65f6\u5236\uff081\u201312\uff09" },
            { "type.hc.h23", "24\u5c0f\u65f6\u5236\uff080\u201323\uff09" },
            { "type.hc.h24", "24\u5c0f\u65f6\u5236\uff081\u201324\uff09" },
            { "type.m0.bgn", "\u7f8e\u56fd\u5730\u540d\u59d4\u5458\u4f1a (BGN)" },
            { "type.nu.ahom", "\u963f\u970d\u59c6\u6570\u5b57" },
            { "type.nu.arab", "\u963f\u62c9\u4f2f-\u5370\u5ea6\u6570\u5b57" },
            { "type.nu.armn", "\u4e9a\u7f8e\u5c3c\u4e9a\u6570\u5b57" },
            { "type.nu.bali", "\u5df4\u5398\u6587\u6570\u5b57" },
            { "type.nu.beng", "\u5b5f\u52a0\u62c9\u6570\u5b57" },
            { "type.nu.brah", "\u5a46\u7f57\u7c73\u6570\u5b57" },
            { "type.nu.cakm", "\u67e5\u514b\u739b\u6570\u5b57" },
            { "type.nu.cham", "\u5360\u6587\u6570\u5b57" },
            { "type.nu.cyrl", "\u65af\u62c9\u592b\u6570\u5b57" },
            { "type.nu.deva", "\u68b5\u6587\u6570\u5b57" },
            { "type.nu.diak", "\u8fea\u7ef4\u897f\u963f\u5e93\u9c81\u6570\u5b57" },
            { "type.nu.ethi", "\u57c3\u585e\u4fc4\u6bd4\u4e9a\u6570\u5b57" },
            { "type.nu.geor", "\u683c\u9c81\u5409\u4e9a\u6570\u5b57" },
            { "type.nu.gong", metaValue_type_nu_gong },
            { "type.nu.gonm", metaValue_type_nu_gong },
            { "type.nu.grek", "\u5e0c\u814a\u6570\u5b57" },
            { "type.nu.gujr", "\u53e4\u5409\u62c9\u7279\u6570\u5b57" },
            { "type.nu.guru", "\u679c\u9c81\u7a46\u5947\u6570\u5b57" },
            { "type.nu.hans", "\u7b80\u4f53\u4e2d\u6587\u6570\u5b57" },
            { "type.nu.hant", "\u7e41\u4f53\u4e2d\u6587\u6570\u5b57" },
            { "type.nu.hebr", "\u5e0c\u4f2f\u6765\u6570\u5b57" },
            { "type.nu.hmng", "\u6768\u677e\u5f55\u82d7\u6587\u6570\u5b57" },
            { "type.nu.hmnp", "\u5c3c\u4e9a\u80af\u84b2\u4e18\u82d7\u6587\u6570\u5b57" },
            { "type.nu.java", "\u722a\u54c7\u6587\u6570\u5b57" },
            { "type.nu.jpan", "\u65e5\u6587\u6570\u5b57" },
            { "type.nu.kali", "\u514b\u8036\u5b57\u6bcd\u6570\u5b57" },
            { "type.nu.kawi", "\u5361\u7ef4\u6570\u5b57" },
            { "type.nu.khmr", "\u9ad8\u68c9\u6570\u5b57" },
            { "type.nu.knda", "\u5361\u7eb3\u8fbe\u6570\u5b57" },
            { "type.nu.lana", "\u8001\u50a3\u6587\u6570\u5b57" },
            { "type.nu.laoo", "\u8001\u631d\u6570\u5b57" },
            { "type.nu.latn", "\u897f\u65b9\u6570\u5b57" },
            { "type.nu.lepc", "\u96f7\u5e03\u67e5\u6587\u6570\u5b57" },
            { "type.nu.limb", "\u6797\u5e03\u6587\u6570\u5b57" },
            { "type.nu.mlym", "\u9a6c\u62c9\u96c5\u62c9\u59c6\u6570\u5b57" },
            { "type.nu.modi", "\u83ab\u8fea\u6570\u5b57" },
            { "type.nu.mong", "\u8499\u53e4\u6587\u6570\u5b57" },
            { "type.nu.mroo", "\u8c2c\u6587\u6570\u5b57" },
            { "type.nu.mtei", "\u66fc\u5c3c\u666e\u5c14\u6570\u5b57" },
            { "type.nu.mymr", "\u7f05\u7538\u6570\u5b57" },
            { "type.nu.nkoo", "\u66fc\u5fb7\u6570\u5b57" },
            { "type.nu.olck", "\u6851\u5854\u5229\u6587\u6570\u5b57" },
            { "type.nu.orya", "\u5965\u91cc\u4e9a\u6570\u5b57" },
            { "type.nu.osma", "\u5965\u65af\u66fc\u6570\u5b57" },
            { "type.nu.rohg", "\u54c8\u4e43\u6590\u7f57\u5174\u4e9a\u6570\u5b57" },
            { "type.nu.saur", "\u7d22\u62c9\u4ec0\u7279\u62c9\u6587\u6570\u5b57" },
            { "type.nu.shrd", "\u590f\u62c9\u8fbe\u6570\u5b57" },
            { "type.nu.sind", "\u5e93\u8fbe\u74e6\u8fea\u6570\u5b57" },
            { "type.nu.sinh", "\u50e7\u4f3d\u7f57\u6587\u6570\u5b57" },
            { "type.nu.sora", "\u7d20\u62c9\u50e7\u5e73\u6570\u5b57" },
            { "type.nu.sund", "\u82cf\u4e39\u6587\u6570\u5b57" },
            { "type.nu.takr", "\u6cf0\u514b\u91cc\u6570\u5b57" },
            { "type.nu.talu", "\u65b0\u50a3\u4ec2\u6587\u6570\u5b57" },
            { "type.nu.taml", "\u4f20\u7edf\u6cf0\u7c73\u5c14\u6570\u5b57" },
            { "type.nu.telu", "\u6cf0\u5362\u56fa\u6570\u5b57" },
            { "type.nu.thai", "\u6cf0\u6587\u6570\u5b57" },
            { "type.nu.tibt", "\u85cf\u6587\u6570\u5b57" },
            { "type.nu.tirh", "\u8fc8\u8482\u5229\u6570\u5b57" },
            { "type.nu.tnsa", "\u5766\u8428\u6570\u5b57" },
            { "type.nu.vaii", "\u74e6\u4f0a\u6587\u6570\u5b57" },
            { "type.nu.wara", "\u74e6\u90ce\u5947\u8482\u6570\u5b57" },
            { "type.nu.wcho", "\u4e07\u79cb\u6570\u5b57" },
            { "type.ca.dangi", "\u6a80\u7eaa\u5386" },
            { "type.co.ducet", "\u9ed8\u8ba4 Unicode \u6392\u5e8f" },
            { "type.co.emoji", "\u8868\u60c5\u7b26\u53f7\u6392\u5e8f" },
            { "type.lb.loose", "\u5bbd\u677e\u6362\u884c\u7b26\u6837\u5f0f" },
            { "type.nu.roman", "\u7f57\u9a6c\u6570\u5b57" },
            { "type.ca.coptic", "\u79d1\u666e\u7279\u5386" },
            { "type.ca.hebrew", "\u5e0c\u4f2f\u6765\u5386" },
            { "type.ca.indian", "\u5370\u5ea6\u56fd\u5b9a\u5386" },
            { "type.co.compat", "\u57fa\u4e8e\u517c\u5bb9\u6027\u6cbf\u7528\u65e2\u5f80\u6392\u5e8f" },
            { "type.co.pinyin", "\u62fc\u97f3\u6392\u5e8f" },
            { "type.co.search", "\u5e38\u89c4\u641c\u7d22" },
            { "type.co.stroke", "\u7b14\u753b\u6392\u5e8f" },
            { "type.co.unihan", "\u90e8\u9996\u7b14\u753b\u6392\u5e8f" },
            { "type.co.zhuyin", "\u6ce8\u97f3\u6392\u5e8f" },
            { "type.d0.fwidth", "\u5168\u89d2" },
            { "type.d0.hwidth", "\u534a\u89d2" },
            { "type.lb.normal", "\u6b63\u5e38\u6362\u884c\u7b26\u6837\u5f0f" },
            { "type.lb.strict", "\u4e25\u683c\u6362\u884c\u7b26\u6837\u5f0f" },
            { "type.m0.ungegn", "\u8054\u5408\u56fd\u5730\u540d\u4e13\u5bb6\u7ec4 (UNGEGN)" },
            { "type.ms.metric", "\u516c\u5236" },
            { "type.nu.native", "\u5f53\u5730\u6570\u5b57" },
            { "type.ca.chinese", "\u519c\u5386" },
            { "type.ca.islamic", "\u4f0a\u65af\u5170\u5386" },
            { "type.ca.iso8601", "\u56fd\u9645\u6807\u51c6\u5386\u6cd5" },
            { "type.ca.persian", "\u6ce2\u65af\u5386" },
            { "type.cf.account", "\u4f1a\u8ba1\u8d27\u5e01\u683c\u5f0f" },
            { "type.co.big5han", "\u7e41\u4f53\u4e2d\u6587\u6392\u5e8f - Big5" },
            { "type.d0.npinyin", metaValue_key_nu },
            { "type.nu.arabext", "\u6269\u5c55\u963f\u62c9\u4f2f-\u5370\u5ea6\u6570\u5b57" },
            { "type.nu.armnlow", "\u4e9a\u7f8e\u5c3c\u4e9a\u5c0f\u5199\u6570\u5b57" },
            { "type.nu.finance", "\u91d1\u878d\u6570\u5b57" },
            { "type.nu.greklow", "\u5e0c\u814a\u5c0f\u5199\u6570\u5b57" },
            { "type.nu.hanidec", "\u4e2d\u6587\u5341\u8fdb\u5236\u6570\u5b57" },
            { "type.nu.hansfin", "\u7b80\u4f53\u4e2d\u6587\u5927\u5199\u6570\u5b57" },
            { "type.nu.hantfin", "\u7e41\u4f53\u4e2d\u6587\u5927\u5199\u6570\u5b57" },
            { "type.nu.jpanfin", "\u65e5\u6587\u5927\u5199\u6570\u5b57" },
            { "type.nu.mathdbl", "\u6570\u5b66\u7a7a\u5fc3\u6570\u5b57" },
            { "type.nu.tamldec", "\u6cf0\u7c73\u5c14\u6570\u5b57" },
            { "type.ca.buddhist", "\u4f5b\u5386" },
            { "type.ca.ethiopic", "\u57c3\u585e\u4fc4\u6bd4\u4e9a\u5386" },
            { "type.ca.japanese", "\u548c\u5386" },
            { "type.cf.standard", "\u6807\u51c6\u8d27\u5e01\u683c\u5f0f" },
            { "type.co.phonetic", "\u8bed\u97f3\u6392\u5e8f" },
            { "type.co.reformed", "\u6539\u826f\u6392\u5e8f" },
            { "type.co.searchjl", "\u6309\u97e9\u6587\u5b57\u5f00\u9996\u8f85\u97f3\u6765\u641c\u7d22" },
            { "type.co.standard", "\u6807\u51c6\u6392\u5e8f" },
            { "type.ms.uksystem", "\u82f1\u5236" },
            { "type.ms.ussystem", "\u7f8e\u5236" },
            { "type.nu.fullwide", "\u5168\u89d2\u6570\u5b57" },
            { "type.nu.lanatham", "\u5170\u7eb3\u6587\u6570\u5b57" },
            { "type.nu.mathbold", "\u6570\u5b66\u7c97\u4f53\u6570\u5b57" },
            { "type.nu.mathmono", "\u6570\u5b66\u7b49\u5bbd\u6570\u5b57" },
            { "type.nu.mathsanb", "\u6570\u5b66\u65e0\u886c\u7ebf\u7c97\u4f53\u6570\u5b57" },
            { "type.nu.mathsans", "\u6570\u5b66\u65e0\u886c\u7ebf\u6570\u5b57" },
            { "type.nu.mymrshan", "\u7f05\u7538\u63b8\u6587\u6570\u5b57" },
            { "type.nu.mymrtlng", "\u7f05\u7538\u6cf0\u5170\u6570\u5b57" },
            { "type.nu.romanlow", "\u7f57\u9a6c\u5c0f\u5199\u6570\u5b57" },
            { "type.ca.gregorian", "\u516c\u5386" },
            { "type.co.gb2312han", "\u7b80\u4f53\u4e2d\u6587\u6392\u5e8f - GB2312" },
            { "type.co.phonebook", "\u7535\u8bdd\u7c3f\u6392\u5e8f" },
            { "ListKeyTypePattern", "{0}\uff1a{1}" },
            { "type.co.dictionary", "\u5b57\u5178\u6392\u5e8f" },
            { "type.co.traditional", "\u4f20\u7edf\u6392\u5e8f" },
            { "type.nu.traditional", "\u4f20\u7edf\u6570\u5b57" },
            { "type.ca.islamic-rgsa", "\u6c99\u7279\u963f\u62c9\u4f2f\u4f0a\u65af\u5170\u5386" },
            { "type.ca.islamic-tbla", "\u4f0a\u65af\u5170\u5929\u6587\u5386" },
            { "type.ca.islamic-civil", "\u4f0a\u65af\u5170\u5e0c\u5409\u6765\u65e5\u5386" },
            { "ListCompositionPattern", "{0}\uff0c{1}" },
            { "type.ca.islamic-umalqura", "\u4f0a\u65af\u5170\u5386\uff08\u4e4c\u59c6\u5e93\u62c9\uff09" },
            { "type.ca.ethiopic-amete-alem", "\u57c3\u585e\u4fc4\u6bd4\u4e9a\u963f\u7c73\u7279\u963f\u83b1\u59c6\u65e5\u5386" },
        };
        return data;
    }
}
