/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.dto.LoadedModulesDTO;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.util.List;
import org.opensearch.core.xcontent.ToXContent;

public class ServerLoadedModulesWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "ServerLoadedModules:::";
    private final LoadedModulesDTO serverLoadedModules;

    public ServerLoadedModulesWebsocketMessage(LoadedModulesDTO serverLoadedModules) {
        this.serverLoadedModules = serverLoadedModules;
    }

    private String asJsonString() throws IOException {
        return JsonUtil.asJsonString((ToXContent)this.serverLoadedModules);
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static ServerLoadedModulesWebsocketMessage createFromMessage(String websocketMessage) throws WebsocketMessageException {
        try {
            String loadedModulesJsonString = websocketMessage.substring(PREFIX.length());
            List loadedModulesAsList = JsonUtil.asListOfMaps((String)loadedModulesJsonString);
            LoadedModulesDTO serverLoadedModules = new LoadedModulesDTO(loadedModulesAsList);
            return new ServerLoadedModulesWebsocketMessage(serverLoadedModules);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the '" + ServerLoadedModulesWebsocketMessage.class.getName() + "' instance for the given websocket message: " + websocketMessage, ex);
        }
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        try {
            return PREFIX + this.asJsonString();
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the websocket message to be send.", ex);
        }
    }

    public LoadedModulesDTO getServerLoadedModules() {
        return this.serverLoadedModules;
    }

    public String toString() {
        return "ServerLoadedModulesWebsocketMessage{serverLoadedModules=" + String.valueOf(this.serverLoadedModules) + "}";
    }
}

