/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.transport.action.changesfilter.remove;

import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterRemoveActionDTO;
import java.io.IOException;
import java.util.List;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class ChangesFilterRemoveRequest
extends BaseNodesRequest<ChangesFilterRemoveRequest> {
    private final String initiatedOnNode;
    private final ChangesFilterRemoveActionDTO removeFilterAction;

    public ChangesFilterRemoveRequest(String initiatedOnNode, List<DiscoveryNode> nodeRecipients, ChangesFilterRemoveActionDTO removeFilterAction) {
        super(nodeRecipients.toArray(new DiscoveryNode[0]));
        this.initiatedOnNode = initiatedOnNode;
        this.removeFilterAction = removeFilterAction;
    }

    public ChangesFilterRemoveRequest(StreamInput in) throws IOException {
        super(in);
        this.initiatedOnNode = in.readString();
        this.removeFilterAction = (ChangesFilterRemoveActionDTO)in.readOptionalWriteable(ChangesFilterRemoveActionDTO::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.initiatedOnNode);
        out.writeOptionalWriteable((Writeable)this.removeFilterAction);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.initiatedOnNode == null) {
            validationException = ValidateActions.addValidationError((String)"no 'initiatedOnNode' specified", validationException);
        }
        if (this.removeFilterAction == null) {
            validationException = ValidateActions.addValidationError((String)"no 'removeFilterAction' specified", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getInitiatedOnNode() {
        return this.initiatedOnNode;
    }

    public ChangesFilterRemoveActionDTO getRemoveFilterAction() {
        return this.removeFilterAction;
    }
}

