/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.directory;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.remote.RemoteStoreEnums;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.opensearch.index.snapshots.blobstore.IndexShardSnapshot;
import org.opensearch.index.store.remote.directory.RemoteSnapshotDirectory;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.index.store.remote.utils.TransferManager;
import org.opensearch.plugins.IndexStorePlugin;
import org.opensearch.repositories.IndexId;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.snapshots.SnapshotId;
import org.opensearch.threadpool.ThreadPool;

public final class RemoteSnapshotDirectoryFactory
implements IndexStorePlugin.DirectoryFactory {
    public static final String LOCAL_STORE_LOCATION = "RemoteLocalStore";
    private final Supplier<RepositoriesService> repositoriesService;
    private final ThreadPool threadPool;
    private final FileCache remoteStoreFileCache;

    public RemoteSnapshotDirectoryFactory(Supplier<RepositoriesService> repositoriesService, ThreadPool threadPool, FileCache remoteStoreFileCache) {
        this.repositoriesService = repositoriesService;
        this.threadPool = threadPool;
        this.remoteStoreFileCache = remoteStoreFileCache;
    }

    @Override
    public Directory newDirectory(IndexSettings indexSettings, ShardPath localShardPath) throws IOException {
        String repositoryName = IndexSettings.SEARCHABLE_SNAPSHOT_REPOSITORY.get(indexSettings.getSettings());
        Repository repository = this.repositoriesService.get().repository(repositoryName);
        assert (repository instanceof BlobStoreRepository) : "repository should be instance of BlobStoreRepository";
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        try {
            return this.createRemoteSnapshotDirectoryFromSnapshot(indexSettings, localShardPath, blobStoreRepository).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    private Future<RemoteSnapshotDirectory> createRemoteSnapshotDirectoryFromSnapshot(IndexSettings indexSettings, ShardPath localShardPath, BlobStoreRepository blobStoreRepository) throws IOException {
        String indexId = IndexSettings.SEARCHABLE_SNAPSHOT_INDEX_ID.get(indexSettings.getSettings());
        RemoteStoreEnums.PathType pathType = IndexSettings.SEARCHABLE_SNAPSHOT_SHARD_PATH_TYPE.get(indexSettings.getSettings());
        int shardId = localShardPath.getShardId().getId();
        SnapshotId snapshotId = new SnapshotId(IndexSettings.SEARCHABLE_SNAPSHOT_ID_NAME.get(indexSettings.getSettings()), IndexSettings.SEARCHABLE_SNAPSHOT_ID_UUID.get(indexSettings.getSettings()));
        Path localStorePath = localShardPath.getDataPath().resolve(LOCAL_STORE_LOCATION);
        FSDirectory localStoreDir = FSDirectory.open((Path)Files.createDirectories(localStorePath, new FileAttribute[0]));
        localStoreDir.syncMetaData();
        return this.threadPool.executor("snapshot").submit(() -> {
            BlobContainer blobContainer = blobStoreRepository.shardContainer(new IndexId("DUMMY", indexId, pathType.getCode()), shardId);
            IndexShardSnapshot indexShardSnapshot = blobStoreRepository.loadShardSnapshot(blobContainer, snapshotId);
            assert (indexShardSnapshot instanceof BlobStoreIndexShardSnapshot) : "indexShardSnapshot should be an instance of BlobStoreIndexShardSnapshot";
            BlobStoreIndexShardSnapshot snapshot = (BlobStoreIndexShardSnapshot)indexShardSnapshot;
            TransferManager transferManager = new TransferManager(blobContainer::readBlob, this.remoteStoreFileCache, this.threadPool);
            return new RemoteSnapshotDirectory(snapshot, localStoreDir, transferManager);
        });
    }
}

