/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.tracker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.spi.InitialContextFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTrackerCustomizers {
    public static final ServiceTrackerCustomizer LAZY = new ServiceTrackerCustomizer(){

        public Object addingService(ServiceReference reference) {
            return reference;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
        }
    };
    public static final CachingServiceTracker ICF_CACHE = new BaseCachingServiceTracker(){

        @Override
        public List<String> getProperty(ServiceReference ref) {
            String[] interfaces = (String[])ref.getProperty("objectClass");
            ArrayList<String> resultList = new ArrayList<String>();
            for (String interfaceName : interfaces) {
                if (InitialContextFactory.class.getName().equals(interfaceName)) continue;
                resultList.add(interfaceName);
            }
            return resultList;
        }
    };
    public static final CachingServiceTracker URL_FACTORY_CACHE = new BaseCachingServiceTracker(){

        @Override
        protected List<String> getProperty(ServiceReference reference) {
            List<String> result;
            Object scheme = reference.getProperty("osgi.jndi.url.scheme");
            if (scheme instanceof String) {
                result = new ArrayList<String>();
                result.add((String)scheme);
            } else {
                result = scheme instanceof String[] ? Arrays.asList((String[])scheme) : Collections.emptyList();
            }
            return result;
        }
    };

    private static abstract class BaseCachingServiceTracker
    implements CachingServiceTracker {
        protected ConcurrentMap<String, ServiceReference> cache = new ConcurrentHashMap<String, ServiceReference>();
        protected List<ServiceReference> trackedReferences = new ArrayList<ServiceReference>();

        private BaseCachingServiceTracker() {
        }

        @Override
        public ServiceReference find(String identifier) {
            return (ServiceReference)this.cache.get(identifier);
        }

        public synchronized Object addingService(ServiceReference reference) {
            List<String> cacheKeys = this.getProperty(reference);
            for (String key : cacheKeys) {
                this.cache.putIfAbsent(key, reference);
            }
            this.trackedReferences.add(reference);
            return reference;
        }

        protected abstract List<String> getProperty(ServiceReference var1);

        public synchronized void removedService(ServiceReference reference, Object service) {
            this.trackedReferences.remove(reference);
            ArrayList<String> keysToProcess = new ArrayList<String>(this.getProperty(reference));
            block0: for (ServiceReference ref : this.trackedReferences) {
                List<String> refInt = this.getProperty(ref);
                for (String interfaceName : refInt) {
                    int index = keysToProcess.indexOf(interfaceName);
                    if (index < 0) continue;
                    keysToProcess.remove(index);
                    if (!this.cache.replace(interfaceName, reference, ref) || !keysToProcess.isEmpty()) continue;
                    break block0;
                }
            }
            for (String interfaceName : keysToProcess) {
                this.cache.remove(interfaceName, reference);
            }
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }
    }

    public static interface CachingServiceTracker
    extends ServiceTrackerCustomizer {
        public ServiceReference find(String var1);
    }
}

