/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.ElementSupport;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.impl.SignatureImpl;
import org.opensaml.xmlsec.signature.support.ContentReference;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureMarshaller
implements Marshaller {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SignatureMarshaller.class);

    public SignatureMarshaller() {
        if (!Init.isInitialized()) {
            this.log.debug("Initializing XML security library");
            Init.init();
        }
    }

    @Override
    @Nonnull
    public Element marshall(@Nonnull XMLObject xmlObject) throws MarshallingException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            return this.marshall(xmlObject, document);
        }
        catch (ParserConfigurationException e) {
            throw new MarshallingException("Unable to create Document to place marshalled elements in", e);
        }
    }

    @Override
    @Nonnull
    public Element marshall(@Nonnull XMLObject xmlObject, @Nonnull Element parentElement) throws MarshallingException {
        Element signatureElement = this.createSignatureElement((SignatureImpl)xmlObject, parentElement.getOwnerDocument());
        ElementSupport.appendChildElement(parentElement, signatureElement);
        return signatureElement;
    }

    @Override
    @Nonnull
    public Element marshall(@Nonnull XMLObject xmlObject, @Nonnull Document document) throws MarshallingException {
        Element signatureElement = this.createSignatureElement((SignatureImpl)xmlObject, document);
        Element documentRoot = document.getDocumentElement();
        if (documentRoot != null) {
            document.replaceChild(signatureElement, documentRoot);
        } else {
            document.appendChild(signatureElement);
        }
        return signatureElement;
    }

    @Nonnull
    private Element createSignatureElement(@Nonnull Signature signature, @Nonnull Document document) throws MarshallingException {
        this.log.debug("Starting to marshall {}", (Object)signature.getElementQName());
        String sigAlg = signature.getSignatureAlgorithm();
        if (sigAlg == null) {
            throw new MarshallingException("No signature algorithm set");
        }
        try {
            this.log.debug("Creating XMLSignature object");
            XMLSignature dsig = null;
            Integer hmaclen = signature.getHMACOutputLength();
            dsig = hmaclen != null && AlgorithmSupport.isHMAC(sigAlg) ? new XMLSignature(document, "", sigAlg, hmaclen.intValue(), signature.getCanonicalizationAlgorithm()) : new XMLSignature(document, "", sigAlg, signature.getCanonicalizationAlgorithm());
            this.log.debug("Adding content to XMLSignature.");
            for (ContentReference contentReference : signature.getContentReferences()) {
                contentReference.createReference(dsig);
            }
            this.log.debug("Creating Signature DOM element");
            Element signatureElement = dsig.getElement();
            KeyInfo keyInfo = signature.getKeyInfo();
            if (keyInfo != null) {
                Marshaller keyInfoMarshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().ensureMarshaller(KeyInfo.DEFAULT_ELEMENT_NAME);
                keyInfoMarshaller.marshall((XMLObject)keyInfo, signatureElement);
            }
            ((SignatureImpl)signature).setXMLSignature(dsig);
            signature.setDOM(signatureElement);
            signature.releaseParentDOM(true);
            return signatureElement;
        }
        catch (XMLSecurityException e) {
            String msg = "Unable to construct signature Element " + String.valueOf(signature.getElementQName());
            this.log.error(msg + ": {}", (Object)e.getMessage());
            throw new MarshallingException(msg, (Exception)((Object)e));
        }
    }
}

