/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin.websocket.message;

import de.virtimo.bpc.opensearch.plugin.dto.TailsyncManualStartActionDTO;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import de.virtimo.bpc.opensearch.plugin.utils.TimestampUtil;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessage;
import de.virtimo.bpc.opensearch.plugin.websocket.WebsocketMessageException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;
import org.opensearch.core.xcontent.ToXContent;

public class TailsyncManualStartWebsocketMessage
implements WebsocketMessage {
    private static final String PREFIX = "ManualStartOfTailsyncMessage:::";
    private final TailsyncManualStartActionDTO manualStartAction;
    private final Instant sendedAtInUtc;

    public TailsyncManualStartWebsocketMessage(TailsyncManualStartActionDTO manualStartAction) {
        this(manualStartAction, TimestampUtil.nowInUtc());
    }

    public TailsyncManualStartWebsocketMessage(TailsyncManualStartActionDTO manualStartAction, Instant sendedAtInUtc) {
        this.manualStartAction = manualStartAction;
        this.sendedAtInUtc = sendedAtInUtc;
    }

    public TailsyncManualStartWebsocketMessage(Map<String, Object> msgMap) {
        this(new TailsyncManualStartActionDTO(MapUtil.getValueAsMap(msgMap, (String)"action", null)), MapUtil.getValueAsInstant(msgMap, (String)"sendedAt", (Instant)TimestampUtil.nowInUtc()));
        this.checkForWellKnownKeys(msgMap);
    }

    private void checkForWellKnownKeys(Map<String, Object> msgMap) {
        MapUtil.checkForWellKnownKeys(msgMap, Set.of("action", "sendedAt"));
    }

    private Map<String, Object> asMap() throws IOException {
        return MapUtil.mapOf((Object[])new Object[]{"action", JsonUtil.asMap((ToXContent)this.manualStartAction), "sendedAt", this.sendedAtInUtc});
    }

    private String asJsonString() throws IOException {
        return JsonUtil.asJsonString(this.asMap());
    }

    public static boolean canBeCreatedFromMessage(String websocketMessage) {
        return !StringUtil.isNullOrEmpty((String)websocketMessage) && websocketMessage.startsWith(PREFIX);
    }

    public static TailsyncManualStartWebsocketMessage createFromMessage(String websocketMessage) throws WebsocketMessageException {
        try {
            String jsonMsgContent = websocketMessage.substring(PREFIX.length());
            Map jsonMap = JsonUtil.asMap((String)jsonMsgContent);
            return new TailsyncManualStartWebsocketMessage(jsonMap);
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the '" + TailsyncManualStartWebsocketMessage.class.getName() + "' instance for the given websocket message: " + websocketMessage, ex);
        }
    }

    @Override
    public String getMessageToSend() throws WebsocketMessageException {
        try {
            return PREFIX + this.asJsonString();
        }
        catch (Exception ex) {
            throw new WebsocketMessageException("Failed to create the websocket message to be send.", ex);
        }
    }

    public TailsyncManualStartActionDTO getManualStartAction() {
        return this.manualStartAction;
    }

    public Instant getSendedAtInUtc() {
        return this.sendedAtInUtc;
    }

    public LocalDateTime getSendedAtInLocalDateTime() {
        return TimestampUtil.asLocalDateTime((Instant)this.sendedAtInUtc);
    }

    public String toString() {
        return "TailsyncManualStartWebsocketMessage{manualStartAction=" + String.valueOf(this.manualStartAction) + ", sendedAtInUtc=" + String.valueOf(this.sendedAtInUtc) + "}";
    }
}

