/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene90.blocktree;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.lucene90.blocktree.FieldReader;
import org.apache.lucene.codecs.lucene90.blocktree.Lucene90BlockTreeTermsReader;
import org.apache.lucene.codecs.lucene90.blocktree.SegmentTermsEnumFrame;
import org.apache.lucene.codecs.lucene90.blocktree.Stats;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOBooleanSupplier;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Util;

final class SegmentTermsEnum
extends BaseTermsEnum {
    IndexInput in;
    private SegmentTermsEnumFrame[] stack;
    private final SegmentTermsEnumFrame staticFrame;
    SegmentTermsEnumFrame currentFrame;
    boolean termExists;
    final FieldReader fr;
    private int targetBeforeCurrentLength;
    private final OutputAccumulator outputAccumulator = new OutputAccumulator();
    private int validIndexPrefix;
    private boolean eof;
    final BytesRefBuilder term = new BytesRefBuilder();
    private final FST.BytesReader fstReader;
    private FST.Arc<BytesRef>[] arcs = new FST.Arc[1];

    public SegmentTermsEnum(FieldReader fr) throws IOException {
        this.fr = fr;
        this.stack = new SegmentTermsEnumFrame[0];
        this.staticFrame = new SegmentTermsEnumFrame(this, -1);
        this.fstReader = fr.index == null ? null : fr.index.getBytesReader();
        for (int arcIdx = 0; arcIdx < this.arcs.length; ++arcIdx) {
            this.arcs[arcIdx] = new FST.Arc();
        }
        this.currentFrame = this.staticFrame;
        if (fr.index != null) {
            FST.Arc<BytesRef> arc = fr.index.getFirstArc(this.arcs[0]);
            assert (arc.isFinal());
        } else {
            Object arc = null;
        }
        this.validIndexPrefix = 0;
    }

    void initIndexInput() {
        if (this.in == null) {
            this.in = this.fr.parent.termsIn.clone();
        }
    }

    public Stats computeBlockStats() throws IOException {
        FST.Arc<BytesRef> arc;
        Stats stats = new Stats(this.fr.parent.segment, this.fr.fieldInfo.name);
        if (this.fr.index != null) {
            stats.indexNumBytes = this.fr.index.ramBytesUsed();
        }
        this.currentFrame = this.staticFrame;
        if (this.fr.index != null) {
            arc = this.fr.index.getFirstArc(this.arcs[0]);
            assert (arc.isFinal());
        } else {
            arc = null;
        }
        this.currentFrame = this.pushFrame(arc, this.fr.rootCode, 0);
        this.currentFrame.fpOrig = this.currentFrame.fp;
        this.currentFrame.loadBlock();
        this.validIndexPrefix = 0;
        stats.startBlock(this.currentFrame, !this.currentFrame.isLastInFloor);
        while (true) {
            if (this.currentFrame.nextEnt == this.currentFrame.entCount) {
                stats.endBlock(this.currentFrame);
                if (!this.currentFrame.isLastInFloor) {
                    this.currentFrame.loadNextFloorBlock();
                    stats.startBlock(this.currentFrame, true);
                } else {
                    if (this.currentFrame.ord == 0) break;
                    long lastFP = this.currentFrame.fpOrig;
                    this.currentFrame = this.stack[this.currentFrame.ord - 1];
                    assert (lastFP == this.currentFrame.lastSubFP);
                    continue;
                }
            }
            while (this.currentFrame.next()) {
                this.currentFrame = this.pushFrame(null, this.currentFrame.lastSubFP, this.term.length());
                this.currentFrame.fpOrig = this.currentFrame.fp;
                this.currentFrame.loadBlock();
                stats.startBlock(this.currentFrame, !this.currentFrame.isLastInFloor);
            }
            stats.term(this.term.get());
        }
        stats.finish();
        this.currentFrame = this.staticFrame;
        if (this.fr.index != null) {
            arc = this.fr.index.getFirstArc(this.arcs[0]);
            assert (arc.isFinal());
        } else {
            arc = null;
        }
        this.currentFrame = this.pushFrame(arc, this.fr.rootCode, 0);
        this.currentFrame.rewind();
        this.currentFrame.loadBlock();
        this.validIndexPrefix = 0;
        this.term.clear();
        return stats;
    }

    private SegmentTermsEnumFrame getFrame(int ord) throws IOException {
        if (ord >= this.stack.length) {
            SegmentTermsEnumFrame[] next = new SegmentTermsEnumFrame[ArrayUtil.oversize(1 + ord, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.stack, 0, next, 0, this.stack.length);
            for (int stackOrd = this.stack.length; stackOrd < next.length; ++stackOrd) {
                next[stackOrd] = new SegmentTermsEnumFrame(this, stackOrd);
            }
            this.stack = next;
        }
        assert (this.stack[ord].ord == ord);
        return this.stack[ord];
    }

    private FST.Arc<BytesRef> getArc(int ord) {
        if (ord >= this.arcs.length) {
            FST.Arc[] next = new FST.Arc[ArrayUtil.oversize(1 + ord, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.arcs, 0, next, 0, this.arcs.length);
            for (int arcOrd = this.arcs.length; arcOrd < next.length; ++arcOrd) {
                next[arcOrd] = new FST.Arc();
            }
            this.arcs = next;
        }
        return this.arcs[ord];
    }

    SegmentTermsEnumFrame pushFrame(FST.Arc<BytesRef> arc, BytesRef frameData, int length) throws IOException {
        this.outputAccumulator.reset();
        this.outputAccumulator.push(frameData);
        return this.pushFrame(arc, length);
    }

    SegmentTermsEnumFrame pushFrame(FST.Arc<BytesRef> arc, int length) throws IOException {
        this.outputAccumulator.prepareRead();
        long code = this.fr.readVLongOutput(this.outputAccumulator);
        long fpSeek = code >>> 2;
        SegmentTermsEnumFrame f = this.getFrame(1 + this.currentFrame.ord);
        f.hasTermsOrig = f.hasTerms = (code & 2L) != 0L;
        boolean bl = f.isFloor = (code & 1L) != 0L;
        if (f.isFloor) {
            f.setFloorData(this.outputAccumulator);
        }
        this.pushFrame(arc, fpSeek, length);
        return f;
    }

    SegmentTermsEnumFrame pushFrame(FST.Arc<BytesRef> arc, long fp, int length) throws IOException {
        SegmentTermsEnumFrame f = this.getFrame(1 + this.currentFrame.ord);
        f.arc = arc;
        if (f.fpOrig == fp && f.nextEnt != -1) {
            if (f.ord > this.targetBeforeCurrentLength) {
                f.rewind();
            }
            assert (length == f.prefixLength);
        } else {
            f.nextEnt = -1;
            f.prefixLength = length;
            f.state.termBlockOrd = 0;
            f.fpOrig = f.fp = fp;
            f.lastSubFP = -1L;
        }
        return f;
    }

    private boolean clearEOF() {
        this.eof = false;
        return true;
    }

    private boolean setEOF() {
        this.eof = true;
        return true;
    }

    private IOBooleanSupplier prepareSeekExact(BytesRef target, boolean prefetch) throws IOException {
        int targetUpto;
        FST.Arc<BytesRef> arc;
        if (this.fr.index == null) {
            throw new IllegalStateException("terms index was not loaded");
        }
        if (this.fr.size() > 0L && (target.compareTo(this.fr.getMin()) < 0 || target.compareTo(this.fr.getMax()) > 0)) {
            return null;
        }
        this.term.grow(1 + target.length);
        assert (this.clearEOF());
        this.targetBeforeCurrentLength = this.currentFrame.ord;
        this.outputAccumulator.reset();
        if (this.currentFrame != this.staticFrame) {
            arc = this.arcs[0];
            assert (arc.isFinal());
            this.outputAccumulator.push(arc.output());
            SegmentTermsEnumFrame lastFrame = this.stack[0];
            assert (this.validIndexPrefix <= this.term.length());
            int targetLimit = Math.min(target.length, this.validIndexPrefix);
            int cmp = 0;
            for (targetUpto = 0; targetUpto < targetLimit && (cmp = (this.term.byteAt(targetUpto) & 0xFF) - (target.bytes[target.offset + targetUpto] & 0xFF)) == 0; ++targetUpto) {
                arc = this.arcs[1 + targetUpto];
                assert (arc.label() == (target.bytes[target.offset + targetUpto] & 0xFF)) : "arc.label=" + (char)arc.label() + " targetLabel=" + (char)(target.bytes[target.offset + targetUpto] & 0xFF);
                this.outputAccumulator.push(arc.output());
                if (!arc.isFinal()) continue;
                lastFrame = this.stack[1 + lastFrame.ord];
            }
            if (cmp == 0) {
                cmp = Arrays.compareUnsigned(this.term.bytes(), targetUpto, this.term.length(), target.bytes, target.offset + targetUpto, target.offset + target.length);
            }
            if (cmp < 0) {
                this.currentFrame = lastFrame;
            } else if (cmp > 0) {
                this.targetBeforeCurrentLength = lastFrame.ord;
                this.currentFrame = lastFrame;
                this.currentFrame.rewind();
            } else {
                assert (this.term.length() == target.length);
                if (this.termExists) {
                    return () -> true;
                }
            }
        } else {
            this.targetBeforeCurrentLength = -1;
            arc = this.fr.index.getFirstArc(this.arcs[0]);
            assert (arc.isFinal());
            assert (arc.output() != null);
            this.outputAccumulator.push(arc.output());
            this.currentFrame = this.staticFrame;
            targetUpto = 0;
            this.outputAccumulator.push(arc.nextFinalOutput());
            this.currentFrame = this.pushFrame(arc, 0);
            this.outputAccumulator.pop(arc.nextFinalOutput());
        }
        while (targetUpto < target.length) {
            int targetLabel = target.bytes[target.offset + targetUpto] & 0xFF;
            FST.Arc<BytesRef> nextArc = this.fr.index.findTargetArc(targetLabel, arc, this.getArc(1 + targetUpto), this.fstReader);
            if (nextArc == null) {
                this.validIndexPrefix = this.currentFrame.prefixLength;
                this.currentFrame.scanToFloorFrame(target);
                if (!this.currentFrame.hasTerms) {
                    this.termExists = false;
                    this.term.setByteAt(targetUpto, (byte)targetLabel);
                    this.term.setLength(1 + targetUpto);
                    return null;
                }
                if (prefetch) {
                    this.currentFrame.prefetchBlock();
                }
                return () -> {
                    this.currentFrame.loadBlock();
                    TermsEnum.SeekStatus result = this.currentFrame.scanToTerm(target, true);
                    return result == TermsEnum.SeekStatus.FOUND;
                };
            }
            arc = nextArc;
            this.term.setByteAt(targetUpto, (byte)targetLabel);
            assert (arc.output() != null);
            this.outputAccumulator.push(arc.output());
            ++targetUpto;
            if (!arc.isFinal()) continue;
            this.outputAccumulator.push(arc.nextFinalOutput());
            this.currentFrame = this.pushFrame(arc, targetUpto);
            this.outputAccumulator.pop(arc.nextFinalOutput());
        }
        this.validIndexPrefix = this.currentFrame.prefixLength;
        this.currentFrame.scanToFloorFrame(target);
        if (!this.currentFrame.hasTerms) {
            this.termExists = false;
            this.term.setLength(targetUpto);
            return null;
        }
        if (prefetch) {
            this.currentFrame.prefetchBlock();
        }
        return () -> {
            this.currentFrame.loadBlock();
            TermsEnum.SeekStatus result = this.currentFrame.scanToTerm(target, true);
            return result == TermsEnum.SeekStatus.FOUND;
        };
    }

    @Override
    public IOBooleanSupplier prepareSeekExact(BytesRef target) throws IOException {
        return this.prepareSeekExact(target, true);
    }

    @Override
    public boolean seekExact(BytesRef target) throws IOException {
        IOBooleanSupplier termExistsSupplier = this.prepareSeekExact(target, false);
        return termExistsSupplier != null && termExistsSupplier.get();
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef target) throws IOException {
        int targetUpto;
        FST.Arc<BytesRef> arc;
        if (this.fr.index == null) {
            throw new IllegalStateException("terms index was not loaded");
        }
        this.term.grow(1 + target.length);
        assert (this.clearEOF());
        this.targetBeforeCurrentLength = this.currentFrame.ord;
        this.outputAccumulator.reset();
        if (this.currentFrame != this.staticFrame) {
            arc = this.arcs[0];
            assert (arc.isFinal());
            this.outputAccumulator.push(arc.output());
            SegmentTermsEnumFrame lastFrame = this.stack[0];
            assert (this.validIndexPrefix <= this.term.length());
            int targetLimit = Math.min(target.length, this.validIndexPrefix);
            int cmp = 0;
            for (targetUpto = 0; targetUpto < targetLimit && (cmp = (this.term.byteAt(targetUpto) & 0xFF) - (target.bytes[target.offset + targetUpto] & 0xFF)) == 0; ++targetUpto) {
                arc = this.arcs[1 + targetUpto];
                assert (arc.label() == (target.bytes[target.offset + targetUpto] & 0xFF)) : "arc.label=" + (char)arc.label() + " targetLabel=" + (char)(target.bytes[target.offset + targetUpto] & 0xFF);
                this.outputAccumulator.push(arc.output());
                if (!arc.isFinal()) continue;
                lastFrame = this.stack[1 + lastFrame.ord];
            }
            if (cmp == 0) {
                cmp = Arrays.compareUnsigned(this.term.bytes(), targetUpto, this.term.length(), target.bytes, target.offset + targetUpto, target.offset + target.length);
            }
            if (cmp < 0) {
                this.currentFrame = lastFrame;
            } else if (cmp > 0) {
                this.targetBeforeCurrentLength = 0;
                this.currentFrame = lastFrame;
                this.currentFrame.rewind();
            } else {
                assert (this.term.length() == target.length);
                if (this.termExists) {
                    return TermsEnum.SeekStatus.FOUND;
                }
            }
        } else {
            this.targetBeforeCurrentLength = -1;
            arc = this.fr.index.getFirstArc(this.arcs[0]);
            assert (arc.isFinal());
            assert (arc.output() != null);
            this.outputAccumulator.push(arc.output());
            this.currentFrame = this.staticFrame;
            targetUpto = 0;
            this.outputAccumulator.push(arc.nextFinalOutput());
            this.currentFrame = this.pushFrame(arc, 0);
            this.outputAccumulator.pop(arc.nextFinalOutput());
        }
        while (targetUpto < target.length) {
            int targetLabel = target.bytes[target.offset + targetUpto] & 0xFF;
            FST.Arc<BytesRef> nextArc = this.fr.index.findTargetArc(targetLabel, arc, this.getArc(1 + targetUpto), this.fstReader);
            if (nextArc == null) {
                this.validIndexPrefix = this.currentFrame.prefixLength;
                this.currentFrame.scanToFloorFrame(target);
                this.currentFrame.loadBlock();
                TermsEnum.SeekStatus result = this.currentFrame.scanToTerm(target, false);
                if (result == TermsEnum.SeekStatus.END) {
                    this.term.copyBytes(target);
                    this.termExists = false;
                    if (this.next() != null) {
                        return TermsEnum.SeekStatus.NOT_FOUND;
                    }
                    return TermsEnum.SeekStatus.END;
                }
                return result;
            }
            this.term.setByteAt(targetUpto, (byte)targetLabel);
            arc = nextArc;
            assert (arc.output() != null);
            this.outputAccumulator.push(arc.output());
            ++targetUpto;
            if (!arc.isFinal()) continue;
            this.outputAccumulator.push(arc.nextFinalOutput());
            this.currentFrame = this.pushFrame(arc, targetUpto);
            this.outputAccumulator.pop(arc.nextFinalOutput());
        }
        this.validIndexPrefix = this.currentFrame.prefixLength;
        this.currentFrame.scanToFloorFrame(target);
        this.currentFrame.loadBlock();
        TermsEnum.SeekStatus result = this.currentFrame.scanToTerm(target, false);
        if (result == TermsEnum.SeekStatus.END) {
            this.term.copyBytes(target);
            this.termExists = false;
            if (this.next() != null) {
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            return TermsEnum.SeekStatus.END;
        }
        return result;
    }

    private void printSeekState(PrintStream out) throws IOException {
        if (this.currentFrame == this.staticFrame) {
            out.println("  no prior seek");
        } else {
            out.println("  prior seek state:");
            int ord = 0;
            boolean isSeekFrame = true;
            while (true) {
                SegmentTermsEnumFrame f = this.getFrame(ord);
                assert (f != null);
                BytesRef prefix = new BytesRef(this.term.get().bytes, 0, f.prefixLength);
                if (f.nextEnt == -1) {
                    out.println("    frame " + (isSeekFrame ? "(seek)" : "(next)") + " ord=" + ord + " fp=" + f.fp + (String)(f.isFloor ? " (fpOrig=" + f.fpOrig + ")" : "") + " prefixLen=" + f.prefixLength + " prefix=" + String.valueOf(prefix) + (String)(f.nextEnt == -1 ? "" : " (of " + f.entCount + ")") + " hasTerms=" + f.hasTerms + " isFloor=" + f.isFloor + " code=" + ((f.fp << 2) + (long)(f.hasTerms ? 2 : 0) + (long)(f.isFloor ? 1 : 0)) + " isLastInFloor=" + f.isLastInFloor + " mdUpto=" + f.metaDataUpto + " tbOrd=" + f.getTermBlockOrd());
                } else {
                    out.println("    frame " + (isSeekFrame ? "(seek, loaded)" : "(next, loaded)") + " ord=" + ord + " fp=" + f.fp + (String)(f.isFloor ? " (fpOrig=" + f.fpOrig + ")" : "") + " prefixLen=" + f.prefixLength + " prefix=" + String.valueOf(prefix) + " nextEnt=" + f.nextEnt + (String)(f.nextEnt == -1 ? "" : " (of " + f.entCount + ")") + " hasTerms=" + f.hasTerms + " isFloor=" + f.isFloor + " code=" + ((f.fp << 2) + (long)(f.hasTerms ? 2 : 0) + (long)(f.isFloor ? 1 : 0)) + " lastSubFP=" + f.lastSubFP + " isLastInFloor=" + f.isLastInFloor + " mdUpto=" + f.metaDataUpto + " tbOrd=" + f.getTermBlockOrd());
                }
                if (this.fr.index != null) {
                    long code;
                    ByteArrayDataInput reader;
                    long codeOrig;
                    assert (!isSeekFrame || f.arc != null) : "isSeekFrame=" + isSeekFrame + " f.arc=" + String.valueOf(f.arc);
                    if (f.prefixLength > 0 && isSeekFrame && f.arc.label() != (this.term.byteAt(f.prefixLength - 1) & 0xFF)) {
                        out.println("      broken seek state: arc.label=" + (char)f.arc.label() + " vs term byte=" + (char)(this.term.byteAt(f.prefixLength - 1) & 0xFF));
                        throw new RuntimeException("seek state is broken");
                    }
                    BytesRef output = Util.get(this.fr.index, prefix);
                    if (output == null) {
                        out.println("      broken seek state: prefix is not final in index");
                        throw new RuntimeException("seek state is broken");
                    }
                    if (isSeekFrame && !f.isFloor && (codeOrig = this.fr.readVLongOutput(reader = new ByteArrayDataInput(output.bytes, output.offset, output.length))) != (code = f.fp << 2 | (long)(f.hasTerms ? 2 : 0) | (long)(f.isFloor ? 1 : 0))) {
                        out.println("      broken seek state: output code=" + codeOrig + " doesn't match frame code=" + code);
                        throw new RuntimeException("seek state is broken");
                    }
                }
                if (f == this.currentFrame) break;
                if (f.prefixLength == this.validIndexPrefix) {
                    isSeekFrame = false;
                }
                ++ord;
            }
        }
    }

    @Override
    public BytesRef next() throws IOException {
        if (this.in == null) {
            FST.Arc<BytesRef> arc;
            if (this.fr.index != null) {
                arc = this.fr.index.getFirstArc(this.arcs[0]);
                assert (arc.isFinal());
            } else {
                arc = null;
            }
            this.currentFrame = this.pushFrame(arc, this.fr.rootCode, 0);
            this.currentFrame.loadBlock();
        }
        this.targetBeforeCurrentLength = this.currentFrame.ord;
        assert (!this.eof);
        if (this.currentFrame == this.staticFrame) {
            boolean result = this.seekExact(this.term.get());
            assert (result);
        }
        while (this.currentFrame.nextEnt == this.currentFrame.entCount) {
            if (!this.currentFrame.isLastInFloor) {
                this.currentFrame.loadNextFloorBlock();
                break;
            }
            if (this.currentFrame.ord == 0) {
                assert (this.setEOF());
                this.term.clear();
                this.validIndexPrefix = 0;
                this.currentFrame.rewind();
                this.termExists = false;
                return null;
            }
            long lastFP = this.currentFrame.fpOrig;
            this.currentFrame = this.stack[this.currentFrame.ord - 1];
            if (this.currentFrame.nextEnt == -1 || this.currentFrame.lastSubFP != lastFP) {
                this.currentFrame.scanToFloorFrame(this.term.get());
                this.currentFrame.loadBlock();
                this.currentFrame.scanToSubBlock(lastFP);
            }
            this.validIndexPrefix = Math.min(this.validIndexPrefix, this.currentFrame.prefixLength);
        }
        while (this.currentFrame.next()) {
            this.currentFrame = this.pushFrame(null, this.currentFrame.lastSubFP, this.term.length());
            this.currentFrame.loadBlock();
        }
        return this.term.get();
    }

    @Override
    public BytesRef term() {
        assert (!this.eof);
        return this.term.get();
    }

    @Override
    public int docFreq() throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.currentFrame.state.docFreq;
    }

    @Override
    public long totalTermFreq() throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.currentFrame.state.totalTermFreq;
    }

    @Override
    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.fr.parent.postingsReader.postings(this.fr.fieldInfo, this.currentFrame.state, reuse, flags);
    }

    @Override
    public ImpactsEnum impacts(int flags) throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        return this.fr.parent.postingsReader.impacts(this.fr.fieldInfo, this.currentFrame.state, flags);
    }

    @Override
    public void seekExact(BytesRef target, TermState otherState) {
        assert (this.clearEOF());
        if (target.compareTo(this.term.get()) != 0 || !this.termExists) {
            assert (otherState != null && otherState instanceof BlockTermState);
            this.currentFrame = this.staticFrame;
            this.currentFrame.state.copyFrom(otherState);
            this.term.copyBytes(target);
            this.currentFrame.metaDataUpto = this.currentFrame.getTermBlockOrd();
            assert (this.currentFrame.metaDataUpto > 0);
            this.validIndexPrefix = 0;
        }
    }

    @Override
    public TermState termState() throws IOException {
        assert (!this.eof);
        this.currentFrame.decodeMetaData();
        TermState ts = this.currentFrame.state.clone();
        return ts;
    }

    @Override
    public void seekExact(long ord) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ord() {
        throw new UnsupportedOperationException();
    }

    static class OutputAccumulator
    extends DataInput {
        BytesRef[] outputs = new BytesRef[16];
        BytesRef current;
        int num;
        int outputIndex;
        int index;

        OutputAccumulator() {
        }

        void push(BytesRef output) {
            if (output != Lucene90BlockTreeTermsReader.NO_OUTPUT) {
                assert (output.length > 0);
                this.outputs = ArrayUtil.grow(this.outputs, this.num + 1);
                this.outputs[this.num++] = output;
            }
        }

        void pop(BytesRef output) {
            if (output != Lucene90BlockTreeTermsReader.NO_OUTPUT) {
                assert (this.num > 0);
                assert (this.outputs[this.num - 1] == output);
                --this.num;
            }
        }

        void pop(int cnt) {
            assert (this.num >= cnt);
            this.num -= cnt;
        }

        int outputCount() {
            return this.num;
        }

        void reset() {
            this.num = 0;
        }

        void prepareRead() {
            this.index = 0;
            this.outputIndex = 0;
            this.current = this.outputs[0];
        }

        void setFloorData(ByteArrayDataInput floorData) {
            assert (this.outputIndex == this.num - 1) : "floor data should be stored in last arc, get outputIndex: " + this.outputIndex + ", num: " + this.num;
            BytesRef output = this.outputs[this.outputIndex];
            floorData.reset(output.bytes, output.offset + this.index, output.length - this.index);
        }

        @Override
        public byte readByte() throws IOException {
            if (this.index >= this.current.length) {
                this.current = this.outputs[++this.outputIndex];
                this.index = 0;
            }
            return this.current.bytes[this.current.offset + this.index++];
        }

        @Override
        public void readBytes(byte[] b, int offset, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void skipBytes(long numBytes) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

