/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.opensearch.plugin;

import de.virtimo.bpc.opensearch.plugin.ReplicationJobStartAction;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.utils.MapUtil;
import de.virtimo.bpc.opensearch.plugin.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;

public class ReplicationJobStartActions
implements Iterable<ReplicationJobStartAction>,
OpenSearchPluginDTO {
    private final List<ReplicationJobStartAction> actions = new ArrayList<ReplicationJobStartAction>();
    private String transactionId;

    private ReplicationJobStartActions() {
        this.transactionId = null;
    }

    public ReplicationJobStartActions(String transactionId) {
        this.transactionId = transactionId;
    }

    public ReplicationJobStartActions(Map<String, Object> replicationJobActionsMap) {
        this();
        this.checkForWellKnownKeys(replicationJobActionsMap);
        this.actions.addAll(MapUtil.getArrayValueAsListOfObjects(replicationJobActionsMap, (String)"entries", ReplicationJobStartAction.class));
        this.transactionId = MapUtil.getValueAsString(replicationJobActionsMap, (String)"transactionId", null);
    }

    private void checkForWellKnownKeys(Map<String, Object> map) {
        MapUtil.checkForWellKnownKeys(map, Set.of("entries", "transactionId"));
    }

    public ReplicationJobStartActions(StreamInput in) throws IOException {
        this();
        this.actions.addAll(in.readList(ReplicationJobStartAction::new));
        this.transactionId = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.actions);
        out.writeOptionalString(this.transactionId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("entries");
        for (ReplicationJobStartAction action : this.actions) {
            action.toXContent(builder, params);
        }
        builder.endArray();
        builder.field("transactionId", this.transactionId);
        builder.endObject();
        return builder;
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public int size() {
        return this.actions.size();
    }

    public int getNumberOfAffectedServers() {
        return this.getAffectedServersUUIDs().size();
    }

    public Set<String> getAffectedServersUUIDs() {
        HashSet<String> serverUUIDs = new HashSet<String>();
        for (ReplicationJobStartAction action : this.actions) {
            serverUUIDs.add(action.getServerUUID());
        }
        return serverUUIDs;
    }

    public void add(ReplicationJobStartAction action) {
        if (action != null && !this.existsForReplicationJobId(action.getReplicationJobId())) {
            this.actions.add(action);
        }
    }

    public void addAll(List<ReplicationJobStartAction> actions) {
        if (actions != null) {
            for (ReplicationJobStartAction action : actions) {
                this.add(action);
            }
        }
    }

    public boolean existsForReplicationJobId(String replicationJobId) {
        return this.getByReplicationJobId(replicationJobId) != null;
    }

    public ReplicationJobStartAction getByReplicationJobId(String replicationJobId) {
        if (!StringUtil.isNullOrEmpty((String)replicationJobId)) {
            for (ReplicationJobStartAction action : this.actions) {
                if (!replicationJobId.equals(action.getReplicationJobId())) continue;
                return action;
            }
        }
        return null;
    }

    public List<ReplicationJobStartAction> getByServerUUID(String serverUUID) {
        ArrayList<ReplicationJobStartAction> result = new ArrayList<ReplicationJobStartAction>();
        if (!StringUtil.isNullOrEmpty((String)serverUUID)) {
            for (ReplicationJobStartAction action : this.actions) {
                if (!serverUUID.equals(action.getServerUUID())) continue;
                result.add(action);
            }
        }
        return result;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public Iterator<ReplicationJobStartAction> iterator() {
        return this.actions.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationJobStartActions that = (ReplicationJobStartActions)o;
        return Objects.equals(this.actions, that.actions) && Objects.equals(this.transactionId, that.transactionId);
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.transactionId);
    }

    public String toString() {
        return "ReplicationJobStartActions{actions=" + String.valueOf(this.actions) + ", transactionId='" + this.transactionId + "'}";
    }
}

