/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.decanter.marshaller.raw;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.karaf.decanter.api.marshaller.Unmarshaller;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"dataFormat=raw"})
public class RawUnmarshaller
implements Unmarshaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(RawUnmarshaller.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> unmarshal(InputStream in) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line).append("\n");
            }
            data.put("payload", builder.toString());
        }
        catch (Exception e) {
            LOGGER.warn("Can't unmarshal", (Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return data;
    }
}

