/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.analysis.datasource;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.module.analysis.datasource.DataSource;
import de.virtimo.bpc.util.MapUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.SearchModule;
import org.opensearch.search.builder.SearchSourceBuilder;

public class OpenSearch
implements DataSource {
    private final OpenSearchService oss;

    public OpenSearch(OpenSearchService oss) {
        this.oss = oss;
    }

    @Override
    public String getData(Map dataSetConfig, Map variables) throws IOException {
        SearchResponse searchResponse = this.getOpenSearchData(dataSetConfig, variables);
        String searchResponseJson = searchResponse.toString();
        return searchResponseJson;
    }

    private SearchResponse getOpenSearchData(Map dataSetConfig, Map variables) throws IOException {
        RestHighLevelClient osClient = this.oss.getClient();
        ObjectMapper objectMapper = new ObjectMapper();
        String indexName = (String)dataSetConfig.get("indexName");
        Map query = (Map)dataSetConfig.get("query");
        Map finalQuery = MapUtil.deepCopy((Map)query);
        this.applyVariables(finalQuery, variables);
        SearchSourceBuilder realSearchSourceBuilder = this.createSearchSourceBuilder(objectMapper.writeValueAsString((Object)finalQuery));
        realSearchSourceBuilder.fetchSource(null, this.getFieldsWithBinaryMapping(indexName));
        SearchRequest searchRequest = new SearchRequest().indices(new String[]{indexName}).source(realSearchSourceBuilder);
        SearchResponse searchResponse = osClient.search(searchRequest, RequestOptions.DEFAULT);
        return searchResponse;
    }

    private String[] getFieldsWithBinaryMapping(String indexName) {
        Set binaryFields = this.oss.getFieldNamesOfType(indexName, "binary");
        return binaryFields.isEmpty() ? null : binaryFields.toArray(new String[0]);
    }

    private Map applyVariables(Map<String, Object> sourceMap, Map variables) {
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            Object o = entry.getValue();
            if (o instanceof HashMap) {
                HashMap map = (HashMap)o;
                this.applyVariables(map, variables);
                continue;
            }
            if (o instanceof List) {
                ArrayList items = (ArrayList)o;
                for (Object item : items) {
                    if (item instanceof String) {
                        this.setVariables(items, variables, entry, (String)item);
                        continue;
                    }
                    if (!(item instanceof Map)) continue;
                    this.applyVariables((Map)item, variables);
                }
                continue;
            }
            if (!(entry.getValue() instanceof String)) continue;
            this.setVariables(sourceMap, variables, entry, (String)o);
        }
        return sourceMap;
    }

    private void setVariables(Object sourceObj, Map variables, Map.Entry<String, Object> entry, String queryValue) {
        String value;
        Pattern pattern = Pattern.compile("\\{([^}]*?)\\}");
        Matcher matcher = pattern.matcher(value = queryValue);
        if (matcher.find()) {
            String varName = matcher.group(1);
            List varValues = variables.getOrDefault(varName, null);
            if (varValues != null) {
                String varValue = (String)varValues.get(0);
                String valueAfterApplyingVar = value.replace("{" + varName + "}", varValue);
                this.replaceVariablePlaceholder(sourceObj, entry, valueAfterApplyingVar);
            } else {
                this.replaceVariablePlaceholder(sourceObj, entry, null);
            }
        }
    }

    private void replaceVariablePlaceholder(Object sourceObj, Map.Entry<String, Object> entry, String valueAfterApplyingVar) {
        if (sourceObj instanceof Map) {
            ((Map)sourceObj).put(entry.getKey(), valueAfterApplyingVar);
        } else if (sourceObj instanceof List) {
            int index = ((List)sourceObj).indexOf("{TEST1}");
            ((List)sourceObj).set(index, valueAfterApplyingVar);
        }
    }

    SearchSourceBuilder createSearchSourceBuilder(String query) throws IOException {
        SearchModule searchModule = new SearchModule(Settings.EMPTY, Collections.emptyList());
        NamedXContentRegistry contentRegistry = new NamedXContentRegistry(searchModule.getNamedXContents());
        XContentParser parser = JsonXContent.jsonXContent.createParser(contentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
        return SearchSourceBuilder.fromXContent((XContentParser)parser);
    }
}

