/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.analysis.modifier;

import de.virtimo.bpc.module.analysis.modifier.Modifier;
import de.virtimo.bpc.module.analysis.util.AnalysisUtil;
import java.util.List;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class JavascriptModifier
implements Modifier {
    private final ScriptEngine jsScriptEngine;
    private final Map dataSetConfig;

    public JavascriptModifier(ScriptEngine jsScriptEngine, Map dataSetConfig) {
        this.jsScriptEngine = jsScriptEngine;
        this.dataSetConfig = dataSetConfig;
    }

    @Override
    public Object modify(String data, String modifier, Map<String, List<String>> variables) throws ScriptException, NoSuchMethodException {
        Map<String, Object> vars = AnalysisUtil.getVarsForModifier(this.dataSetConfig, variables);
        modifier = this.adjustModifier(modifier);
        this.jsScriptEngine.eval(modifier);
        Invocable inv = (Invocable)((Object)this.jsScriptEngine);
        Object result = inv.invokeFunction("getModifiedData", data, vars);
        return result;
    }

    private String adjustModifier(String sourceModifier) {
        return sourceModifier.concat("function getModifiedData (data, vars) {\n   const dataObj = JSON.parse(data);\n   const result = modify(dataObj, vars);\n   if (typeof result === 'object') {\n       return JSON.stringify(result);\n   } else {\n       return result;\n   }\n}\n");
    }
}

