/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auditlog.sink;

import java.io.IOException;
import java.nio.file.Path;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.auditlog.impl.AuditMessage;
import org.opensearch.security.auditlog.sink.AbstractInternalOpenSearchSink;
import org.opensearch.security.auditlog.sink.AuditLogSink;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public final class InternalOpenSearchSink
extends AbstractInternalOpenSearchSink {
    final String index;
    final String type;
    private DateTimeFormatter indexPattern;

    public InternalOpenSearchSink(String name, Settings settings, String settingsPrefix, Path configPath, Client clientProvider, ThreadPool threadPool, AuditLogSink fallbackSink, ClusterService clusterService) {
        super(name, settings, settingsPrefix, clientProvider, threadPool, fallbackSink, null, clusterService);
        Settings sinkSettings = this.getSinkSettings(settingsPrefix);
        this.index = sinkSettings.get("index", "'security-auditlog-'YYYY.MM.dd");
        this.type = sinkSettings.get("type", null);
        try {
            this.indexPattern = DateTimeFormat.forPattern((String)this.index);
        }
        catch (IllegalArgumentException e) {
            this.log.debug("Unable to parse index pattern due to {}. If you have no date pattern configured you can safely ignore this message", (Object)e.getMessage());
        }
    }

    @Override
    public boolean createIndexIfAbsent(String indexName) {
        if (this.clusterService.state().metadata().hasIndex(indexName)) {
            return true;
        }
        try {
            CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName).settings(indexSettings);
            boolean ok = ((CreateIndexResponse)this.clientProvider.admin().indices().create(createIndexRequest).actionGet()).isAcknowledged();
            this.log.info("Index {} created?: {}", (Object)indexName, (Object)ok);
            return ok;
        }
        catch (ResourceAlreadyExistsException resourceAlreadyExistsException) {
            this.log.info("Index {} already exists", (Object)indexName);
            return true;
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean doStore(AuditMessage msg) {
        return super.doStore(msg, this.getExpandedIndexName(this.indexPattern, this.index));
    }
}

