/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor;

import de.virtimo.bpc.util.StringUtil;
import java.util.List;
import java.util.Objects;

public class SearchTaskId {
    private final String sessionId;
    private final String componentId;
    private final String customId;
    private final long timestamp;

    public static SearchTaskId from(String value) {
        if (StringUtil.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("No SearchTaskId given");
        }
        List parts = StringUtil.explode((String)value, (String)"@@@");
        if (parts.size() != 4) {
            throw new IllegalArgumentException("Invalid SearchTaskId: " + value);
        }
        String sessionId = (String)parts.get(0);
        String componentId = (String)parts.get(1);
        String customId = (String)parts.get(2);
        long timestamp = Long.parseLong((String)parts.get(3));
        return new SearchTaskId(sessionId, componentId, customId, timestamp);
    }

    public SearchTaskId(String sessionId, String componentId, String customId) {
        this.sessionId = sessionId;
        this.componentId = componentId;
        this.customId = customId;
        this.timestamp = System.currentTimeMillis();
    }

    public SearchTaskId(String sessionId, String componentId, String customId, long timestamp) {
        this.sessionId = sessionId;
        this.componentId = componentId;
        this.customId = customId;
        this.timestamp = timestamp;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getCustomId() {
        return this.customId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean matches(String searchTaskIdHeaderValue) {
        try {
            SearchTaskId otherSearchTaskId = SearchTaskId.from(searchTaskIdHeaderValue);
            return Objects.equals(this.sessionId, otherSearchTaskId.sessionId) && Objects.equals(this.componentId, otherSearchTaskId.componentId) && Objects.equals(this.customId, otherSearchTaskId.customId);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String asHeaderValue() {
        return this.sessionId + "@@@" + this.componentId + "@@@" + this.customId + "@@@" + this.timestamp;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SearchTaskId)) {
            return false;
        }
        SearchTaskId that = (SearchTaskId)o;
        return this.timestamp == that.timestamp && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.componentId, that.componentId) && Objects.equals(this.customId, that.customId);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.componentId, this.customId, this.timestamp);
    }

    public String toString() {
        return "SearchTaskId{sessionId='" + this.sessionId + "', componentId='" + this.componentId + "', customId='" + this.customId + "', timestamp=" + this.timestamp + "}";
    }
}

