/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.module.monitor.SearchTaskId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.opensearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.opensearch.client.HttpAsyncResponseConsumerFactory;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.tasks.CancelTasksRequest;
import org.opensearch.client.tasks.CancelTasksResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.tasks.TaskInfo;

public class SearchTaskUtil {
    private static final Logger LOGGER = LogManager.getLogger(SearchTaskUtil.class);

    public static RequestOptions createRequestOptionsWithXOpaqueIdHeader(SearchTaskId searchTaskId, int queryBufferLimitInMB) {
        LOGGER.debug("createRequestOptionsWithXOpaqueIdHeader searchTaskId={}, queryBufferLimitInMB={}", (Object)searchTaskId, (Object)queryBufferLimitInMB);
        int queryBufferLimitInBytes = 0x100000 * queryBufferLimitInMB;
        RequestOptions.Builder requestOptionsBuilder = RequestOptions.DEFAULT.toBuilder();
        requestOptionsBuilder.setHttpAsyncResponseConsumerFactory((HttpAsyncResponseConsumerFactory)new HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory(queryBufferLimitInBytes));
        if (searchTaskId != null) {
            requestOptionsBuilder.addHeader("X-Opaque-Id", searchTaskId.asHeaderValue());
        }
        return requestOptionsBuilder.build();
    }

    public static void cancelRunningSearchTasks(OpenSearchService openSearchService, SearchTaskId searchTaskId) {
        LOGGER.debug("cancelRunningSearchTasks openSearchService=..., searchTaskId={}", (Object)searchTaskId);
        SearchTaskUtil.cancelRunningSearchTasks(openSearchService.getClient(), searchTaskId);
    }

    public static void cancelRunningSearchTasks(final RestHighLevelClient restHighLevelClient, final SearchTaskId searchTaskId) {
        LOGGER.debug("cancelRunningSearchTasks restHighLevelClient=..., searchTaskId={}", (Object)searchTaskId);
        if (searchTaskId == null) {
            return;
        }
        final long currentTimestamp = System.currentTimeMillis();
        try {
            restHighLevelClient.tasks().listAsync((ListTasksRequest)new ListTasksRequest().setActions(new String[]{"indices:data/read/search*"}), RequestOptions.DEFAULT, (ActionListener)new ActionListener<ListTasksResponse>(){

                public void onResponse(ListTasksResponse listTasksResponse) {
                    if (listTasksResponse.getTasks() != null) {
                        for (TaskInfo runningSearchTask : listTasksResponse.getTasks()) {
                            SearchTaskUtil.cancelRunningSearchTask(runningSearchTask, restHighLevelClient, searchTaskId, currentTimestamp);
                        }
                    }
                }

                public void onFailure(Exception ex) {
                    LOGGER.warn("Failed to get the list of search requests to potentially cancel one of them.", (Throwable)ex);
                }
            });
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to cancel the old search tasks for the search task id: {}", (Object)searchTaskId, (Object)ex);
        }
    }

    private static void cancelRunningSearchTask(TaskInfo runningSearchTask, RestHighLevelClient restHighLevelClient, SearchTaskId searchTaskId, long currentTimestamp) {
        LOGGER.debug("cancelRunningSearchTask runningSearchTask={}, restHighLevelClient=..., searchTaskId={}, currentTimestamp={}", (Object)runningSearchTask, (Object)searchTaskId, (Object)currentTimestamp);
        String opaqueId = (String)runningSearchTask.getHeaders().get("X-Opaque-Id");
        if (!searchTaskId.matches(opaqueId)) {
            return;
        }
        if (runningSearchTask.getParentTaskId() != null && runningSearchTask.getParentTaskId() != TaskId.EMPTY_TASK_ID) {
            return;
        }
        long oldTimestamp = SearchTaskId.from(opaqueId).getTimestamp();
        if (oldTimestamp >= currentTimestamp) {
            return;
        }
        TaskId runningTaskId = runningSearchTask.getTaskId();
        org.opensearch.client.tasks.TaskId cancellableTaskId = new org.opensearch.client.tasks.TaskId(runningTaskId.getNodeId(), runningTaskId.getId());
        CancelTasksRequest cancelRequest = new CancelTasksRequest.Builder().withTaskId(cancellableTaskId).build();
        restHighLevelClient.tasks().cancelAsync(cancelRequest, RequestOptions.DEFAULT, (ActionListener)new ActionListener<CancelTasksResponse>(){

            public void onResponse(CancelTasksResponse cancelTasksResponse) {
                LOGGER.debug("Search task cancellation response received: {}", (Object)cancelTasksResponse.getTasks());
            }

            public void onFailure(Exception ex) {
                LOGGER.warn("Search task cancellation failed.", (Throwable)ex);
            }
        });
    }
}

