/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor.resource;

import de.virtimo.bpc.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class MonitorColumnRendererFormatter {
    private static final String DEFAULT_RENDERER = "defaultRenderer";
    private final Map<String, Object> customRenderConfig;
    private final Map<String, Object> translationsForBpcLanguage;
    private final Map<String, Object> monitorColumnsConfig;
    private final ColumnFormatter formatter;
    private final ColumnCustomRenderer customRenderer;

    public MonitorColumnRendererFormatter(Map<String, Object> customRenderConfig, Map<String, Object> translationsForBpcLanguage, Map<String, Object> monitorColumnsConfig) {
        this.customRenderConfig = customRenderConfig;
        this.translationsForBpcLanguage = translationsForBpcLanguage;
        this.monitorColumnsConfig = monitorColumnsConfig;
        this.formatter = new ColumnFormatter();
        this.customRenderer = new ColumnCustomRenderer();
    }

    ColumnFormatter getFormatter() {
        return this.formatter;
    }

    ColumnCustomRenderer getCustomRenderer() {
        return this.customRenderer;
    }

    boolean canBeAppliedOnColumnValue(Object columnValue) {
        return columnValue instanceof String;
    }

    boolean shouldApplyRendererOrFormatter(String columnName, Object columnValue) {
        if (this.canBeAppliedOnColumnValue(columnValue)) {
            if (this.formatter.canBeAppliedOnColumn(columnName)) {
                return true;
            }
            if (this.customRenderer.canBeAppliedOnColumn(columnName)) {
                return true;
            }
        }
        return false;
    }

    Object applyRendererOrFormatter(String columnName, Object columnValue) {
        if (this.canBeAppliedOnColumnValue(columnValue)) {
            if (this.formatter.canBeAppliedOnColumn(columnName)) {
                return this.formatter.applyOnColumn(columnName, columnValue);
            }
            if (this.customRenderer.canBeAppliedOnColumn(columnName)) {
                return this.customRenderer.applyOnColumn(columnName, String.valueOf(columnValue));
            }
        }
        return columnValue;
    }

    private Object getMonitorColumnConfig(String columnName, String settingName) {
        Object monitorColumnConfigObject;
        if (this.monitorColumnsConfig != null && columnName != null && (monitorColumnConfigObject = this.monitorColumnsConfig.get(columnName)) instanceof Map) {
            Map rawMap;
            Map monitorColumnConfig = rawMap = (Map)monitorColumnConfigObject;
            return monitorColumnConfig.get(settingName);
        }
        return null;
    }

    private String translateIfAvailable(String text) {
        if (this.translationsForBpcLanguage == null || !this.translationsForBpcLanguage.containsKey(text)) {
            return text;
        }
        Object translatedValue = this.translationsForBpcLanguage.get(text);
        if (translatedValue instanceof String) {
            String translatedValueString = (String)translatedValue;
            return translatedValueString;
        }
        return text;
    }

    class ColumnFormatter {
        private final Map<String, Object> cachedFormatter = new HashMap<String, Object>();

        ColumnFormatter() {
        }

        boolean canBeAppliedOnColumn(String columnName) {
            Object cachedFormatterObject = this.cachedFormatter.get(columnName);
            if (cachedFormatterObject != null) {
                return !Boolean.FALSE.equals(cachedFormatterObject);
            }
            String formatter = this.getFormatterOfColumnFromMonitorConfig(columnName);
            if (formatter != null) {
                this.cachedFormatter.put(columnName, formatter);
                return true;
            }
            this.cachedFormatter.put(columnName, Boolean.FALSE);
            return false;
        }

        private String getFormatterOfColumnFromMonitorConfig(String columnName) {
            String formatterStr;
            Object formatterObject = MonitorColumnRendererFormatter.this.getMonitorColumnConfig(columnName, "formatter");
            if (formatterObject instanceof String && !StringUtil.isNullOrEmpty((String)(formatterStr = (String)formatterObject))) {
                return formatterStr;
            }
            return null;
        }

        private String getFormatterOfColumn(String columnName) {
            return (String)this.cachedFormatter.get(columnName);
        }

        String applyOnColumn(String columnName, Object columnValue) {
            String formatterOfColumn = this.getFormatterOfColumn(columnName);
            return this.applyFormatter(formatterOfColumn, columnValue);
        }

        String applyFormatter(String formatter, Object columnValue) {
            return switch (formatter.toLowerCase()) {
                case "uppercase" -> columnValue.toString().toUpperCase();
                case "lowercase" -> columnValue.toString().toLowerCase();
                case "translate" -> MonitorColumnRendererFormatter.this.translateIfAvailable(columnValue.toString());
                default -> columnValue.toString();
            };
        }
    }

    class ColumnCustomRenderer {
        private final Map<String, Object> cachedCustomRenderer = new HashMap<String, Object>();

        ColumnCustomRenderer() {
        }

        boolean canBeAppliedOnColumn(String columnName) {
            Object cachedCustomRendererObject = this.cachedCustomRenderer.get(columnName);
            if (cachedCustomRendererObject != null) {
                return !Boolean.FALSE.equals(cachedCustomRendererObject);
            }
            String customRenderer = this.getCustomRendererOfColumnFromMonitorConfig(columnName);
            if (customRenderer != null) {
                this.cachedCustomRenderer.put(columnName, customRenderer);
                return true;
            }
            this.cachedCustomRenderer.put(columnName, Boolean.FALSE);
            return false;
        }

        private String getCustomRendererOfColumnFromMonitorConfig(String columnName) {
            Object customRendererObject = MonitorColumnRendererFormatter.this.getMonitorColumnConfig(columnName, "customRenderer");
            if (customRendererObject == null) {
                return null;
            }
            if (customRendererObject instanceof Boolean) {
                Boolean customRendererEnabled = (Boolean)customRendererObject;
                if (customRendererEnabled.booleanValue()) {
                    return MonitorColumnRendererFormatter.DEFAULT_RENDERER;
                }
                return null;
            }
            if (customRendererObject instanceof String) {
                String customRendererStr = (String)customRendererObject;
                return customRendererStr;
            }
            return null;
        }

        private String getCustomRendererOfColumn(String columnName) {
            return (String)this.cachedCustomRenderer.get(columnName);
        }

        String applyOnColumn(String columnName, Object columnValue) {
            String customRendererOfColumn = this.getCustomRendererOfColumn(columnName);
            return this.applyCustomRenderer(customRendererOfColumn, String.valueOf(columnValue));
        }

        String applyCustomRenderer(String rendererName, String columnValue) {
            Object rendererConfig;
            if (rendererName == null || !MonitorColumnRendererFormatter.this.customRenderConfig.containsKey(rendererName)) {
                rendererName = MonitorColumnRendererFormatter.DEFAULT_RENDERER;
            }
            if (!((rendererConfig = MonitorColumnRendererFormatter.this.customRenderConfig.get(rendererName)) instanceof Map)) {
                return columnValue;
            }
            Map rendererMap = (Map)rendererConfig;
            Object valueMapObject = rendererMap.get("valueMap");
            if (!(valueMapObject instanceof Map)) {
                return columnValue;
            }
            Map valueMap = (Map)valueMapObject;
            for (Map.Entry entry : valueMap.entrySet()) {
                Map mappedValueMap;
                Object label;
                if (!((String)entry.getKey()).equalsIgnoreCase(columnValue)) continue;
                Object mappedValue = entry.getValue();
                if (mappedValue instanceof Map && (label = (mappedValueMap = (Map)mappedValue).get("label")) instanceof String) {
                    return MonitorColumnRendererFormatter.this.translateIfAvailable((String)label);
                }
                return columnValue;
            }
            return columnValue;
        }
    }
}

