/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.filestorage;

import de.virtimo.bpc.api.multipart.UploadedFile;
import de.virtimo.bpc.util.FilenameUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.ws.rs.core.MediaType;

public class ByteArrayUploadedFileImpl
implements UploadedFile {
    private final byte[] fileData;
    private final String fileName;
    private final MediaType contentType;
    private File temporaryContentFile;
    private static long uploadCounter = 0L;

    public ByteArrayUploadedFileImpl(byte[] fileData, String fileName, MediaType contentType) {
        this.fileData = fileData;
        this.fileName = fileName;
        this.contentType = contentType;
    }

    @Override
    public String getAttachmentName() {
        return this.fileName;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getFileExtension() {
        return FilenameUtil.extractFileExtension(this.fileName);
    }

    @Override
    public MediaType getContentType() {
        if (this.contentType == null) {
            return MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        return this.contentType;
    }

    @Override
    public File getTemporaryContentFile() throws IOException {
        if (this.temporaryContentFile == null) {
            this.temporaryContentFile = this.writeContentFromAttachmentToTemporaryFile();
        }
        return this.temporaryContentFile;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.fileData);
    }

    @Override
    public void cleanUp() {
        if (this.temporaryContentFile != null) {
            this.temporaryContentFile.delete();
            this.temporaryContentFile = null;
        }
    }

    private File writeContentFromAttachmentToTemporaryFile() throws IOException {
        File tmpFile = File.createTempFile("byte-array-upload-file-bpc" + ++uploadCounter + "-" + System.currentTimeMillis(), ".tmp");
        tmpFile.deleteOnExit();
        try (InputStream inputStream = this.getInputStream();){
            Files.copy(inputStream, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return tmpFile;
    }

    public String toString() {
        return "ByteArrayUploadedFileImpl{, fileName='" + this.fileName + "', contentType=" + String.valueOf(this.contentType) + ", temporaryContentFile=" + String.valueOf(this.temporaryContentFile) + "}";
    }
}

