/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.filestorage;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.virtimo.bpc.api.ItemRestriction;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.filestorage.ObjectStoreReference;
import de.virtimo.bpc.api.storage.exception.StoreItemJsonException;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.ZonedDateTimeDeserializer;
import de.virtimo.bpc.util.ZonedDateTimeSerializer;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;

public class FileStoreItem {
    private final String id;
    private final String filename;
    private final String contentType;
    private final String checksumCrc32;
    private final long filesize;
    private final ZonedDateTime creationDate;
    private final ZonedDateTime modificationDate;
    private final String creator;
    private final String creatorServiceId;
    private final ObjectStoreReference objectStoreReference;
    private final ItemRestriction readRestriction;
    private final ItemRestriction writeRestriction;

    private FileStoreItem(FileStoreItemBuilder builder) {
        this.id = builder.id;
        this.filename = builder.filename;
        this.contentType = builder.contentType;
        this.checksumCrc32 = builder.checksumCrc32;
        this.filesize = builder.filesize;
        this.creationDate = builder.creationDate;
        this.modificationDate = builder.modificationDate;
        this.creator = builder.creator;
        this.creatorServiceId = builder.creatorServiceId;
        this.objectStoreReference = builder.objectStoreReference;
        this.readRestriction = builder.readRestriction;
        this.writeRestriction = builder.writeRestriction;
    }

    public static FileStoreItemBuilder withId(String id) {
        return FileStoreItemBuilder.newInstance().withId(id);
    }

    public static FileStoreItemBuilder withFilename(String filename) {
        return FileStoreItemBuilder.newInstance().withFilename(filename);
    }

    public static FileStoreItemBuilder withContentType(String contentType) {
        return FileStoreItemBuilder.newInstance().withContentType(contentType);
    }

    public static FileStoreItemBuilder withChecksumCrc32(String checksumCrc32) {
        return FileStoreItemBuilder.newInstance().withChecksumCrc32(checksumCrc32);
    }

    public static FileStoreItemBuilder withFilesize(long filesize) {
        return FileStoreItemBuilder.newInstance().withFilesize(filesize);
    }

    public static FileStoreItemBuilder withCreationDate(ZonedDateTime creationDate) {
        return FileStoreItemBuilder.newInstance().withCreationDate(creationDate);
    }

    public static FileStoreItemBuilder withModificationDate(ZonedDateTime modificationDate) {
        return FileStoreItemBuilder.newInstance().withModificationDate(modificationDate);
    }

    public static FileStoreItemBuilder withCreator(String creator) {
        return FileStoreItemBuilder.newInstance().withCreator(creator);
    }

    public static FileStoreItemBuilder withCreatorServiceId(String creatorServiceId) {
        return FileStoreItemBuilder.newInstance().withCreatorServiceId(creatorServiceId);
    }

    public static FileStoreItemBuilder withObjectStoreReference(ObjectStoreReference objectStoreReference) {
        return FileStoreItemBuilder.newInstance().withObjectStoreReference(objectStoreReference);
    }

    public static FileStoreItemBuilder withReadRestriction(ItemRestriction readRestriction) {
        return FileStoreItemBuilder.newInstance().withReadRestriction(readRestriction);
    }

    public static FileStoreItemBuilder withWriteRestriction(ItemRestriction writeRestriction) {
        return FileStoreItemBuilder.newInstance().withWriteRestriction(writeRestriction);
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="filename")
    public String getFilename() {
        return this.filename;
    }

    @JsonProperty(value="contentType")
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="checksumCrc32")
    public String getChecksumCrc32() {
        return this.checksumCrc32;
    }

    @JsonProperty(value="filesize")
    public long getFilesize() {
        return this.filesize;
    }

    @JsonDeserialize(using=ZonedDateTimeDeserializer.class)
    @JsonSerialize(using=ZonedDateTimeSerializer.class)
    @JsonProperty(value="creationDate")
    public ZonedDateTime getCreationDate() {
        return this.creationDate;
    }

    @JsonDeserialize(using=ZonedDateTimeDeserializer.class)
    @JsonSerialize(using=ZonedDateTimeSerializer.class)
    @JsonProperty(value="modificationDate")
    public ZonedDateTime getModificationDate() {
        return this.modificationDate;
    }

    @JsonProperty(value="creator")
    public String getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creatorServiceId")
    public String getCreatorServiceId() {
        return this.creatorServiceId;
    }

    @JsonProperty(value="objectStoreReference")
    public ObjectStoreReference getObjectStoreReference() {
        return this.objectStoreReference;
    }

    @JsonProperty(value="readRestriction")
    public ItemRestriction getReadRestriction() {
        return this.readRestriction;
    }

    @JsonProperty(value="writeRestriction")
    public ItemRestriction getWriteRestriction() {
        return this.writeRestriction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileStoreItem that = (FileStoreItem)o;
        return this.filesize == that.filesize && Objects.equals(this.id, that.id) && Objects.equals(this.filename, that.filename) && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.checksumCrc32, that.checksumCrc32) && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.modificationDate, that.modificationDate) && Objects.equals(this.creator, that.creator) && Objects.equals(this.creatorServiceId, that.creatorServiceId) && Objects.equals(this.objectStoreReference, that.objectStoreReference) && Objects.equals(this.readRestriction, that.readRestriction) && Objects.equals(this.writeRestriction, that.writeRestriction);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.filename, this.contentType, this.checksumCrc32, this.filesize, this.creationDate, this.modificationDate, this.creator, this.creatorServiceId, this.objectStoreReference, this.readRestriction, this.writeRestriction);
    }

    public String toString() {
        return "FileStoreItem{id='" + this.id + "', filename='" + this.filename + "', contentType='" + this.contentType + "', checksumCrc32='" + this.checksumCrc32 + "', filesize=" + this.filesize + ", creationDate='" + String.valueOf(this.creationDate) + "', modificationDate='" + String.valueOf(this.modificationDate) + "', creator='" + this.creator + "', creatorServiceId='" + this.creatorServiceId + "', objectStoreReference=" + String.valueOf(this.objectStoreReference) + ", readRestriction=" + String.valueOf(this.readRestriction) + ", writeRestriction=" + String.valueOf(this.writeRestriction) + "}";
    }

    public boolean isReadableBy(UserSession userSession) {
        return this.readRestriction != null && this.readRestriction.hasAccess(userSession);
    }

    public boolean isWriteableBy(UserSession userSession) {
        return this.writeRestriction != null && this.writeRestriction.hasAccess(userSession);
    }

    public boolean isDeletableBy(UserSession userSession) {
        return this.writeRestriction != null && this.writeRestriction.hasAccess(userSession);
    }

    public String asJsonString() throws StoreItemJsonException {
        try {
            return JsonUtil.getInstance().convertPojoToJsonString(this);
        }
        catch (JsonProcessingException ex) {
            throw new StoreItemJsonException("Failed to convert the store item with the ID '${itemId}' to JSON: ${error}", MapUtil.mapOf("itemId", this.getId(), "error", ex.getMessage()), (Throwable)ex);
        }
    }

    public Map asJsonMap() throws StoreItemJsonException {
        try {
            return JsonUtil.getInstance().jsonStringAsMap(JsonUtil.getInstance().convertPojoToJsonString(this));
        }
        catch (IOException ex) {
            throw new StoreItemJsonException("Failed to convert the store item with the ID '${itemId}' to JSON: ${error}", MapUtil.mapOf("itemId", this.getId(), "error", ex.getMessage()), (Throwable)ex);
        }
    }

    public static class FileStoreItemBuilder {
        private String id;
        private String filename;
        private String contentType;
        private String checksumCrc32;
        private long filesize;
        private ZonedDateTime creationDate;
        private ZonedDateTime modificationDate;
        private String creator;
        private String creatorServiceId;
        private ObjectStoreReference objectStoreReference;
        private ItemRestriction readRestriction;
        private ItemRestriction writeRestriction;

        private FileStoreItemBuilder() {
        }

        private static FileStoreItemBuilder newInstance() {
            return new FileStoreItemBuilder();
        }

        public FileStoreItemBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public FileStoreItemBuilder withFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public FileStoreItemBuilder withContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public FileStoreItemBuilder withChecksumCrc32(String checksumCrc32) {
            this.checksumCrc32 = checksumCrc32;
            return this;
        }

        public FileStoreItemBuilder withFilesize(long filesize) {
            this.filesize = filesize;
            return this;
        }

        public FileStoreItemBuilder withCreationDate(ZonedDateTime creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public FileStoreItemBuilder withModificationDate(ZonedDateTime modificationDate) {
            this.modificationDate = modificationDate;
            return this;
        }

        public FileStoreItemBuilder withCreator(String creator) {
            this.creator = creator;
            return this;
        }

        public FileStoreItemBuilder withCreatorServiceId(String creatorServiceId) {
            this.creatorServiceId = creatorServiceId;
            return this;
        }

        public FileStoreItemBuilder withObjectStoreReference(ObjectStoreReference objectStoreReference) {
            this.objectStoreReference = objectStoreReference;
            return this;
        }

        public FileStoreItemBuilder withReadRestriction(ItemRestriction readRestriction) {
            this.readRestriction = readRestriction;
            return this;
        }

        public FileStoreItemBuilder withWriteRestriction(ItemRestriction writeRestriction) {
            this.writeRestriction = writeRestriction;
            return this;
        }

        public FileStoreItem build() {
            if (StringUtil.isNullOrEmpty(this.id)) {
                throw new IllegalStateException("id required");
            }
            if (StringUtil.isNullOrEmpty(this.filename)) {
                throw new IllegalStateException("filename required");
            }
            if (this.objectStoreReference == null) {
                throw new IllegalStateException("objectStoreReference required");
            }
            if (this.readRestriction == null) {
                throw new IllegalStateException("readRestriction required");
            }
            if (this.writeRestriction == null) {
                throw new IllegalStateException("writeRestriction required");
            }
            return new FileStoreItem(this);
        }
    }
}

