/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.filestorage;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.virtimo.bpc.api.filestorage.FileStoreItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class FileStoreItems
implements Iterable<FileStoreItem> {
    private final Integer start;
    private final Integer limit;
    private final Long total;
    private final List<FileStoreItem> items;

    public FileStoreItems(Integer start, Integer limit, Long total) {
        this.start = start;
        this.limit = limit;
        this.total = total;
        this.items = new ArrayList<FileStoreItem>();
    }

    @JsonProperty(value="start")
    public Integer getStart() {
        return this.start;
    }

    @JsonProperty(value="limit")
    public Integer getLimit() {
        return this.limit;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @JsonProperty(value="size")
    public long size() {
        return this.items.size();
    }

    @JsonProperty(value="total")
    public long total() {
        return this.total;
    }

    @JsonProperty(value="items")
    public List<FileStoreItem> getItems() {
        return this.items;
    }

    public FileStoreItem get(int index) {
        return this.items.get(index);
    }

    public void add(FileStoreItem storeItem) {
        this.items.add(storeItem);
    }

    @Override
    @NotNull
    public Iterator<FileStoreItem> iterator() {
        return this.items.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileStoreItems that = (FileStoreItems)o;
        return Objects.equals(this.start, that.start) && Objects.equals(this.limit, that.limit) && Objects.equals(this.total, that.total) && Objects.equals(this.items, that.items);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.limit, this.total, this.items);
    }

    public String toString() {
        return "FileStoreItems{start=" + this.start + ", limit=" + this.limit + ", total=" + this.total + ", items=" + String.valueOf(this.items) + "}";
    }
}

