/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.opensearch;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Set;

public class IndexInfo {
    private String index;
    private String health;
    private String state;
    private final Set<String> aliases;
    private int numberOfShards;
    private int numberOfReplicas;
    private long docsCount;
    private long docsCountLucene;
    private long docsDeletedLucene;
    private long storeSizeInBytes;
    private long primaryStoreSizeInBytes;
    private boolean reindexRunning;
    private boolean bpcConform;
    private boolean hidden;

    public IndexInfo() {
        this(null);
    }

    public IndexInfo(String index) {
        this.index = index;
        this.health = null;
        this.state = null;
        this.aliases = new HashSet<String>();
        this.numberOfShards = -1;
        this.numberOfReplicas = -1;
        this.docsCount = -1L;
        this.docsCountLucene = -1L;
        this.docsDeletedLucene = -1L;
        this.storeSizeInBytes = 0L;
        this.primaryStoreSizeInBytes = 0L;
        this.reindexRunning = false;
        this.bpcConform = false;
        this.hidden = false;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getHealth() {
        return this.health;
    }

    public void setHealth(String health) {
        this.health = health;
    }

    @JsonIgnore
    public boolean isInState(String state) {
        return state != null && state.equalsIgnoreCase(this.state);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String status) {
        this.state = status;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(Set<String> aliases) {
        this.aliases.clear();
        this.aliases.addAll(aliases);
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public void setNumberOfShards(int numberOfShards) {
        this.numberOfShards = numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public void setNumberOfReplicas(int numberOfReplicas) {
        this.numberOfReplicas = numberOfReplicas;
    }

    public long getDocsCount() {
        return this.docsCount;
    }

    public void setDocsCount(long docsCount) {
        this.docsCount = docsCount;
    }

    public long getDocsCountLucene() {
        return this.docsCountLucene;
    }

    public void setDocsCountLucene(long docsCountLucene) {
        this.docsCountLucene = docsCountLucene;
    }

    public long getDocsDeletedLucene() {
        return this.docsDeletedLucene;
    }

    public void setDocsDeletedLucene(long docsDeletedLucene) {
        this.docsDeletedLucene = docsDeletedLucene;
    }

    public long getStoreSizeInBytes() {
        return this.storeSizeInBytes;
    }

    public void setStoreSizeInBytes(long storeSizeInBytes) {
        this.storeSizeInBytes = storeSizeInBytes;
    }

    public long getPrimaryStoreSizeInBytes() {
        return this.primaryStoreSizeInBytes;
    }

    public void setPrimaryStoreSizeInBytes(long primaryStoreSizeInBytes) {
        this.primaryStoreSizeInBytes = primaryStoreSizeInBytes;
    }

    public boolean isReindexRunning() {
        return this.reindexRunning;
    }

    public void setReindexRunning(boolean reindexRunning) {
        this.reindexRunning = reindexRunning;
    }

    public boolean isBpcConform() {
        return this.bpcConform;
    }

    public void setBpcConform(boolean bpcConform) {
        this.bpcConform = bpcConform;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String toString() {
        return "IndexInfo{index='" + this.index + "', health='" + this.health + "', state='" + this.state + "', aliases=" + String.valueOf(this.aliases) + ", numberOfShards=" + this.numberOfShards + ", numberOfReplicas=" + this.numberOfReplicas + ", docsCount=" + this.docsCount + ", docsCountLucene=" + this.docsCountLucene + ", docsDeletedLucene=" + this.docsDeletedLucene + ", storeSizeInBytes=" + this.storeSizeInBytes + ", primaryStoreSizeInBytes=" + this.primaryStoreSizeInBytes + ", reindexRunning=" + this.reindexRunning + ", bpcConform=" + this.bpcConform + ", hidden=" + this.hidden + "}";
    }
}

