/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.opensearch.querybuilder;

import de.virtimo.bpc.api.opensearch.querybuilder.BpcDataFilter;

public class BpcDataFilterBuilder {
    private String property;
    private String value;
    private String[] values;
    private String operator;
    private String source;
    private boolean invert = false;

    public static BpcDataFilterBuilder newInstance() {
        return new BpcDataFilterBuilder();
    }

    public BpcDataFilterBuilder withProperty(String property) {
        this.property = property;
        return this;
    }

    public BpcDataFilterBuilder withValue(String value) {
        this.value = value;
        return this;
    }

    public BpcDataFilterBuilder withValue(int value) {
        this.value = String.valueOf(value);
        return this;
    }

    public BpcDataFilterBuilder withValues(String[] values) {
        this.values = values;
        return this;
    }

    public BpcDataFilterBuilder withOperator(String operator) {
        this.operator = operator;
        return this;
    }

    public BpcDataFilterBuilder withSource(String source) {
        this.source = source;
        return this;
    }

    public BpcDataFilterBuilder withInvert(boolean invert) {
        this.invert = invert;
        return this;
    }

    public BpcDataFilter build() {
        return new BpcDataFilter(this.property, this.value, this.values, this.operator, this.source, this.invert);
    }
}

