/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.opensearch.querybuilder;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.MappingMetadata;

public class BpcIndexMapping {
    private static final Logger LOGGER = LogManager.getLogger(BpcIndexMapping.class);
    private final MappingMetadata mmd;

    public BpcIndexMapping(MappingMetadata mappingMetaData) {
        this.mmd = mappingMetaData;
    }

    public MappingMetadata getMappingMetaData() {
        return this.mmd;
    }

    public String getPreferredQueryFieldForSortOrAggregation(String field) {
        if (this.hasMultiField(field, "lowercase")) {
            return field + ".lowercase";
        }
        if (this.hasMultiField(field, "raw")) {
            return field + ".raw";
        }
        return field;
    }

    public String getPreferredQueryFieldForIDs(String idField) {
        if (!idField.contains(".") && this.hasMultiField(idField, "raw")) {
            return idField + ".raw";
        }
        return idField;
    }

    public boolean hasMultiField(String field, String subFieldName) {
        boolean hasMultiField = false;
        try {
            Map fieldPropertyMap;
            Map fieldMap = (Map)this.mmd.getSourceAsMap().get("properties");
            if (fieldMap != null && fieldMap.containsKey(field) && (fieldPropertyMap = (Map)fieldMap.get(field)).containsKey("fields") && ((Map)fieldPropertyMap.get("fields")).containsKey(subFieldName)) {
                hasMultiField = true;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return hasMultiField;
    }

    public String getFieldType(String field) {
        String fieldType = "unknown";
        String targetField = field;
        int pointPos = field.indexOf(".");
        if (pointPos > -1) {
            targetField = field.substring(0, pointPos);
        }
        try {
            Map fieldPropertyMap;
            Map fieldMap = (Map)this.mmd.getSourceAsMap().get("properties");
            if (fieldMap != null && fieldMap.containsKey(targetField) && (fieldPropertyMap = (Map)fieldMap.get(targetField)).containsKey("type")) {
                fieldType = (String)fieldPropertyMap.get("type");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
        }
        LOGGER.info("getFieldType field={} => {}", (Object)field, (Object)fieldType);
        return fieldType;
    }
}

