/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.opensearch.querybuilder;

import de.virtimo.bpc.api.opensearch.querybuilder.BpcDataSort;
import de.virtimo.bpc.api.opensearch.querybuilder.BpcIndexMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;

public class BpcSortBuilder {
    private static final Logger LOGGER = LogManager.getLogger(BpcSortBuilder.class);
    private final List<SortBuilder> sorters = new ArrayList<SortBuilder>();
    private final BpcIndexMapping indexMapping;

    public static BpcSortBuilder init(BpcIndexMapping indexMapping) {
        return new BpcSortBuilder(indexMapping);
    }

    private BpcSortBuilder(BpcIndexMapping indexMapping) {
        this.indexMapping = indexMapping;
    }

    public BpcSortBuilder addSortFromJsonArray(String sortJson) throws IOException {
        return this.addSortBuilder(this.createSortBuildersFromJsonArray(sortJson));
    }

    public BpcSortBuilder addSort(List<BpcDataSort> sorts) {
        return this.addSortBuilder(this.createSortBuilders(sorts));
    }

    public BpcSortBuilder addSort(String fieldName, String direction) {
        return this.addSortBuilder(this.createSortBuilder(new BpcDataSort(fieldName, direction)));
    }

    public BpcSortBuilder addSort(BpcDataSort sort) {
        return this.addSortBuilder(this.createSortBuilder(sort));
    }

    public BpcSortBuilder addSortFromCompactFormat(String sortInstructions) {
        return this.addSortBuilder(this.createSortBuildersFromCompactFormat(sortInstructions));
    }

    public BpcSortBuilder addSortBuilder(List<SortBuilder> sortBuilders) {
        if (sortBuilders != null) {
            this.sorters.addAll(sortBuilders);
        }
        return this;
    }

    public BpcSortBuilder addSortBuilder(SortBuilder sortBuilder) {
        if (sortBuilder != null) {
            this.sorters.add(sortBuilder);
        }
        return this;
    }

    public List<SortBuilder> build() {
        return new ArrayList<SortBuilder>(this.sorters);
    }

    private List<SortBuilder> createSortBuildersFromCompactFormat(String sortInstructions) {
        LOGGER.info("createSortBuildersFromCompactFormat sortInstructions={}", (Object)sortInstructions);
        ArrayList<SortBuilder> result = new ArrayList<SortBuilder>();
        if (sortInstructions != null) {
            List<BpcDataSort> sorters = BpcDataSort.fromCompactFormat(sortInstructions);
            result.addAll(this.createSortBuilders(sorters));
        }
        return result;
    }

    private List<SortBuilder> createSortBuildersFromJsonArray(String sortJson) throws IOException {
        LOGGER.info("createSortBuildersFromJsonArray sortJson={}", (Object)sortJson);
        ArrayList<SortBuilder> result = new ArrayList<SortBuilder>();
        if (sortJson != null) {
            List<BpcDataSort> sorters = BpcDataSort.fromJsonArray(sortJson);
            result.addAll(this.createSortBuilders(sorters));
        }
        return result;
    }

    private List<SortBuilder> createSortBuilders(List<BpcDataSort> sorters) {
        LOGGER.info("createSortBuilders sorters={}", sorters);
        ArrayList<SortBuilder> result = new ArrayList<SortBuilder>();
        if (sorters != null) {
            for (BpcDataSort sorter : sorters) {
                result.add(this.createSortBuilder(sorter));
            }
        }
        return result;
    }

    private SortBuilder createSortBuilder(BpcDataSort sorter) {
        LOGGER.info("createSortBuilder sorter={}", (Object)sorter);
        String sortField = this.indexMapping.getPreferredQueryFieldForSortOrAggregation(sorter.getProperty());
        return ((FieldSortBuilder)SortBuilders.fieldSort(sortField).order(SortOrder.valueOf(sorter.getDirection()))).unmappedType("keyword");
    }
}

