/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.http.HttpContext;

public class BasicAuthHttpContext
implements HttpContext {
    private final String basicAuthUsername;
    private final String basicAuthPassword;

    public BasicAuthHttpContext(String basicAuthUsername, String basicAuthPassword) {
        this.basicAuthUsername = basicAuthUsername;
        this.basicAuthPassword = basicAuthPassword;
    }

    public boolean handleSecurity(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (req.getHeader("Authorization") == null) {
            res.setHeader("WWW-Authenticate", "Basic realm=\"BPC\"");
            res.sendError(401);
            return false;
        }
        if (this.authenticated(req)) {
            return true;
        }
        res.sendError(401);
        return false;
    }

    private boolean authenticated(HttpServletRequest request) {
        boolean success = false;
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && authHeader.toUpperCase().startsWith("BASIC ")) {
            request.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
            String basicAuthValue = authHeader.substring(6).trim();
            String usernameAndPassword = new String(Base64.getDecoder().decode(basicAuthValue.getBytes()));
            int userNameIndex = usernameAndPassword.indexOf(":");
            String username = usernameAndPassword.substring(0, userNameIndex);
            String password = usernameAndPassword.substring(userNameIndex + 1);
            boolean bl = success = username.equals(this.basicAuthUsername) && password.equals(this.basicAuthPassword);
            if (success) {
                request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)username);
            }
        }
        return success;
    }

    public URL getResource(String s) {
        return null;
    }

    public String getMimeType(String s) {
        return null;
    }
}

