/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.core.utils.BpcBundleUtil;
import de.virtimo.bpc.util.StringUtil;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class BpcModulesCollector
extends Collector {
    private static final Logger LOGGER = LogManager.getLogger(BpcModulesCollector.class);
    private final BundleContext bundleContext;

    public BpcModulesCollector(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void unregister() {
        LOGGER.info("unregister");
        CollectorRegistry.defaultRegistry.unregister((Collector)this);
    }

    public List<Collector.MetricFamilySamples> collect() {
        LOGGER.info("collect");
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        List<String> labelList = Arrays.asList("bundleId", "bundleState", "name", "symbolicName", "fileName", "version", "build");
        GaugeMetricFamily bpcModulesGauge = new GaugeMetricFamily("bpc_module", "Infos about a BPC module and its state (0=problem, 1=no problem). State '0' is set when the bundle state is 'RESOLVED' or 'FAILURE'.", labelList);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (!BpcBundleUtil.isBpcBundle(bundle)) continue;
            long bundleId = bundle.getBundleId();
            String bundleState = BpcBundleUtil.getBundleState(this.bundleContext, bundle);
            String bundleName = (String)bundle.getHeaders().get("Bundle-Name");
            String bundleSymbolicName = bundle.getSymbolicName();
            String bundleFileName = BpcBundleUtil.getBundleFilename(bundle);
            String bundleVersion = BpcModulesCollector.getVersion(bundle.getVersion());
            String bundleBuild = (String)bundle.getHeaders().get("BPC-Build");
            List<String> labelValueList = Arrays.asList(String.valueOf(bundleId), BpcModulesCollector.emptyStringWhenNull(bundleState), BpcModulesCollector.emptyStringWhenNull(bundleName), BpcModulesCollector.emptyStringWhenNull(bundleSymbolicName), BpcModulesCollector.emptyStringWhenNull(bundleFileName), BpcModulesCollector.emptyStringWhenNull(bundleVersion), BpcModulesCollector.emptyStringWhenNull(bundleBuild));
            boolean bundleWithProblems = BpcBundleUtil.isBundleInSomeKindOfErrorState(this.bundleContext, bundle);
            bpcModulesGauge.addMetric(labelValueList, bundleWithProblems ? 0.0 : 1.0);
        }
        mfs.add((Collector.MetricFamilySamples)bpcModulesGauge);
        return mfs;
    }

    private static String emptyStringWhenNull(String value) {
        return value == null ? "" : value;
    }

    private static String getVersion(Version version) {
        StringBuilder result = new StringBuilder();
        if (version != null) {
            result.append(version.getMajor());
            result.append(".");
            result.append(version.getMinor());
            result.append(".");
            result.append(version.getMicro());
            if (!StringUtil.isNullOrEmpty(version.getQualifier())) {
                result.append("-");
                result.append(version.getQualifier());
            }
        }
        return result.toString();
    }
}

