/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.core.BpcModulesCollector;
import de.virtimo.bpc.core.GeneralMetricsCollector;
import de.virtimo.bpc.core.auth.ClientSessionsMetricsCollector;
import de.virtimo.bpc.core.db.DatabaseConnectionPoolCollector;
import de.virtimo.bpc.core.opensearch.plugin.OpenSearchBpcPluginCollector;
import de.virtimo.bpc.core.replicator.ReplicationMetricsCollector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class PrometheusExports {
    private static final Logger LOGGER = LogManager.getLogger(PrometheusExports.class);
    private static boolean initialized = false;
    private static GeneralMetricsCollector generalMetricsCollector;
    private static ClientSessionsMetricsCollector clientSessionsMetricsCollector;
    private static ReplicationMetricsCollector replicationMetricsCollector;
    private static OpenSearchBpcPluginCollector openSearchBpcPluginCollector;
    private static DatabaseConnectionPoolCollector databaseConnectionPoolCollector;
    private static BpcModulesCollector bpcModulesCollector;

    public static synchronized void register(BundleContext bundleContext) {
        LOGGER.info("register bundleContext={}", (Object)bundleContext);
        if (!initialized) {
            generalMetricsCollector = new GeneralMetricsCollector(bundleContext);
            generalMetricsCollector.register();
            clientSessionsMetricsCollector = new ClientSessionsMetricsCollector(bundleContext);
            clientSessionsMetricsCollector.register();
            replicationMetricsCollector = new ReplicationMetricsCollector(bundleContext);
            replicationMetricsCollector.register();
            openSearchBpcPluginCollector = new OpenSearchBpcPluginCollector(bundleContext);
            openSearchBpcPluginCollector.register();
            databaseConnectionPoolCollector = new DatabaseConnectionPoolCollector(bundleContext);
            databaseConnectionPoolCollector.register();
            bpcModulesCollector = new BpcModulesCollector(bundleContext);
            bpcModulesCollector.register();
            initialized = true;
        }
    }

    public static synchronized void unregister() {
        LOGGER.info("unregister");
        if (initialized) {
            generalMetricsCollector.unregister();
            generalMetricsCollector = null;
            clientSessionsMetricsCollector.unregister();
            clientSessionsMetricsCollector = null;
            replicationMetricsCollector.unregister();
            replicationMetricsCollector = null;
            openSearchBpcPluginCollector.unregister();
            openSearchBpcPluginCollector = null;
            databaseConnectionPoolCollector.unregister();
            databaseConnectionPoolCollector = null;
            bpcModulesCollector.unregister();
            bpcModulesCollector = null;
            initialized = false;
        }
    }
}

