/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.util.MapUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ViewConfigurationValidator
implements SettingValidator {
    private static final Logger LOGGER = LogManager.getLogger(ViewConfigurationValidator.class);
    private final ArrayList<String> viewItemIds = new ArrayList();

    @Override
    public void destroy() {
    }

    @Override
    public boolean canValidate(String moduleId, String moduleInstanceId, String instanceType) {
        return "_core".equalsIgnoreCase(moduleId);
    }

    @Override
    public boolean canValidate(Setting setting) {
        return "viewConfiguration".equalsIgnoreCase(setting.getName());
    }

    @Override
    public List<FrontendWarningException> validate(Setting setting) throws ValidationException {
        LOGGER.info("validate setting={}", (Object)setting);
        this.viewItemIds.clear();
        if (!"viewConfiguration".equalsIgnoreCase(setting.getName())) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "The ViewConfigurationValidator can only be used to validate 'viewConfiguration' settings", MapUtil.mapOf("field", setting.getName()));
        }
        if (!(setting.getValue() instanceof Map)) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "viewConfiguration must be a map", MapUtil.mapOf("field", "viewConfiguration"));
        }
        Map viewConfiguration = setting.getSettingValue().asMap();
        List views = (List)viewConfiguration.get("views");
        for (Map view : views) {
            this.checkViewItemId(view);
        }
        return null;
    }

    @Override
    public List<FrontendWarningException> validate(String moduleId, String moduleInstanceId, String instanceType, Map<String, Setting> settings) throws ValidationException {
        LOGGER.info("validate moduleId={}, moduleInstanceId={}, instanceType={}, settings=...", (Object)moduleId, (Object)moduleInstanceId, (Object)instanceType);
        return null;
    }

    private void checkInViewItems(List items) throws ValidationException {
        for (Object item : items) {
            if (!(item instanceof Map)) continue;
            this.checkViewItemId((Map)item);
        }
    }

    private void checkViewItemId(Map<String, Object> view) throws ValidationException {
        for (Map.Entry<String, Object> entry : view.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!"viewItemId".equals(key)) continue;
            String viewItemId = this.convertViewItemIdValueToString(value);
            if (viewItemId == null) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "viewItemId cannot be null", MapUtil.mapOf("field", "viewConfiguration"));
            }
            if (this.viewItemIds.contains(viewItemId)) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "viewItemId " + String.valueOf(value) + " is defined multiple times ", MapUtil.mapOf("field", "viewConfiguration"));
            }
            this.viewItemIds.add(viewItemId);
        }
        if (view.containsKey("items")) {
            this.checkInViewItems((List)view.get("items"));
        }
    }

    private String convertViewItemIdValueToString(Object value) {
        if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            return Integer.toString(integerValue);
        }
        if (value instanceof String && !value.equals("null") && !value.equals("")) {
            return (String)value;
        }
        return null;
    }
}

