/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IdentityProviderMappings {
    private static final Logger LOGGER = LogManager.getLogger(IdentityProviderMappings.class);
    public static final String ORGANISATIONS = "organisations";
    public static final String ROLES = "roles";
    public static final String RIGHTS = "rights";
    public static final String USERS = "users";
    public static final String ASSIGNED_ORGANISATIONS = "assignedOrganisations";
    public static final String ASSIGNED_ROLES = "assignedRoles";
    public static final String ASSIGNED_RIGHTS = "assignedRights";
    private Map<String, Map<String, Map<String, List<String>>>> mappings = null;

    public IdentityProviderMappings(Setting mappingsSetting) {
        this((Map)mappingsSetting.getValue());
    }

    public IdentityProviderMappings(Map<String, Map<String, Map<String, List<String>>>> mappings) {
        try {
            this.mappings = mappings == null ? new HashMap() : MapUtil.deepCopy(mappings);
        }
        catch (IOException ex) {
            LOGGER.error("Should theoretically not happen ... but the deep copy of the identity provider mapping failed. As result of this, the mapping gets ignored.", (Throwable)ex);
            this.mappings = new HashMap<String, Map<String, Map<String, List<String>>>>();
        }
    }

    public Map<String, Object> asMap() {
        return new HashMap<String, Object>(this.mappings);
    }

    public Set<String> getManuallySetOrganisations() {
        return this._getValues(ORGANISATIONS, "values", "_organisations");
    }

    public Set<String> getManuallySetRoles() {
        return this._getValues(ROLES, "values", "_roles");
    }

    public Set<String> getManuallySetRights() {
        return this._getValues(RIGHTS, "values", "_rights");
    }

    public Set<String> getAssignedOrganisations(String topLevelKey, String objectName) {
        return this._getValues(topLevelKey, ASSIGNED_ORGANISATIONS, objectName);
    }

    public Set<String> getAssignedRoles(String topLevelKey, String objectName) {
        return this._getValues(topLevelKey, ASSIGNED_ROLES, objectName);
    }

    public Set<String> getAssignedRights(String topLevelKey, String objectName) {
        return this._getValues(topLevelKey, ASSIGNED_RIGHTS, objectName);
    }

    public long getUsersCnt() {
        return this._getCnt(USERS);
    }

    public Set<String> getOrganisationsOfAllUsers() {
        return this._getValues(USERS, ASSIGNED_ORGANISATIONS);
    }

    public Set<String> getOrganisationsOfUser(String userId) {
        return this._getValues(USERS, ASSIGNED_ORGANISATIONS, userId);
    }

    public void addOrganisationToUser(String organisation, String userId) {
        this._addValue(USERS, ASSIGNED_ORGANISATIONS, userId, organisation);
    }

    public void removeOrganisationFromUser(String organisation, String userId) {
        this._removeValue(USERS, ASSIGNED_ORGANISATIONS, userId, organisation);
    }

    public Set<String> getRolesOfAllUsers() {
        return this._getValues(USERS, ASSIGNED_ROLES);
    }

    public Set<String> getRolesOfUser(String userId) {
        return this._getValues(USERS, ASSIGNED_ROLES, userId);
    }

    public void addRoleToUser(String role, String userId) {
        this._addValue(USERS, ASSIGNED_ROLES, userId, role);
    }

    public void removeRoleFromUser(String role, String userId) {
        this._removeValue(USERS, ASSIGNED_ROLES, userId, role);
    }

    public Set<String> getRightsOfAllUsers() {
        return this._getValues(USERS, ASSIGNED_RIGHTS);
    }

    public Set<String> getRightsOfUser(String userId) {
        return this._getValues(USERS, ASSIGNED_RIGHTS, userId);
    }

    public void addRightToUser(String right, String userId) {
        this._addValue(USERS, ASSIGNED_RIGHTS, userId, right);
    }

    public void removeRightFromUser(String right, String userId) {
        this._removeValue(USERS, ASSIGNED_RIGHTS, userId, right);
    }

    private long _getCnt(String topLevelKey) {
        if (!StringUtil.isNullOrEmpty(topLevelKey) && this.mappings.containsKey(topLevelKey)) {
            return this.mappings.get(topLevelKey).size();
        }
        return 0L;
    }

    private Set<String> _getValues(String topLevelKey, String assignedKey, String entryKey) {
        Map<String, List<String>> entryValue;
        Map<String, List<String>> entryValueObject;
        Map<String, Map<String, List<String>>> topLevelValues;
        HashSet<String> result = new HashSet<String>();
        if (!StringUtil.isNullOrEmpty(topLevelKey) && !StringUtil.isNullOrEmpty(entryKey) && !StringUtil.isNullOrEmpty(assignedKey) && this.mappings.containsKey(topLevelKey) && (topLevelValues = this._asMapWithCaseInsensitiveKeys(this.mappings.get(topLevelKey))).containsKey(entryKey) && (entryValueObject = topLevelValues.get(entryKey)) instanceof Map && (entryValue = topLevelValues.get(entryKey)).containsKey(assignedKey)) {
            result.addAll((Collection<String>)entryValue.get(assignedKey));
        }
        return result;
    }

    private Set<String> _getValues(String topLevelKey, String assignedKey) {
        HashSet<String> result = new HashSet<String>();
        if (!StringUtil.isNullOrEmpty(topLevelKey) && !StringUtil.isNullOrEmpty(assignedKey) && this.mappings.containsKey(topLevelKey)) {
            Map<String, Map<String, List<String>>> topLevelValues = this.mappings.get(topLevelKey);
            for (String entryKey : topLevelValues.keySet()) {
                Map<String, List<String>> entryValue = topLevelValues.get(entryKey);
                if (!entryValue.containsKey(assignedKey)) continue;
                result.addAll((Collection<String>)entryValue.get(assignedKey));
            }
        }
        return result;
    }

    private void _addValue(String topLevelKey, String assignedKey, String entryKey, String value) {
        List<String> assignedValues;
        Map<String, List<String>> entryValues;
        if (StringUtil.isNullOrEmpty(topLevelKey) || StringUtil.isNullOrEmpty(entryKey) || StringUtil.isNullOrEmpty(assignedKey) || StringUtil.isNullOrEmpty(value)) {
            return;
        }
        Map<String, Map<String, List<String>>> topLevelValues = this._asMapWithCaseInsensitiveKeys(this.mappings.get(topLevelKey));
        this.mappings.put(topLevelKey, topLevelValues);
        if (!topLevelValues.containsKey(entryKey)) {
            topLevelValues.put(entryKey, new HashMap());
        }
        if (!(entryValues = topLevelValues.get(entryKey)).containsKey(assignedKey)) {
            entryValues.put(assignedKey, new ArrayList());
        }
        if (!(assignedValues = entryValues.get(assignedKey)).contains(value)) {
            assignedValues.add(value);
        }
    }

    private void _removeValue(String topLevelKey, String assignedKey, String entryKey, String value) {
        if (StringUtil.isNullOrEmpty(topLevelKey) || StringUtil.isNullOrEmpty(entryKey) || StringUtil.isNullOrEmpty(assignedKey) || StringUtil.isNullOrEmpty(value)) {
            return;
        }
        if (!this.mappings.containsKey(topLevelKey)) {
            return;
        }
        Map<String, Map<String, List<String>>> topLevelValues = this._asMapWithCaseInsensitiveKeys(this.mappings.get(topLevelKey));
        if (!topLevelValues.containsKey(entryKey)) {
            return;
        }
        Map<String, List<String>> entryValues = topLevelValues.get(entryKey);
        if (!entryValues.containsKey(assignedKey)) {
            return;
        }
        List<String> assignedValues = entryValues.get(assignedKey);
        if (!assignedValues.contains(value)) {
            return;
        }
        assignedValues.remove(value);
        if (assignedValues.isEmpty()) {
            entryValues.remove(assignedKey);
        }
        if (entryValues.isEmpty()) {
            topLevelValues.remove(entryKey);
        }
        if (topLevelValues.isEmpty()) {
            this.mappings.remove(topLevelKey);
        }
    }

    private Map<String, Map<String, List<String>>> _asMapWithCaseInsensitiveKeys(Map<String, Map<String, List<String>>> map) {
        TreeMap treeMap;
        if (map instanceof TreeMap && (treeMap = (TreeMap)map).comparator().equals(String.CASE_INSENSITIVE_ORDER)) {
            return map;
        }
        TreeMap<String, Map<String, List<String>>> mapWithCaseInsensitiveKeys = new TreeMap<String, Map<String, List<String>>>(String.CASE_INSENSITIVE_ORDER);
        if (map != null && !map.isEmpty()) {
            mapWithCaseInsensitiveKeys.putAll(map);
        }
        return mapWithCaseInsensitiveKeys;
    }
}

