/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.core.auth.IdentityProviderMappings;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.RightFactory;
import de.virtimo.bpc.core.auth.RolesFactory;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IdentityProviderMappingsApplyer {
    private static final Logger LOGGER = LogManager.getLogger(IdentityProviderMappingsApplyer.class);
    private final Set<String> mappingBlackList = new HashSet<String>();
    private final Set<Organisation> organisations;
    private final Set<Role> roles;
    private final Set<Right> rights;

    public IdentityProviderMappingsApplyer(Set<Organisation> organisations, Set<Role> roles, Set<Right> rights) {
        this.organisations = organisations == null ? new HashSet() : organisations;
        this.roles = roles == null ? new HashSet() : roles;
        this.rights = rights == null ? new HashSet() : rights;
    }

    public void applyIdentityProviderMappings(IdentityProviderMappings identityProviderMappings) {
        LOGGER.debug("applyIdentityProviderMapping identityProviderMappings={}", (Object)identityProviderMappings);
        HashSet<Organisation> orgList = new HashSet<Organisation>(this.organisations);
        HashSet<Role> roleList = new HashSet<Role>(this.roles);
        HashSet<Right> rightList = new HashSet<Right>(this.rights);
        try {
            for (Organisation org : orgList) {
                this.applyMapping(identityProviderMappings, "organisations", org.getName());
            }
            for (Role role : roleList) {
                this.applyMapping(identityProviderMappings, "roles", role.getName());
            }
            for (Right right : rightList) {
                this.applyMapping(identityProviderMappings, "rights", right.getName());
            }
        }
        catch (ClassCastException e) {
            LOGGER.warn("Could not apply setting identityProvider_mappings", (Throwable)e);
        }
    }

    private void applyMapping(IdentityProviderMappings identityProviderMappings, String baseObjectType, String objectName) throws ClassCastException {
        LOGGER.debug("applyMapping identityProviderMappings=..., baseObjectType={}, objectName={}", (Object)baseObjectType, (Object)objectName);
        String blacklistKey = baseObjectType.concat(" | ").concat(objectName).toLowerCase();
        if (this.mappingBlackList.contains(blacklistKey)) {
            return;
        }
        this.mappingBlackList.add(blacklistKey);
        if (baseObjectType.equalsIgnoreCase("organisations")) {
            for (String orgName : identityProviderMappings.getAssignedOrganisations(baseObjectType, objectName)) {
                LOGGER.debug("applyMapping: add Organisation {}", (Object)orgName);
                this.organisations.add(OrganisationFactory.getOrganisation(orgName));
                this.applyMapping(identityProviderMappings, "organisations", orgName);
            }
        }
        if (baseObjectType.equalsIgnoreCase("organisations") || baseObjectType.equalsIgnoreCase("roles")) {
            for (String roleName : identityProviderMappings.getAssignedRoles(baseObjectType, objectName)) {
                LOGGER.debug("applyMapping: add Role {}", (Object)roleName);
                this.roles.add(RolesFactory.getRole(roleName));
                this.applyMapping(identityProviderMappings, "roles", roleName);
            }
        }
        if (baseObjectType.equalsIgnoreCase("organisations") || baseObjectType.equalsIgnoreCase("roles") || baseObjectType.equalsIgnoreCase("rights")) {
            for (String rightName : identityProviderMappings.getAssignedRights(baseObjectType, objectName)) {
                LOGGER.debug("applyMapping: add Right {}", (Object)rightName);
                this.rights.add(RightFactory.getRight(rightName));
                this.applyMapping(identityProviderMappings, "rights", rightName);
            }
        }
    }
}

