/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.identityManagement.IdentityManagerUnsupportedOperationException;
import de.virtimo.bpc.core.auth.IdentityProviderMappings;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.RightFactory;
import de.virtimo.bpc.core.auth.RolesFactory;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UnsupportedIdentityProviderOperationsFallbackHandler {
    private static final Logger LOGGER = LogManager.getLogger(UnsupportedIdentityProviderOperationsFallbackHandler.class);
    private ModuleConfiguration idpConfiguration;
    private Setting oldIdpMappingsSetting;
    private IdentityProviderMappings idpMappings;

    public UnsupportedIdentityProviderOperationsFallbackHandler(ModuleConfiguration idpConfiguration) {
        this.initialize(idpConfiguration);
    }

    public void initialize(ModuleConfiguration idpConfiguration) {
        this.idpConfiguration = idpConfiguration;
        this.oldIdpMappingsSetting = idpConfiguration.getSetting("identityProvider_mappings");
        this.idpMappings = new IdentityProviderMappings(this.oldIdpMappingsSetting);
    }

    public boolean isUnsupportedOperationException(Exception ex) {
        LOGGER.info("isUnsupportedOperationException ex=...");
        if (ex instanceof UnsupportedOperationException) {
            return true;
        }
        return ex instanceof IdentityManagerUnsupportedOperationException;
    }

    private void updateIdpMappingsSettingInModuleConfiguration() throws SettingException {
        LOGGER.info("updateIdpMappingsSettingInModuleConfiguration");
        SimpleSettingImpl updatedIdpMappingsSetting = new SimpleSettingImpl(this.oldIdpMappingsSetting, this.idpMappings.asMap());
        this.idpConfiguration.updateSetting(updatedIdpMappingsSetting, false);
    }

    public void addOrganisation(String userId, String organisationName) throws SettingException {
        LOGGER.info("addOrganisation userId{}, organisationName={}", (Object)userId, (Object)organisationName);
        this.idpMappings.addOrganisationToUser(organisationName, userId);
        this.updateIdpMappingsSettingInModuleConfiguration();
    }

    public void deleteOrganisation(String userId, String organisationName) throws SettingException {
        LOGGER.info("deleteOrganisation userId{}, organisationName={}", (Object)userId, (Object)organisationName);
        this.idpMappings.removeOrganisationFromUser(organisationName, userId);
        this.updateIdpMappingsSettingInModuleConfiguration();
    }

    public Set<Organisation> getOrganisations() {
        LOGGER.info("getOrganisations");
        return OrganisationFactory.getOrganisations(this.idpMappings.getOrganisationsOfAllUsers());
    }

    public Set<Organisation> getUserOrganisations(String userId) {
        LOGGER.info("getUserOrganisations userId={}", (Object)userId);
        return OrganisationFactory.getOrganisations(this.idpMappings.getOrganisationsOfUser(userId));
    }

    public Set<Organisation> getManuallySetOrganisationsFromIdpMappings() {
        LOGGER.info("getManuallySetOrganisationsFromIdpMappings");
        return OrganisationFactory.getOrganisations(this.idpMappings.getManuallySetOrganisations());
    }

    public void addRole(String userId, String roleName) throws SettingException {
        LOGGER.info("addRole userId{}, roleName={}", (Object)userId, (Object)roleName);
        this.idpMappings.addRoleToUser(roleName, userId);
        this.updateIdpMappingsSettingInModuleConfiguration();
    }

    public void deleteRole(String userId, String roleName) throws SettingException {
        LOGGER.info("deleteRole userId{}, roleName={}", (Object)userId, (Object)roleName);
        this.idpMappings.removeRoleFromUser(roleName, userId);
        this.updateIdpMappingsSettingInModuleConfiguration();
    }

    public Set<Role> getRoles() {
        LOGGER.info("getRoles");
        return RolesFactory.getRoles(this.idpMappings.getRolesOfAllUsers());
    }

    public Set<Role> getUserRoles(String userId) {
        LOGGER.info("getUserRoles userId={}", (Object)userId);
        return RolesFactory.getRoles(this.idpMappings.getRolesOfUser(userId));
    }

    public Set<Role> getManuallySetRolesFromIdpMappings() {
        LOGGER.info("getManuallySetRolesFromIdpMappings");
        return RolesFactory.getRoles(this.idpMappings.getManuallySetRoles());
    }

    public void addRight(String userId, String rightName) throws SettingException {
        LOGGER.info("addRight userId{}, rightName={}", (Object)userId, (Object)rightName);
        this.idpMappings.addRightToUser(rightName, userId);
        this.updateIdpMappingsSettingInModuleConfiguration();
    }

    public void deleteRight(String userId, String rightName) throws SettingException {
        LOGGER.info("deleteRight userId{}, rightName={}", (Object)userId, (Object)rightName);
        this.idpMappings.removeRightFromUser(rightName, userId);
        this.updateIdpMappingsSettingInModuleConfiguration();
    }

    public Set<Right> getRights() {
        LOGGER.info("getRights");
        return RightFactory.getRights(this.idpMappings.getRightsOfAllUsers());
    }

    public Set<Right> getUserRights(String userId) {
        LOGGER.info("getUserRights userId={}", (Object)userId);
        return RightFactory.getRights(this.idpMappings.getRightsOfUser(userId));
    }

    public Set<Right> getManuallySetRightsFromIdpMappings() {
        LOGGER.info("getManuallySetRightsFromIdpMappings");
        return RightFactory.getRights(this.idpMappings.getManuallySetRights());
    }
}

