/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.jaas;

import de.virtimo.bpc.api.auth.jaas.BpcCallbackHandler;
import de.virtimo.bpc.core.auth.jaas.TenantCallback;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class BpcCallbackHandlerImpl
implements BpcCallbackHandler {
    private String username;
    private char[] password;
    private String tenant;

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public void setTenant(String tenant) {
        this.tenant = StringUtil.isNullOrEmpty(tenant) ? null : tenant.trim();
    }

    @Override
    public void setPassword(char[] password) {
        this.password = password;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public char[] getPassword() {
        return this.password;
    }

    @Override
    public String getTenant() {
        return this.tenant;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback pc;
            if (callbacks[i] instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                switch (toc.getMessageType()) {
                    case 0: {
                        System.out.println(toc.getMessage());
                        break;
                    }
                    case 2: {
                        System.out.println("ERROR: " + toc.getMessage());
                        break;
                    }
                    case 1: {
                        System.out.println("WARNING: " + toc.getMessage());
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported message type: " + toc.getMessageType());
                    }
                }
                continue;
            }
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                nc.setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                pc = (PasswordCallback)callbacks[i];
                ((PasswordCallback)pc).setPassword(this.password);
                continue;
            }
            if (callbacks[i] instanceof TenantCallback) {
                pc = (TenantCallback)callbacks[i];
                ((TenantCallback)pc).setTenant(this.tenant);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }
}

