/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.autocreate;

import de.virtimo.bpc.api.AbstractEventHandler;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.InstantiableModule;
import de.virtimo.bpc.api.LicenseException;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.auditlog.SystemAuditLog;
import de.virtimo.bpc.api.exception.ModuleInstanceCreateException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.AutoCreateModuleInstancesService;
import de.virtimo.bpc.core.resource.ConfigurationEndpoint;
import de.virtimo.bpc.core.utils.BpcBundleUtil;
import de.virtimo.bpc.module.DefaultModuleConfigurations;
import de.virtimo.bpc.module.JsonDefaultsUtil;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.event.Event;

public class AutoCreateModuleInstancesServiceImpl
implements AutoCreateModuleInstancesService,
BpcService,
BundleListener {
    private static final Logger LOGGER = LogManager.getLogger(AutoCreateModuleInstancesServiceImpl.class);
    private static final Set<String> BUNDLE_FOLDERS_TO_LOOK_FOR_FILES = SetUtil.setOf("resources/autocreate/moduleinstances", "autocreate/moduleinstances");
    private static final Object PROCESS_BUNDLE_LOCK = new Object();
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ModuleManager> moduleManagerTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private final EventRegistration eventRegistration;
    private final Map<String, Set<Bundle>> loadQueue;

    public AutoCreateModuleInstancesServiceImpl(BundleContext bundleContext) {
        LOGGER.info("AutoCreateModuleInstancesServiceImpl bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
        this.loadQueue = new HashMap<String, Set<Bundle>>();
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
        bundleContext.addBundleListener((BundleListener)this);
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forAnyBackendModuleLoadedEvents(new BackendModuleLoadedEventHandler());
        for (Bundle bundle : bundleContext.getBundles()) {
            if (bundle.getState() != 32) continue;
            this.createModuleInstancesFromBundle(bundle, null);
        }
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.debug("shutdownService");
        if (this.bundleContext != null) {
            this.bundleContext.removeBundleListener((BundleListener)this);
        }
        this.eventRegistration.unregisterAllEventHandler();
        BpcServicesTracker.stopAll(this);
        this.loadQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createModuleInstancesFromBundle(Bundle bundle, String onlyForThisModuleId) {
        LOGGER.info("createModuleInstancesFromBundle bundle={}, onlyForThisModuleId={}", (Object)bundle, (Object)onlyForThisModuleId);
        Object object = PROCESS_BUNDLE_LOCK;
        synchronized (object) {
            String symbolicBundleName = bundle.getSymbolicName();
            if (!BpcBundleUtil.isBpcBundle(bundle)) {
                LOGGER.info("The bundle '{}' is not a BPC-Bundle and can be safely ignored.", (Object)symbolicBundleName);
                return;
            }
            Set<URL> urlsToJsonFilesInBundle = BpcBundleUtil.getFilesInBundleAtSpecificFolders(bundle, BUNDLE_FOLDERS_TO_LOOK_FOR_FILES, "*.json");
            if (urlsToJsonFilesInBundle.isEmpty()) {
                LOGGER.info("The bundle '{}' does not have auto create module instances files", (Object)symbolicBundleName);
                return;
            }
            try {
                ModuleManager moduleManager = this.moduleManagerTracker.getService();
                EventManager eventManager = this.eventManagerTracker.getService();
                for (URL jsonFileUrl : urlsToJsonFilesInBundle) {
                    String filePath = jsonFileUrl.getFile();
                    Map<String, Object> fileContent = JsonDefaultsUtil.loadJsonFileAsMap(bundle, filePath);
                    if (fileContent == null) continue;
                    String moduleId = (String)fileContent.get("moduleId");
                    String instanceId = (String)fileContent.get("instanceId");
                    String instanceType = (String)fileContent.get("instanceType");
                    Map settings = (Map)fileContent.get("settings");
                    if (StringUtil.isNullOrEmpty(moduleId)) {
                        LOGGER.warn("Auto create module instances file '{}' does not contain the mandatory field 'moduleId'.", (Object)filePath);
                        continue;
                    }
                    if (StringUtil.isNullOrEmpty(instanceId)) {
                        LOGGER.warn("Auto create module instances file '{}' does not contain the mandatory field 'instanceId'.", (Object)filePath);
                        continue;
                    }
                    if (settings == null) {
                        LOGGER.warn("Auto create module instances file '{}' does not contain the mandatory field 'settings'.", (Object)filePath);
                        continue;
                    }
                    if (onlyForThisModuleId != null && !onlyForThisModuleId.equalsIgnoreCase(moduleId)) continue;
                    try {
                        this.createModuleInstance(moduleManager, eventManager, moduleId, instanceId, instanceType, settings);
                    }
                    catch (ModuleNotFoundException ex) {
                        LOGGER.warn("The module ID '{}' is either invalid or the module is currently not available. We queue this now.", (Object)moduleId);
                        if (!this.loadQueue.containsKey(moduleId)) {
                            this.loadQueue.put(moduleId, new HashSet());
                        }
                        this.loadQueue.get(moduleId).add(bundle);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed to auto create a module instance.", (Throwable)ex);
                    }
                }
            }
            catch (ServiceNotFoundException e) {
                LOGGER.error("Error during auto creation of module instances from the bundle: " + symbolicBundleName, (Throwable)e);
            }
        }
    }

    private void createModuleInstance(ModuleManager moduleManager, EventManager eventManager, String moduleId, String instanceId, String instanceType, Map<String, Object> settings) throws ModuleNotFoundException, SettingException, ModuleInstanceCreateException, LicenseException, ServiceNotFoundException {
        LOGGER.info("createModuleInstance moduleManager=..., eventManager=..., moduleId={}, instanceId={}, instanceType={}, settings=...", (Object)moduleId, (Object)instanceId, (Object)instanceType);
        InstantiableModule instantiableModule = (InstantiableModule)moduleManager.getModuleById(moduleId);
        ModuleInstance moduleInstance = instantiableModule.getModuleInstance(instanceId);
        if (moduleInstance != null) {
            LOGGER.info("Great, nothing to do ... the '{}' instance with the ID '{}' exists already.", (Object)moduleId, (Object)instanceId);
        } else {
            LOGGER.info("Creating the '{}' instance with the ID '{}' for the instance type '{}'.", (Object)moduleId, (Object)instanceId, (Object)instanceType);
            ModuleConfiguration moduleInstanceConfiguration = DefaultModuleConfigurations.getInstance().getForModuleInstance(instantiableModule, instanceType);
            for (String settingName : settings.keySet()) {
                Setting settingObject = moduleInstanceConfiguration.getSetting(settingName);
                if (settingObject instanceof SimpleSettingImpl) {
                    SimpleSettingImpl setting = (SimpleSettingImpl)settingObject;
                    Object givenSettingValue = settings.get(settingName);
                    setting.setValue(givenSettingValue);
                    continue;
                }
                LOGGER.warn("Skipping unknown setting implementation provided by the module '{}' for the setting '{}'.", (Object)moduleId, (Object)settingName);
            }
            moduleInstance = instantiableModule.createModuleInstance(instanceId, instanceType, moduleInstanceConfiguration);
            SystemAuditLog.info("ModuleInstanceCreated", "Module instance '" + ConfigurationEndpoint.getModuleInstanceName(moduleInstance) + "' (" + instanceId + ") of module '" + instantiableModule.getModuleName() + "' (" + instantiableModule.getModuleId() + ") created");
            instantiableModule.moduleInstanceCreated(moduleInstance);
            eventManager.broadcast().moduleInstanceCreated(moduleId, instanceId, instanceType);
        }
    }

    public void bundleChanged(BundleEvent event) {
        LOGGER.info("bundleChanged event={}", (Object)event);
        if (event.getType() == 2) {
            this.createModuleInstancesFromBundle(event.getBundle(), null);
        }
    }

    private void fireAutoCreateOfModuleInstancesDoneEvent(Module module) {
        LOGGER.info("fireAutoCreateOfModuleInstancesDoneEvent module=" + String.valueOf(module));
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/backendModuleLoadedAndAutoCreateModuleInstancesDone", MapUtil.mapOf("moduleId", module.getModuleId(), "module", module));
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to fire the 'auto create of module instances done' event for module '" + String.valueOf(module) + "'.", (Throwable)ex);
        }
    }

    private class BackendModuleLoadedEventHandler
    extends AbstractEventHandler {
        private BackendModuleLoadedEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processEvent(Event event) {
            LOGGER.info("{}.processEvent event=...", (Object)this.getClass().getSimpleName());
            String moduleId = (String)event.getProperty("moduleId");
            Module module = (Module)event.getProperty("module");
            if (moduleId != null && module != null) {
                AutoCreateModuleInstancesServiceImpl.this.createModuleInstancesFromBundle(module.getModuleBundle(), moduleId);
                if (AutoCreateModuleInstancesServiceImpl.this.loadQueue.containsKey(moduleId)) {
                    LOGGER.info("Found queued entries for {}", (Object)moduleId);
                    Set<Bundle> bundleSet = AutoCreateModuleInstancesServiceImpl.this.loadQueue.get(moduleId);
                    try {
                        for (Bundle bundle : bundleSet) {
                            AutoCreateModuleInstancesServiceImpl.this.createModuleInstancesFromBundle(bundle, null);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Something went wrong", (Throwable)e);
                    }
                    finally {
                        bundleSet.clear();
                    }
                }
                AutoCreateModuleInstancesServiceImpl.this.fireAutoCreateOfModuleInstancesDoneEvent(module);
            } else {
                LOGGER.error("Failed to automatically create module instances. Hey BPC-devs, someone changed the properties of the \"de/virtimo/bpc/core/backendModuleLoaded\" event. Please correct this ASAP!");
            }
        }
    }
}

