/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import de.virtimo.bpc.api.backup.BackupJob;
import de.virtimo.bpc.util.StringUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class BackupJobs
implements Iterable<BackupJob> {
    private final Map<String, BackupJob> container = new HashMap<String, BackupJob>();

    public BackupJobs() {
    }

    public BackupJobs(BackupJobs otherContainer) {
        this();
        this.addAll(otherContainer);
    }

    public void add(BackupJob backupJob) {
        if (backupJob != null) {
            this.container.put(backupJob.getBackupJobIdentifier().toLowerCase(), backupJob);
        }
    }

    public void addAll(BackupJobs backupJobs) {
        if (backupJobs != null) {
            for (BackupJob backupJob : backupJobs) {
                this.add(backupJob);
            }
        }
    }

    public BackupJob get(String backupJobIdentifier) {
        return StringUtil.isNullOrEmpty(backupJobIdentifier) ? null : this.container.get(backupJobIdentifier.toLowerCase());
    }

    public boolean contains(String backupJobIdentifier) {
        return !StringUtil.isNullOrEmpty(backupJobIdentifier) && this.container.containsKey(backupJobIdentifier.toLowerCase());
    }

    public boolean contains(BackupJob backupJob) {
        return backupJob != null && this.contains(backupJob.getBackupJobIdentifier());
    }

    public BackupJob remove(String backupJobIdentifier) {
        if (!StringUtil.isNullOrEmpty(backupJobIdentifier)) {
            return this.container.remove(backupJobIdentifier.toLowerCase());
        }
        return null;
    }

    public BackupJob remove(BackupJob backupJob) {
        if (backupJob != null) {
            return this.remove(backupJob.getBackupJobIdentifier());
        }
        return null;
    }

    public int size() {
        return this.container.size();
    }

    public void clear() {
        this.container.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupJobs that = (BackupJobs)o;
        return Objects.equals(this.container, that.container);
    }

    public int hashCode() {
        return Objects.hashCode(this.container);
    }

    @Override
    @NotNull
    public Iterator<BackupJob> iterator() {
        return this.container.values().iterator();
    }
}

