/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.db;

import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.backendconnections.BackendConnectionsModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DataSourceSettings {
    private static final Logger LOGGER = LogManager.getLogger(DataSourceSettings.class);

    @NotNull
    public static List<Map<String, Object>> getAllPaxJdbcDataSourceConfigurations(@NotNull ModuleManager moduleManager) throws ServiceNotFoundException, SettingException, OpenSearchRelatedException {
        LOGGER.info("getAllPaxJdbcDataSourceConfigurations moduleManager=...");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            BackendConnectionsModule backendConnectionsModule = (BackendConnectionsModule)moduleManager.getModuleById("backendconnection");
            for (ModuleInstance dataSourceInstance : backendConnectionsModule.getModuleInstancesByInstanceType("data_source")) {
                String dataSourceName = dataSourceInstance.getModuleId();
                Map<String, Setting> dataSourceSettings = dataSourceInstance.getConfiguration().getSettings();
                DataSourceSettings.addAsPaxJdbcDataSourceConfiguration(result, dataSourceName, dataSourceSettings);
            }
        }
        catch (ModuleNotFoundException ex) {
            Set<String> instanceIDs = moduleManager.readModuleInstanceIDs("backendconnection", "data_source");
            Iterator<String> iterator = instanceIDs.iterator();
            while (iterator.hasNext()) {
                String instanceID;
                String dataSourceName = instanceID = iterator.next();
                Map<String, Setting> dataSourceSettings = moduleManager.readModuleSettings("backendconnection", instanceID, "data_source");
                DataSourceSettings.addAsPaxJdbcDataSourceConfiguration(result, dataSourceName, dataSourceSettings);
            }
        }
        return result;
    }

    @NotNull
    public static List<Map<String, Object>> getAllPaxJdbcDataSourceConfigurationsExceptFromModuleInstanceId(BackendConnectionsModule backendConnectionsModule, String moduleInstanceId) {
        LOGGER.info("getAllPaxJdbcDataSourceConfigurationsExceptFromModuleInstanceId backendConnectionsModule=..., moduleInstanceId={}", (Object)moduleInstanceId);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (ModuleInstance dataSourceInstance : backendConnectionsModule.getModuleInstancesByInstanceType("data_source")) {
            if (moduleInstanceId != null && dataSourceInstance.getModuleId().equals(moduleInstanceId)) continue;
            String dataSourceName = dataSourceInstance.getModuleId();
            Map<String, Setting> dataSourceSettings = dataSourceInstance.getConfiguration().getSettings();
            DataSourceSettings.addAsPaxJdbcDataSourceConfiguration(result, dataSourceName, dataSourceSettings);
        }
        return result;
    }

    public static void addAsPaxJdbcDataSourceConfiguration(List<Map<String, Object>> target, String dataSourceName, Map<String, Setting> moduleInstanceSettings) {
        LOGGER.info("addAsPaxJdbcDataSourceConfiguration target=..., dataSourceName={}, moduleInstanceSettings=...", (Object)dataSourceName);
        if (dataSourceName != null && moduleInstanceSettings != null && !moduleInstanceSettings.isEmpty()) {
            Map<String, Object> paxJdbcDataSourceConfig = DataSourceSettings.asPaxJdbcDataSourceConfiguration(dataSourceName, moduleInstanceSettings);
            target.add(paxJdbcDataSourceConfig);
        }
    }

    public static Map<String, Object> asPaxJdbcDataSourceConfiguration(String dataSourceName, Map<String, Setting> moduleInstanceSettings) {
        Object dataSourceConfigurationObject;
        Setting dataSourceConfigurationSetting;
        Setting dataSourcePasswordSetting;
        Setting dataSourceUserSetting;
        Setting dataSourceUrlSetting;
        LOGGER.info("asPaxJdbcDataSourceConfiguration dataSourceName={}, moduleInstanceSettings=...", (Object)dataSourceName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("dataSourceName", dataSourceName);
        Setting dataSourceDriverNameSetting = moduleInstanceSettings.get("driverName");
        if (dataSourceDriverNameSetting != null) {
            result.put("osgi.jdbc.driver.name", dataSourceDriverNameSetting.getValue());
        }
        if ((dataSourceUrlSetting = moduleInstanceSettings.get("url")) != null) {
            result.put("url", dataSourceUrlSetting.getValue());
        }
        if ((dataSourceUserSetting = moduleInstanceSettings.get("user")) != null) {
            result.put("user", dataSourceUserSetting.getValue());
        }
        if ((dataSourcePasswordSetting = moduleInstanceSettings.get("password")) != null) {
            result.put("password", dataSourcePasswordSetting.getValue());
        }
        if ((dataSourceConfigurationSetting = moduleInstanceSettings.get("configuration")) != null && (dataSourceConfigurationObject = dataSourceConfigurationSetting.getValue()) instanceof Map) {
            result.putAll((Map)dataSourceConfigurationObject);
        }
        return result;
    }
}

