/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deeplink;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.core.deeplink.DeeplinkException;
import de.virtimo.bpc.core.deeplink.monitor.Filter;
import de.virtimo.bpc.core.deeplink.monitor.MonitorDeeplinkPart;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Deeplink {
    private static final Logger LOGGER = LogManager.getLogger(Deeplink.class);
    private final String bpcFrontendUrl;

    public Deeplink(String bpcFrontendUrl) {
        this.bpcFrontendUrl = bpcFrontendUrl;
    }

    public String getBpcFrontendUrl() {
        return this.bpcFrontendUrl;
    }

    public String createMonitorRedirectUrl(Set<String> monitorInstanceIDs, Map<String, String> queryParams) throws DeeplinkException, JsonProcessingException {
        LOGGER.debug("createMonitorRedirectUrl monitorInstanceIDs={}, queryParams={}", monitorInstanceIDs, queryParams);
        if (monitorInstanceIDs == null || monitorInstanceIDs.isEmpty()) {
            return this.createMonitorRedirectUrlToOpenNewMonitorWizard();
        }
        if (monitorInstanceIDs.size() > 1) {
            return this.createMonitorRedirectUrlToSelectMonitorInstance(monitorInstanceIDs, queryParams);
        }
        String monitorInstanceID = monitorInstanceIDs.iterator().next();
        return this.createMonitorRedirectUrlToOpenMonitor(monitorInstanceID, queryParams);
    }

    private String createMonitorRedirectUrlToOpenNewMonitorWizard() throws DeeplinkException {
        LOGGER.debug("createMonitorRedirectUrlToOpenNewMonitorWizard");
        throw new DeeplinkException((ErrorCode)CoreErrorCode.DEEPLINK_CREATION_FAILED, "Creating a deeplink when no related monitor instance exists, is not implemented yet.");
    }

    private String createMonitorRedirectUrlToSelectMonitorInstance(Set<String> monitorInstanceIDs, Map<String, String> queryParams) throws JsonProcessingException {
        LOGGER.debug("createMonitorRedirectUrlToSelectMonitorInstance monitorInstanceIDs={}, queryParams={}", monitorInstanceIDs, queryParams);
        String monitorIdsParam = "?instanceIds=" + String.join((CharSequence)",", monitorInstanceIDs);
        String title = queryParams != null ? queryParams.get("title") : null;
        String titleParam = title != null && !title.isEmpty() ? "&title=" + URLEncoder.encode(title, StandardCharsets.UTF_8) : "";
        String promptText = queryParams != null ? queryParams.get("promptText") : null;
        String promptTextParam = promptText != null && !promptText.isEmpty() ? "&promptText=" + URLEncoder.encode(promptText, StandardCharsets.UTF_8) : "";
        String encodedFilterParams = this.encodeFilterParams(queryParams);
        return this.bpcFrontendUrl + monitorIdsParam + titleParam + promptTextParam + "#/!-1/action/selectInstance" + encodedFilterParams;
    }

    private String createMonitorRedirectUrlToOpenMonitor(String monitorInstanceID, Map<String, String> queryParams) throws JsonProcessingException {
        LOGGER.debug("createMonitorRedirectUrlToOpenMonitor monitorInstanceID={}, queryParams={}", (Object)monitorInstanceID, queryParams);
        if (queryParams == null || queryParams.isEmpty()) {
            return this.bpcFrontendUrl + "?#/module/monitor/" + monitorInstanceID;
        }
        String encodedFilterParams = this.encodeFilterParams(queryParams);
        return this.bpcFrontendUrl + "?#/module/monitor/" + monitorInstanceID + encodedFilterParams;
    }

    private String encodeFilterParams(Map<String, String> queryParams) throws JsonProcessingException {
        if (queryParams == null || queryParams.isEmpty()) {
            return "";
        }
        MonitorDeeplinkPart deeplinkPart = new MonitorDeeplinkPart();
        queryParams.forEach((externalReferenceFieldName, externalReferenceFieldValue) -> {
            if (!"promptText".equals(externalReferenceFieldName) && !"title".equals(externalReferenceFieldName)) {
                deeplinkPart.getStoreState().addFilter(new Filter("externalReference." + externalReferenceFieldName, "=", externalReferenceFieldValue, false));
            }
        });
        String deeplinkPartAsJsonString = deeplinkPart.asJsonString();
        String base64EncodedDeeplinkPart = Base64.getEncoder().encodeToString(deeplinkPartAsJsonString.getBytes(StandardCharsets.UTF_8));
        return "//" + base64EncodedDeeplinkPart;
    }
}

