/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment;

import de.virtimo.bpc.core.deployment.DeploymentConstraintsEnricher;
import de.virtimo.bpc.core.deployment.DeploymentSettingsDiffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DeploymentDiffer {
    private static final Logger LOGGER = LogManager.getLogger(DeploymentDiffer.class);
    private final List<Map<String, Object>> sourceModules;
    private final List<Map<String, Object>> targetModules;

    public DeploymentDiffer(List<Map<String, Object>> sourceModules, List<Map<String, Object>> targetModules) {
        this.sourceModules = this.cleanup(sourceModules);
        this.targetModules = this.cleanup(targetModules);
    }

    public boolean isSourceAndTargetEqual() {
        LOGGER.info("isSourceAndTargetEqual");
        return this.sourceModules.equals(this.targetModules);
    }

    public Map<String, Object> getModulesDiff() {
        LOGGER.info("getModulesDiff");
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.isSourceAndTargetEqual()) {
            result.put("missingModulesOnTarget", this.evalIDsOfMissingModules(this.sourceModules, this.targetModules));
            result.put("missingModulesOnSource", this.evalIDsOfMissingModules(this.targetModules, this.sourceModules));
            result.put("modifiedModules", this.evalIDsOfModifiedModules(this.sourceModules, this.targetModules));
            result.put("modifiedModuleSettings", this.evalIDsOfModulesWithModifiedModuleSettings(this.sourceModules, this.targetModules));
            result.put("missingModuleInstancesOnTarget", this.evalIDsOfMissingModuleInstances((Set)result.get("modifiedModules"), this.sourceModules, this.targetModules));
            result.put("missingModuleInstancesOnSource", this.evalIDsOfMissingModuleInstances((Set)result.get("modifiedModules"), this.targetModules, this.sourceModules));
            result.put("modifiedModuleInstances", this.evalIDsOfModifiedModuleInstances((Set)result.get("modifiedModules"), this.targetModules, this.sourceModules));
        }
        return result;
    }

    @NotNull
    private List<Map<String, Object>> cleanup(List<Map<String, Object>> givenModules) {
        ArrayList<Map<String, Object>> modules = new ArrayList<Map<String, Object>>(givenModules);
        for (Map map : modules) {
            map.remove("instancesDefaultConfiguration");
            List moduleInstances = (List)map.get("instances");
            if (moduleInstances == null || moduleInstances.isEmpty()) continue;
            for (Map moduleInstance : moduleInstances) {
                moduleInstance.remove("instancesDefaultConfiguration");
            }
        }
        for (Map map : modules) {
            List moduleInstances;
            List moduleSettings = (List)map.get("settings");
            if (moduleSettings != null) {
                ArrayList<Map> nonDeployableModuleSettings = new ArrayList<Map>();
                for (Map moduleSetting : moduleSettings) {
                    if (!moduleSetting.containsKey("_nonDeployable") || !Boolean.TRUE.equals(moduleSetting.get("_nonDeployable"))) continue;
                    nonDeployableModuleSettings.add(moduleSetting);
                }
                moduleSettings.removeAll(nonDeployableModuleSettings);
            }
            if ((moduleInstances = (List)map.get("instances")) == null || moduleInstances.isEmpty()) continue;
            for (Map moduleInstance : moduleInstances) {
                ArrayList<Map> nonDeployableModuleInstanceSettings = new ArrayList<Map>();
                List moduleInstanceSettings = (List)moduleInstance.get("settings");
                for (Map moduleInstanceSetting : moduleInstanceSettings) {
                    if (!moduleInstanceSetting.containsKey("_nonDeployable") || !Boolean.TRUE.equals(moduleInstanceSetting.get("_nonDeployable"))) continue;
                    nonDeployableModuleInstanceSettings.add(moduleInstanceSetting);
                }
                moduleInstanceSettings.removeAll(nonDeployableModuleInstanceSettings);
            }
        }
        return modules;
    }

    private Map<String, Object> getModuleById(String moduleId, List<Map<String, Object>> modules) {
        if (moduleId != null && modules != null) {
            for (Map<String, Object> module : modules) {
                if (!module.get("moduleId").equals(moduleId)) continue;
                return module;
            }
        }
        return null;
    }

    private List<Map<String, Object>> getModuleInstances(String moduleId, List<Map<String, Object>> modules) {
        Map<String, Object> module;
        if (moduleId != null && modules != null && (module = this.getModuleById(moduleId, modules)) != null) {
            Object instances = module.get("instances");
            if (instances instanceof List) {
                return (List)instances;
            }
            if (instances != null) {
                LOGGER.error("Unexpected Java type found (expected a List) for module: {} ({})", (Object)moduleId, module);
            }
            return null;
        }
        return null;
    }

    private Map<String, Object> getModuleInstanceById(String moduleId, String moduleInstanceId, List<Map<String, Object>> modules) {
        if (moduleId != null && moduleInstanceId != null && modules != null) {
            return this.getModuleInstanceById(moduleInstanceId, this.getModuleInstances(moduleId, modules));
        }
        return null;
    }

    private Map<String, Object> getModuleInstanceById(String moduleInstanceId, List<Map<String, Object>> instances) {
        if (instances != null && !instances.isEmpty()) {
            for (Map<String, Object> instance : instances) {
                if (!instance.get("moduleId").equals(moduleInstanceId)) continue;
                return instance;
            }
        }
        return null;
    }

    @NotNull
    private Set<String> evalIDsOfModuleUsedOnSourceAndTarget(List<Map<String, Object>> srcModules, List<Map<String, Object>> destModules) {
        HashSet<String> result = new HashSet<String>();
        for (Map<String, Object> sourceModule : srcModules) {
            String moduleId = (String)sourceModule.get("moduleId");
            if (this.getModuleById(moduleId, destModules) == null) continue;
            result.add(moduleId);
        }
        return result;
    }

    @NotNull
    private Set<String> evalIDsOfModifiedModules(List<Map<String, Object>> sourceModules, List<Map<String, Object>> targetModules) {
        HashSet<String> result = new HashSet<String>();
        for (String moduleId : this.evalIDsOfModuleUsedOnSourceAndTarget(sourceModules, targetModules)) {
            Map<String, Object> targetModule;
            Map<String, Object> sourceModule = this.getModuleById(moduleId, sourceModules);
            if (this.areModulesEqual(sourceModule, targetModule = this.getModuleById(moduleId, targetModules))) continue;
            result.add(moduleId);
        }
        return result;
    }

    private boolean areModulesEqual(Map<String, Object> sourceModule, Map<String, Object> targetModule) {
        List targetModuleSettings;
        HashMap<String, Object> sourceModuleWithoutSettingsAndInstances = new HashMap<String, Object>(sourceModule);
        sourceModuleWithoutSettingsAndInstances.remove("settings");
        sourceModuleWithoutSettingsAndInstances.remove("instances");
        sourceModuleWithoutSettingsAndInstances.remove(DeploymentConstraintsEnricher.DEPLOYMENT_CONSTRAINT_FIELD_NAME);
        HashMap<String, Object> targetModuleWithoutSettingsAndInstances = new HashMap<String, Object>(targetModule);
        targetModuleWithoutSettingsAndInstances.remove("settings");
        targetModuleWithoutSettingsAndInstances.remove("instances");
        targetModuleWithoutSettingsAndInstances.remove(DeploymentConstraintsEnricher.DEPLOYMENT_CONSTRAINT_FIELD_NAME);
        if (!sourceModuleWithoutSettingsAndInstances.equals(targetModuleWithoutSettingsAndInstances)) {
            return false;
        }
        List sourceModuleSettings = (List)sourceModule.get("settings");
        DeploymentSettingsDiffer settingsDiffer = new DeploymentSettingsDiffer(sourceModuleSettings, targetModuleSettings = (List)targetModule.get("settings"));
        if (!settingsDiffer.areSettingsEqual()) {
            return false;
        }
        List sourceModuleInstances = (List)sourceModule.get("instances");
        List targetModuleInstances = (List)targetModule.get("instances");
        if (sourceModuleInstances == null && targetModuleInstances == null) {
            return true;
        }
        if (sourceModuleInstances == null || targetModuleInstances == null) {
            return false;
        }
        if (sourceModuleInstances.size() != targetModuleInstances.size()) {
            return false;
        }
        for (Map srcModuleInstance : sourceModuleInstances) {
            String srcModuleInstanceId = (String)srcModuleInstance.get("moduleId");
            Map<String, Object> targetModuleInstance = this.getModuleInstanceById(srcModuleInstanceId, targetModuleInstances);
            if (targetModuleInstance == null) {
                return false;
            }
            if (this.isModuleInstanceEqual(srcModuleInstance, targetModuleInstance)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private Set<String> evalIDsOfModulesWithModifiedModuleSettings(List<Map<String, Object>> sourceModules, List<Map<String, Object>> targetModules) {
        HashSet<String> result = new HashSet<String>();
        for (String moduleId : this.evalIDsOfModuleUsedOnSourceAndTarget(sourceModules, targetModules)) {
            List targetModuleSettings;
            Map<String, Object> sourceModule = this.getModuleById(moduleId, sourceModules);
            Map<String, Object> targetModule = this.getModuleById(moduleId, targetModules);
            List sourceModuleSettings = (List)sourceModule.get("settings");
            DeploymentSettingsDiffer settingsDiffer = new DeploymentSettingsDiffer(sourceModuleSettings, targetModuleSettings = (List)targetModule.get("settings"));
            if (settingsDiffer.areSettingsEqual()) continue;
            result.add(moduleId);
        }
        return result;
    }

    @NotNull
    private Set<String> evalIDsOfMissingModules(List<Map<String, Object>> sourceModules, List<Map<String, Object>> targetModules) {
        HashSet<String> result = new HashSet<String>();
        for (Map<String, Object> sourceModule : sourceModules) {
            String moduleId = (String)sourceModule.get("moduleId");
            if (this.getModuleById(moduleId, targetModules) != null) continue;
            result.add(moduleId);
        }
        return result;
    }

    @NotNull
    private Map<String, Set<String>> evalIDsOfMissingModuleInstances(Set<String> moduleIDsOfModifiedModules, List<Map<String, Object>> srcModules, List<Map<String, Object>> destModules) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String moduleId : moduleIDsOfModifiedModules) {
            List<Map<String, Object>> srcModuleInstances = this.getModuleInstances(moduleId, srcModules);
            if (srcModuleInstances == null || srcModuleInstances.isEmpty()) continue;
            HashSet<String> missingModuleInstancesOnDest = new HashSet<String>();
            for (Map<String, Object> srcModuleInstance : srcModuleInstances) {
                String srcModuleInstanceId = (String)srcModuleInstance.get("moduleId");
                if (this.getModuleInstanceById(moduleId, srcModuleInstanceId, destModules) != null) continue;
                missingModuleInstancesOnDest.add(srcModuleInstanceId);
            }
            if (missingModuleInstancesOnDest.isEmpty()) continue;
            result.put(moduleId, missingModuleInstancesOnDest);
        }
        return result;
    }

    @NotNull
    private Map<String, Set<String>> evalIDsOfModifiedModuleInstances(Set<String> moduleIDsOfModifiedModules, List<Map<String, Object>> srcModules, List<Map<String, Object>> destModules) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (String moduleId : moduleIDsOfModifiedModules) {
            List<Map<String, Object>> srcModuleInstances = this.getModuleInstances(moduleId, srcModules);
            if (srcModuleInstances == null || srcModuleInstances.isEmpty()) continue;
            HashSet<String> modifiedModuleInstances = new HashSet<String>();
            for (Map<String, Object> srcModuleInstance : srcModuleInstances) {
                String srcModuleInstanceId = (String)srcModuleInstance.get("moduleId");
                Map<String, Object> targetModuleInstance = this.getModuleInstanceById(moduleId, srcModuleInstanceId, destModules);
                if (targetModuleInstance == null || this.isModuleInstanceEqual(srcModuleInstance, targetModuleInstance)) continue;
                modifiedModuleInstances.add(srcModuleInstanceId);
            }
            if (modifiedModuleInstances.isEmpty()) continue;
            result.put(moduleId, modifiedModuleInstances);
        }
        return result;
    }

    private boolean isModuleInstanceEqual(Map<String, Object> srcModuleInstance, Map<String, Object> targetModuleInstance) {
        if (srcModuleInstance == null || targetModuleInstance == null) {
            return false;
        }
        HashMap<String, Object> srcModuleInstanceWithoutSettings = new HashMap<String, Object>(srcModuleInstance);
        srcModuleInstanceWithoutSettings.remove("settings");
        srcModuleInstanceWithoutSettings.remove(DeploymentConstraintsEnricher.DEPLOYMENT_CONSTRAINT_FIELD_NAME);
        HashMap<String, Object> targetModuleInstanceWithoutSettings = new HashMap<String, Object>(targetModuleInstance);
        targetModuleInstanceWithoutSettings.remove("settings");
        targetModuleInstanceWithoutSettings.remove(DeploymentConstraintsEnricher.DEPLOYMENT_CONSTRAINT_FIELD_NAME);
        if (!srcModuleInstanceWithoutSettings.equals(targetModuleInstanceWithoutSettings)) {
            return false;
        }
        List sourceModuleInstanceSettings = (List)srcModuleInstance.get("settings");
        List targetModuleInstanceSettings = (List)targetModuleInstance.get("settings");
        DeploymentSettingsDiffer settingsDiffer = new DeploymentSettingsDiffer(sourceModuleInstanceSettings, targetModuleInstanceSettings);
        return settingsDiffer.areSettingsEqual();
    }
}

