/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment;

import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.ConnectionTester;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.deployment.DeploymentSide;
import de.virtimo.bpc.core.deployment.DeploymentSystem;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeploymentSystemConnectionTester
implements ConnectionTester {
    private static final Logger LOGGER = LogManager.getLogger(DeploymentSystemConnectionTester.class);

    @Override
    public void destroy() {
        LOGGER.info("destroy");
    }

    @Override
    public boolean canBeUsedToPerformConnectionTest(ModuleInstance moduleInstance) {
        LOGGER.info("canBeUsedToPerformConnectionTest moduleInstance=...");
        return moduleInstance != null && "backendconnection".equalsIgnoreCase(moduleInstance.getParentModule().getModuleId()) && "deployment_system".equalsIgnoreCase(moduleInstance.getInstanceType());
    }

    @Override
    public void performConnectionTest(ModuleInstance moduleInstance, Map<String, Object> testData) throws ConnectionTestException {
        LOGGER.info("performConnectionTest moduleInstance=..., testData=...");
        DeploymentSystem deploymentSystem = null;
        try {
            deploymentSystem = new DeploymentSystem(DeploymentSide.Unknown, moduleInstance.getConfiguration());
            deploymentSystem.testConnection();
        }
        catch (Exception ex) {
            throw new ConnectionTestException(ex);
        }
        finally {
            if (deploymentSystem != null) {
                try {
                    deploymentSystem.destroy();
                }
                catch (Exception ex) {
                    LOGGER.warn("Failed to call destroy on the deployment system. This could leak a http client instance.", (Throwable)ex);
                }
            }
        }
    }
}

