/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.deployment.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.Settings;
import de.virtimo.bpc.api.deployment.resource.DeleteSettingOperation;
import de.virtimo.bpc.api.deployment.resource.SettingsToDeploy;
import de.virtimo.bpc.core.SettingsImpl;
import de.virtimo.bpc.core.deployment.resource.DeleteSettingOperationImpl;
import de.virtimo.bpc.module.simple.SimpleSettingImpl;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SettingsToDeployImpl
implements SettingsToDeploy {
    private static final Logger LOGGER = LogManager.getLogger(SettingsToDeployImpl.class);
    @JsonProperty(value="delete")
    @JsonDeserialize(contentAs=DeleteSettingOperationImpl.class)
    private List<DeleteSettingOperation> deleteSettingOperations;
    @JsonProperty(value="updateOrCreate")
    @JsonDeserialize(contentAs=SimpleSettingImpl.class)
    private List<Setting> settingsToUpdateOrCreate;

    private SettingsToDeployImpl() {
    }

    public SettingsToDeployImpl(List<DeleteSettingOperation> deleteSettingOperations, List<Setting> settingsToUpdateOrCreate) {
        this.deleteSettingOperations = deleteSettingOperations;
        this.settingsToUpdateOrCreate = settingsToUpdateOrCreate;
    }

    @Override
    @JsonIgnore
    public boolean hasDeleteSettingOperations() {
        return this.deleteSettingOperations != null && !this.deleteSettingOperations.isEmpty();
    }

    @Override
    public List<DeleteSettingOperation> getDeleteSettingOperations() {
        return this.deleteSettingOperations;
    }

    @Override
    @JsonIgnore
    public boolean hasSettingsToUpdateOrCreate() {
        return this.settingsToUpdateOrCreate != null && !this.settingsToUpdateOrCreate.isEmpty();
    }

    @Override
    public List<Setting> getListOfSettingsToUpdateOrCreate() {
        return this.settingsToUpdateOrCreate;
    }

    @Override
    @JsonIgnore
    public Settings getSettingsToUpdateOrCreate() {
        return new SettingsImpl(this.settingsToUpdateOrCreate);
    }

    @Override
    @JsonIgnore
    public Set<String> getRelatedModuleIDs() {
        LOGGER.info("getRelatedModuleIDs");
        HashSet<String> result = new HashSet<String>();
        if (this.hasDeleteSettingOperations()) {
            for (DeleteSettingOperation deleteOperation : this.getDeleteSettingOperations()) {
                result.add(deleteOperation.getModuleId());
            }
        }
        if (this.hasSettingsToUpdateOrCreate()) {
            result.addAll(this.getSettingsToUpdateOrCreate().getModuleIDs());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SettingsToDeployImpl that = (SettingsToDeployImpl)o;
        return Objects.equals(this.deleteSettingOperations, that.deleteSettingOperations) && Objects.equals(this.settingsToUpdateOrCreate, that.settingsToUpdateOrCreate);
    }

    public int hashCode() {
        return Objects.hash(this.deleteSettingOperations, this.settingsToUpdateOrCreate);
    }

    public String toString() {
        return "SettingsToDeployImpl{deleteSettingOperations=" + String.valueOf(this.deleteSettingOperations) + ", settingsToUpdateOrCreate=" + String.valueOf(this.settingsToUpdateOrCreate) + "}";
    }
}

