/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.fewrapper;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.fewrapper.FeWrapperModule;
import de.virtimo.bpc.core.fewrapper.FeWrapperService;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class FeWrapperServiceImpl
implements FeWrapperService,
BpcService,
BundleListener {
    private static final Logger LOGGER = LogManager.getLogger(FeWrapperServiceImpl.class);
    private final BundleContext bundleContext;
    private final BpcServicesTracker<ModuleManager> moduleManagerServiceTracker;
    private final Map<Bundle, Module> bundleModuleMap;

    public FeWrapperServiceImpl(BundleContext bundleContext) {
        LOGGER.debug("FeWrapperServiceImpl");
        this.bundleContext = bundleContext;
        this.moduleManagerServiceTracker = new BpcServicesTracker<ModuleManager>(bundleContext, ModuleManager.class);
        this.bundleModuleMap = this.getFeOnlyBundles();
        bundleContext.addBundleListener((BundleListener)this);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.debug("shutdownService");
        if (this.bundleContext != null) {
            this.bundleContext.removeBundleListener((BundleListener)this);
        }
        BpcServicesTracker.stopAll(this);
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        LOGGER.debug("bundleChanged bundleEvent=...");
        Bundle bundle = bundleEvent.getBundle();
        if (FeWrapperModule.isFeOnlyBundle(bundle).booleanValue()) {
            try {
                ModuleManager moduleManager = this.moduleManagerServiceTracker.getService();
                switch (bundleEvent.getType()) {
                    case 2: {
                        LOGGER.info("Found started FE only bundle, wrap in FeWrapperModule - {}", (Object)bundle);
                        FeWrapperModule newModule = new FeWrapperModule(moduleManager, bundle);
                        this.bundleModuleMap.put(bundle, newModule);
                        moduleManager.loadModule(newModule);
                        break;
                    }
                    case 4: {
                        LOGGER.info("Found stopped FE only bundle, unload FeWrapperModule - {}", (Object)bundle);
                        Module module = this.bundleModuleMap.get(bundle);
                        if (module == null) break;
                        this.bundleModuleMap.remove(bundle);
                        moduleManager.unloadModule(module);
                    }
                }
            }
            catch (SettingException | ServiceNotFoundException ex) {
                LOGGER.error("Error during bundleChanged", (Throwable)ex);
            }
        }
    }

    private Map<Bundle, Module> getFeOnlyBundles() {
        LOGGER.debug("getFeOnlyBundles");
        HashMap<Bundle, Module> bundleModuleMap = new HashMap<Bundle, Module>();
        try {
            ModuleManager moduleManager = this.moduleManagerServiceTracker.getService();
            for (Bundle bundle : this.bundleContext.getBundles()) {
                if (!FeWrapperModule.isFeOnlyBundle(bundle).booleanValue()) continue;
                if (bundle.getState() == 32) {
                    LOGGER.info("Active FE only bundle found, wrap in FeWrapperModule - {}", (Object)bundle);
                    FeWrapperModule newModule = new FeWrapperModule(moduleManager, bundle);
                    bundleModuleMap.put(bundle, newModule);
                    moduleManager.loadModule(newModule);
                    continue;
                }
                LOGGER.info("Skipping not active FE only bundle for now. Gets loaded when started - {}", (Object)bundle);
            }
        }
        catch (SettingException | ServiceNotFoundException ex) {
            LOGGER.error("Error during getFeOnlyBundles", (Throwable)ex);
        }
        return bundleModuleMap;
    }
}

